/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.identity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.main.WeaponsOfMinecraft;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class LunaticVivacitySkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("0a76eeed-a4e0-49d3-832c-a9c1e68b2b41");

    public LunaticVivacitySkill(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, EVENT_UUID, event -> {
            if (event.getPlayerPatch().getTarget() != null) {
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 200) {
                    event.setAmount(event.getAmount() * 0.15f);
                } else {
                    event.setAmount(event.getAmount() * 1.85f);
                }
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        OwnableEntity ownedTarget;
        LivingEntity livingEntity;
        boolean active;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int time = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get());
        boolean bl = active = container.getExecutor().getTarget() != null && (livingEntity = container.getExecutor().getTarget()) instanceof OwnableEntity && (ownedTarget = (OwnableEntity)livingEntity).m_269323_() != null && !ownedTarget.m_269323_().equals((Object)container.getExecutor().getOriginal());
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) < 200) {
            if (active) {
                RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)0.8f);
            } else {
                RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
            }
            guiGraphics.m_280411_(WeaponsOfMinecraft.identifier("textures/gui/skills/identity/lunatic_vivacity.png"), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        } else {
            if (active) {
                RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
            }
            guiGraphics.m_280411_(WeaponsOfMinecraft.identifier("textures/gui/skills/identity/lunatic_vivacity_unleashed.png"), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
            time -= 200;
        }
        String string = String.valueOf(time / 20 + "." + time % 20 / 2);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.drawString(gui.getFont(), string, x + 13.0f - (float)(gui.getFont().m_92895_(string) / 2), y + 10.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        OwnableEntity ownedTarget;
        LivingEntity livingEntity;
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient() && (container.getExecutor().getTarget() != null || (livingEntity = container.getExecutor().getTarget()) instanceof OwnableEntity && (ownedTarget = (OwnableEntity)livingEntity).m_269323_() != null && !ownedTarget.m_269323_().equals((Object)container.getExecutor().getOriginal()))) {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) - 1));
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)400);
            }
        }
    }
}

