/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.guard;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.ReuseableEvents;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.animations.weapons.AnimsAgony;
import reascer.wom.gameasset.animations.weapons.AnimsHerrscher;
import reascer.wom.gameasset.animations.weapons.AnimsMoonless;
import reascer.wom.gameasset.animations.weapons.AnimsRuine;
import reascer.wom.gameasset.animations.weapons.AnimsSatsujin;
import reascer.wom.gameasset.animations.weapons.AnimsSolar;
import reascer.wom.gameasset.colliders.WOMWeaponColliders;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.capabilities.item.GesetzCapability;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.GuardAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.TakeDamageEvent;

public class CounterAttack
extends GuardSkill {
    private static final UUID EVENT_UUID = UUID.fromString("ad8def54-20a4-4806-be95-ce3f5054627c");

    public static GuardSkill.Builder createCounterAttackBuilder() {
        return GuardSkill.createGuardBuilder().addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SWORD, (itemCap, playerpatch) -> itemCap.getStyle((LivingEntityPatch)playerpatch) == CapabilityItem.Styles.ONE_HAND ? (itemCap.getWeaponCollider().equals(WOMWeaponColliders.HERSCHER) ? AnimsHerrscher.HERRSCHER_TRANE : Animations.SWEEPING_EDGE) : Animations.SWORD_DUAL_AUTO3).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.LONGSWORD, (itemCap, playerpatch) -> Animations.LONGSWORD_DASH).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.TACHI, (itemCap, playerpatch) -> Animations.RUSHING_TEMPO2).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SPEAR, (itemCap, playerpatch) -> Animations.GRASPING_SPIRAL_SECOND).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.UCHIGATANA, (itemCap, playerpatch) -> Animations.UCHIGATANA_SHEATHING_DASH).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.GREATSWORD, (itemCap, playerpatch) -> Animations.GREATSWORD_DASH).addGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SHIELD, (itemCap, playerpatch) -> {
            if (playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability) {
                if (playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)playerpatch) == CapabilityItem.Styles.COMMON) {
                    return AnimsHerrscher.HERRSCHER_MAHER_HOLD_HIT;
                }
                return AnimsHerrscher.HERRSCHER_GUARD_HIT;
            }
            return Animations.BIPED_HIT_SHIELD;
        }).addGuardBreakMotion((WeaponCategory)CapabilityItem.WeaponCategories.SHIELD, (itemCap, playerpatch) -> Animations.BIPED_COMMON_NEUTRALIZED).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SHIELD, (itemCap, playerpatch) -> playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability ? AnimsHerrscher.HERRSCHER_TRANE : Animations.SWEEPING_EDGE);
    }

    public CounterAttack(GuardSkill.Builder builder) {
        super(builder);
    }

    public void setPenalizer(float penalizer) {
        this.penalizer = penalizer;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, GuardSkill.EVENT_UUID, 1);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD)) {
                ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get()) > 20) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARRYING.get(), (Object)false);
            }
            if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.PARRYING.get())).booleanValue() && ((ServerPlayerPatch)event.getPlayerPatch()).getStamina() > 0.0f) {
                if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get()) > 20 && !((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21255_() && ((ServerPlayerPatch)event.getPlayerPatch()).currentLivingMotion != LivingMotions.FALL && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canUseSkill() && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack()) {
                    AnimationManager.AnimationAccessor<GuardAnimation> animation = switch (new Random().nextInt() % 3) {
                        case 0 -> Animations.SWORD_GUARD_ACTIVE_HIT1;
                        case 1 -> Animations.SWORD_GUARD_ACTIVE_HIT2;
                        case 2 -> Animations.SWORD_GUARD_ACTIVE_HIT3;
                        default -> Animations.SWORD_GUARD_ACTIVE_HIT1;
                    };
                    if (itemCapability.getStyle((LivingEntityPatch)event.getPlayerPatch()) == CapabilityItem.Styles.TWO_HAND) {
                        AnimationManager.AnimationAccessor<GuardAnimation> animationAccessor = animation = new Random().nextBoolean() ? Animations.LONGSWORD_GUARD_ACTIVE_HIT1 : Animations.LONGSWORD_GUARD_ACTIVE_HIT2;
                    }
                    if (itemCapability.getWeaponCollider() == ColliderPreset.GREATSWORD) {
                        animation = Animations.GREATSWORD_GUARD_HIT;
                    }
                    if (itemCapability.getWeaponCollider() == ColliderPreset.SPEAR) {
                        animation = Animations.SPEAR_GUARD_HIT;
                    }
                    if (itemCapability.getWeaponCollider() == ColliderPreset.UCHIGATANA) {
                        animation = Animations.UCHIGATANA_GUARD_HIT;
                    }
                    if (itemCapability.getWeaponCollider() == WOMWeaponColliders.STAFF) {
                        animation = Animations.SPEAR_GUARD_HIT;
                    }
                    float convert = -0.05f;
                    if (itemCapability.getWeaponCollider() == WOMWeaponColliders.AGONY || itemCapability.getWeaponCollider() == WOMWeaponColliders.ORBIT) {
                        animation = AnimsAgony.AGONY_GUARD_HIT_1;
                    }
                    if (itemCapability.getWeaponCollider() == WOMWeaponColliders.RUINE) {
                        animation = AnimsRuine.RUINE_BLOCK_1;
                    }
                    if (itemCapability.getWeaponCollider() == WOMWeaponColliders.SATSUJIN) {
                        animation = AnimsSatsujin.SATSUJIN_GUARD_HIT;
                        convert = -0.15f;
                    }
                    if (itemCapability.getWeaponCollider() == WOMWeaponColliders.HERSCHER && ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability) {
                        animation = AnimsHerrscher.HERRSCHER_GUARD_PARRY;
                    }
                    if (itemCapability.getWeaponCollider() == WOMWeaponColliders.MOONLESS) {
                        animation = AnimsMoonless.MOONLESS_GUARD_HIT_1;
                    }
                    if (itemCapability.getWeaponCollider() == WOMWeaponColliders.SOLAR) {
                        animation = AnimsSolar.SOLAR_GUARD_PARRY;
                    }
                    ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill((Skill)this, Skill.Resource.STAMINA, 3.0f, true, null);
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.CLASH.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.0f, 2.0f);
                    ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, convert);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get(), (Object)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARRYING.get(), (Object)true);
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                } else if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack()) {
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.0f, 2.0f);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get(), (Object)(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - 4));
                }
            }
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && (((ServerPlayerPatch)event.getPlayerPatch()).getStamina() == 0.0f || ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get()) > 10) && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack()) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.0f, 2.0f);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get(), (Object)(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - 4));
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7655_());
            if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get()) < 10 && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.PARRYING.get())).booleanValue()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARRYING.get(), (Object)false);
                DamageSource damageSource = event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    float impact = 0.5f;
                    float knockback = 0.25f;
                    if (event.getDamageSource() instanceof EpicFightDamageSource) {
                        impact = ((EpicFightDamageSource)event.getDamageSource()).calculateImpact();
                        knockback += Math.min(impact * 0.1f, 1.0f);
                    }
                    this.guard(container, itemCapability, (TakeDamageEvent.Attack)event, knockback, impact, false);
                }
            } else if (super.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6117_()) {
                DamageSource damageSource = event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    float impact = 0.5f;
                    float knockback = 0.25f;
                    if (event.getDamageSource() instanceof EpicFightDamageSource) {
                        impact = ((EpicFightDamageSource)event.getDamageSource()).calculateImpact();
                        knockback += Math.min(impact * 0.1f, 1.0f);
                    }
                    this.guard(container, itemCapability, (TakeDamageEvent.Attack)event, knockback, impact, false);
                }
            }
        }, 2);
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, 2);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        super.onRemoved(container);
    }

    public void guard(SkillContainer container, CapabilityItem itemCapability, TakeDamageEvent.Attack event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource;
        if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && this.isBlockableSource(damageSource = event.getDamageSource(), true)) {
            float convert;
            ServerPlayer playerentity = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            int timing = playerentity.f_19797_ - (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get());
            boolean successParrying = timing < 10;
            float penalty = ((Float)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PENALTY.get())).floatValue();
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
            ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)playerentity.m_9236_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.m_7640_());
            boolean isShield = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21206_().m_41720_() instanceof ShieldItem;
            if (successParrying) {
                penalty = this.getPenalizer(itemCapability) * (isShield ? 0.5f : 1.0f) * ((float)timing / 10.0f);
                knockback *= 0.4f;
            } else {
                container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PENALTY.get(), (Object)Float.valueOf(penalty += this.getPenalizer(itemCapability) * (isShield ? 0.5f : 1.0f)));
            }
            if (damageSource.m_7640_() instanceof LivingEntity) {
                knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)((LivingEntity)damageSource.m_7640_())) * 0.1f;
            }
            ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
            if (container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get()) != null && ((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get())).floatValue() != 0.0f) {
                penalty *= ((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get())).floatValue();
            }
            boolean enoughStamina = true;
            if (penalty > 0.0f) {
                enoughStamina = ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill((Skill)this, Skill.Resource.STAMINA, penalty * impact);
            } else {
                container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PENALTY.get(), (Object)Float.valueOf(penalty));
                enoughStamina = true;
            }
            GuardSkill.BlockType blockType = successParrying ? GuardSkill.BlockType.ADVANCED_GUARD : (enoughStamina ? GuardSkill.BlockType.GUARD : GuardSkill.BlockType.GUARD_BREAK);
            AnimationManager.AnimationAccessor<? extends StaticAnimation> animation = this.getGuardMotion(container, event.getPlayerPatch(), itemCapability, blockType);
            float f = timing <= 2 ? -0.15f : (convert = timing < 5 ? 0.0f : 0.15f);
            if (animation == Animations.RUSHING_TEMPO2) {
                float f2 = timing <= 2 ? -0.1f : (convert = timing < 5 ? 0.0f : 0.15f);
            }
            if (animation == Animations.SWEEPING_EDGE) {
                float f3 = timing <= 2 ? -0.1f : (convert = timing < 5 ? 0.0f : 0.15f);
            }
            if (blockType == GuardSkill.BlockType.GUARD) {
                convert = 0.0f;
            }
            if (animation != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, convert);
            }
            if (successParrying) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.CLASH.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.4f, 1.3f);
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.BLUNT_HIT.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.8f, 0.5f);
                ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)playerentity.m_9236_(), HitParticleType.MIDDLE_OF_ENTITIES, HitParticleType.CENTER_OF_TARGET, (Entity)playerentity, damageSource.m_7640_());
                Vec2f facing = ReuseableEvents.getYawPitchF(playerentity.m_146892_(), event.getDamageSource().m_7639_().m_146892_());
                Vec3f offset = new Vec3f(ReuseableEvents.getPointInDirection(facing.y, -facing.x, 1.0).m_82520_(0.0, (double)(playerentity.m_20206_() / 2.0f), 0.0));
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123747_, ((Player)container.getExecutor().getOriginal()).m_20185_() + (double)offset.x, ((Player)container.getExecutor().getOriginal()).m_20186_() + (double)offset.y, ((Player)container.getExecutor().getOriginal()).m_20189_() + (double)offset.z, 1, 0.0, 0.0, 0.0, 0.5);
                ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 4, 4, true, false, false));
                ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 20, 0, true, false, false));
            }
            if (blockType == GuardSkill.BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent(event.getPlayerPatch(), event, advanced);
            if (successParrying) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20334_(0.0, 0.0, 0.0);
            }
            return;
        }
    }

    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return (damageSource.m_276093_(DamageTypes.f_268482_) && advanced || damageSource.m_276093_(DamageTypes.f_268684_) && advanced || damageSource.m_269533_(DamageTypeTags.f_268415_) && advanced || damageSource.m_269533_(DamageTypeTags.f_268524_) && advanced || damageSource.m_276093_(DamageTypes.f_268428_) && advanced || damageSource.m_276093_(DamageTypes.f_268448_) && advanced || damageSource.m_276093_(DamageTypes.f_268679_) && advanced || damageSource.m_276093_(DamageTypes.f_268656_) && advanced || damageSource.m_276093_(DamageTypes.f_268714_) && advanced || damageSource.m_276093_(DamageTypes.f_268641_) && advanced || damageSource.m_276093_(DamageTypes.f_268556_) && advanced || super.isBlockableSource(damageSource, false)) && !damageSource.m_269533_(EpicFightDamageTypeTags.GUARD_PUNCTURE);
    }

    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardMotion(SkillContainer container, PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType) {
        if (blockType == GuardSkill.BlockType.ADVANCED_GUARD) {
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.AGONY || itemCapability.getWeaponCollider() == WOMWeaponColliders.ORBIT) {
                return AnimsAgony.AGONY_COUNTER;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.SATSUJIN) {
                return AnimsSatsujin.SATSUJIN_SHEATHED_COUNTER;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.RUINE) {
                return AnimsRuine.RUINE_PUNITION;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.MOONLESS) {
                return AnimsMoonless.MOONLESS_REWINDER;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.STAFF) {
                return WOMAnimations.STAFF_DASH;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.SOLAR) {
                return AnimsSolar.SOLAR_GUARD_COUNTER;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.GREATSWORD) {
                return Animations.GREATSWORD_DASH;
            }
            AnimationManager.AnimationAccessor motion = (AnimationManager.AnimationAccessor)this.getGuardMotionMap(blockType).getOrDefault(itemCapability.getWeaponCategory(), (a, b) -> null).apply(itemCapability, playerpatch);
            if (motion != null) {
                return motion;
            }
        }
        if (blockType == GuardSkill.BlockType.GUARD) {
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.AGONY || itemCapability.getWeaponCollider() == WOMWeaponColliders.ORBIT) {
                return new Random().nextBoolean() ? AnimsAgony.AGONY_GUARD_HIT_1 : AnimsAgony.AGONY_GUARD_HIT_2;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.SATSUJIN) {
                return AnimsSatsujin.SATSUJIN_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.RUINE) {
                switch (new Random().nextInt(0, 2)) {
                    case 0: {
                        return AnimsRuine.RUINE_BLOCK_1;
                    }
                    case 1: {
                        return AnimsRuine.RUINE_BLOCK_2;
                    }
                }
                return AnimsRuine.RUINE_BLOCK_1;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.SOLAR) {
                return AnimsSolar.SOLAR_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.MOONLESS) {
                switch (new Random().nextInt() % 3) {
                    case 0: {
                        return AnimsMoonless.MOONLESS_GUARD_HIT_1;
                    }
                    case 1: {
                        return AnimsMoonless.MOONLESS_GUARD_HIT_2;
                    }
                    case 2: {
                        return AnimsMoonless.MOONLESS_GUARD_HIT_3;
                    }
                }
                return AnimsMoonless.MOONLESS_GUARD_HIT_1;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.HERSCHER && playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability) {
                if (itemCapability.getStyle(playerpatch) == CapabilityItem.Styles.COMMON) {
                    return AnimsHerrscher.HERRSCHER_MAHER_HOLD_HIT;
                }
                return AnimsHerrscher.HERRSCHER_GUARD_HIT;
            }
        }
        return super.getGuardMotion(container, playerpatch, itemCapability, blockType);
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.PARRYING;
    }

    protected boolean isAdvancedGuard() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.clear();
        list.add(String.format("%s, %s, %s, %s, %s, %s, %s, %s", new Object[]{CapabilityItem.WeaponCategories.GREATSWORD, CapabilityItem.WeaponCategories.UCHIGATANA, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.SWORD, CapabilityItem.WeaponCategories.TACHI, CapabilityItem.WeaponCategories.SPEAR, WOMWeaponCategories.AGONY, WOMWeaponCategories.RUINE, WOMWeaponCategories.STAFF}).toLowerCase());
        return list;
    }
}

