/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.dodges;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.particle.ParticlesTools;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class RavangerForceSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("0c413ee2-663b-4d30-8e27-e3217fb45aa1");

    public static Builder createChargeBuilder() {
        return (Builder)new Builder().setCategory((SkillCategory)SkillCategories.DODGE).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.STAMINA);
    }

    public RavangerForceSkill(Builder builder) {
        super((SkillBuilder)builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            if (((Player)container.getExecutor().getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                event.attachValueModifier(ValueModifier.multiplier((float)0.4f));
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID);
    }

    public void executeOnClient(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnClient(container, args);
        ((Player)container.getExecutor().getOriginal()).m_9236_().m_6263_((Player)container.getExecutor().getOriginal(), ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.SLAM_LIGHT.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 0.1f, 1.6f + (new Random().nextFloat() - 0.5f) * 0.4f);
        ParticlesTools.particle_circle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.5f), container.getExecutor(), ((Player)container.getExecutor().getOriginal()).m_9236_(), null, 50, 1.2f, 0.0f, 0.0f, new Vec3f(0.0f, 0.8f, 0.0f), null, new Vec2f(container.getExecutor().getYRot(), 0.0f), false, false);
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 26, 0, false, false, false));
        container.getExecutor().playAnimationSynchronized(WOMAnimations.RAVANGER_CHARGE, 0.0f);
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.ROLL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgs(List<Object> list) {
        list.add(ItemStack.f_41584_.format(this.consumption));
        return list;
    }

    public static class Builder
    extends SkillBuilder<RavangerForceSkill> {
        public Builder setAnimations(AssetAccessor<? extends StaticAnimation> animations) {
            return this;
        }
    }
}

