/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.dodges;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import reascer.wom.gameasset.ReuseableEvents;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.particle.ParticlesTools;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class PunishmentKickSkill
extends DodgeSkill {
    private static final UUID EVENT_UUID = UUID.fromString("e8768940-41a1-401f-b3ea-83adf7753c99");

    public PunishmentKickSkill(DodgeSkill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)event.getTarget(), LivingEntityPatch.class);
            if (targetPatch != null && event.getDamageSource().getAnimation().equals(WOMAnimations.STRONG_KICK) && !targetPatch.isStunned() && !targetPatch.getEntityState().attacking() && !targetPatch.getEntityState().canBasicAttack()) {
                Boolean no_blackout_tag = true;
                for (String tag : event.getTarget().m_19880_()) {
                    if (!tag.contains("WoM_blackout")) continue;
                    no_blackout_tag = false;
                    break;
                }
                if (no_blackout_tag.booleanValue()) {
                    event.getTarget().m_20049_("WoM_blackout");
                }
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.BLUNT_HIT.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.8f, 0.5f);
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 0.6f, 2.5f);
                ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_(), HitParticleType.MIDDLE_OF_ENTITIES, HitParticleType.CENTER_OF_TARGET, ((ServerPlayerPatch)event.getPlayerPatch()).getOriginal(), (Entity)event.getTarget());
                Vec2f facing = ReuseableEvents.getYawPitchF(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_146892_(), event.getTarget().m_146892_());
                Vec3f offset = new Vec3f(ReuseableEvents.getPointInDirection(facing.y, -facing.x, 1.0).m_82520_(0.0, (double)(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20206_() / 2.0f), 0.0));
                ParticlesTools.particle_circle_server((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 1.0f), 1.0f), event.getPlayerPatch(), ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_284548_(), null, 50, 1.6f, 0.01f, 0.5f, offset, null, facing, false, false);
                ParticlesTools.particle_circle_server((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 1.0f), 1.0f), event.getPlayerPatch(), ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_284548_(), null, 30, 0.8f, 0.01f, 0.5f, offset, null, facing, false, false);
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123747_, ((Player)container.getExecutor().getOriginal()).m_20185_() + (double)offset.x, ((Player)container.getExecutor().getOriginal()).m_20186_() + (double)offset.y, ((Player)container.getExecutor().getOriginal()).m_20189_() + (double)offset.z, 1, 0.0, 0.0, 0.0, 0.5);
                ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 5, 2, true, false, false));
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, EVENT_UUID);
    }

    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        skillContainer.getExecutor().playAnimationSynchronized(WOMAnimations.STRONG_KICK, 0.0f);
        skillContainer.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)120);
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        if ((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) == 0) {
            return true;
        }
        ((Player)executer.getOriginal()).m_5496_(SoundEvents.f_12031_, 1.0f, 2.0f);
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getSkillTexture());
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        String damage = String.valueOf((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) / 20 + 1);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.drawString(gui.getFont(), damage, x + 9.0f, y + 7.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.m_237115_((String)"attribute.name.epicfight.cooldown.consume.tooltip"), (Component)Component.m_237110_((String)"attribute.name.epicfight.cooldown.consume", (Object[])new Object[]{ItemStack.f_41584_.format(6.0)}), SkillBookScreen.COOLDOWN_TEXTURE_INFO);
        consumptionList.add((Component)Component.m_237115_((String)"attribute.name.epicfight.stamina.consume.tooltip"), (Component)Component.m_237110_((String)"attribute.name.epicfight.stamina.consume", (Object[])new Object[]{ItemStack.f_41584_.format(this.consumption)}), SkillBookScreen.STAMINA_TEXTURE_INFO);
        return true;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient() && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1));
        }
    }
}

