/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.client.renderer.entity.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import reascer.wom.client.model.mob.HollowModel;
import reascer.wom.main.WeaponsOfMinecraft;
import reascer.wom.world.entity.client.ModModelLayers;
import reascer.wom.world.entity.mob.Hollow;

public class HollowRenderer
extends MobRenderer<Hollow, HollowModel> {
    private static final ResourceLocation TEXTURE_FULL = WeaponsOfMinecraft.identifier("textures/entity/hollow_texture.png");
    private static final ResourceLocation TEXTURE_STRIPED_ONE = WeaponsOfMinecraft.identifier("textures/entity/hollow_texture_1.png");
    private static final ResourceLocation TEXTURE_STRIPED_TWO = WeaponsOfMinecraft.identifier("textures/entity/hollow_texture_2.png");
    private static final ResourceLocation TEXTURE_STRIPED_THREE = WeaponsOfMinecraft.identifier("textures/entity/hollow_texture_3.png");
    private static final ResourceLocation TEXTURE_STRIPED_FOUR = WeaponsOfMinecraft.identifier("textures/entity/hollow_texture_4.png");

    public HollowRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HollowModel(context.m_174023_(ModModelLayers.HOLLOW_LAYER)), 0.8f);
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
    }

    public void render(Hollow pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(Hollow hollow) {
        int resistance = hollow.getResistance();
        switch (resistance) {
            case 0: {
                return TEXTURE_FULL;
            }
            case 1: {
                return TEXTURE_STRIPED_ONE;
            }
            case 2: {
                return TEXTURE_STRIPED_TWO;
            }
            case 3: {
                return TEXTURE_STRIPED_THREE;
            }
        }
        return TEXTURE_STRIPED_FOUR;
    }
}

