/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.animation.attacks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import reascer.wom.animation.attacks.BasicMultipleAttackAnimation;
import reascer.wom.gameasset.ReuseableEvents;
import reascer.wom.gameasset.colliders.WOMWeaponColliders;
import reascer.wom.world.entity.WOMEntities;
import reascer.wom.world.entity.projectile.EnderBullet;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.camera.EpicFightCameraAPI;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class EnderblasterShootAttackAnimation
extends BasicMultipleAttackAnimation {
    public EnderblasterShootAttackAnimation(float convertTime, float antic, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends EnderblasterShootAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(convertTime, antic, antic, contact, recovery, collider, colliderJoint, accessor, armature);
    }

    public EnderblasterShootAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends EnderblasterShootAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(convertTime, accessor, armature, new AttackAnimation.Phase[]{new AttackAnimation.Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, colliderJoint, collider)});
    }

    public EnderblasterShootAttackAnimation(float convertTime, float antic, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends EnderblasterShootAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(convertTime, accessor, armature, new AttackAnimation.Phase[]{new AttackAnimation.Phase(0.0f, antic, antic, contact, recovery, Float.MAX_VALUE, hand, colliderJoint, collider)});
    }

    public EnderblasterShootAttackAnimation(float convertTime, AnimationManager.AnimationAccessor<? extends EnderblasterShootAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(convertTime, accessor, armature, phases);
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, (self, pose, entitypatch, time, partialTicks) -> {
            PlayerPatch playerpatch;
            if (!self.isStaticAnimation() || entitypatch instanceof PlayerPatch && (playerpatch = (PlayerPatch)entitypatch).isFirstPerson()) {
                return;
            }
            float pitch = entitypatch.getAttackDirectionPitch();
            JointTransform chest = pose.orElseEmpty("Chest");
            chest.frontResult(JointTransform.rotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mulAsOriginInverse);
            if (entitypatch instanceof PlayerPatch) {
                float xRot = MathUtils.lerpBetween((float)((LivingEntity)entitypatch.getOriginal()).f_19860_, (float)((LivingEntity)entitypatch.getOriginal()).m_146909_(), (float)partialTicks);
                OpenMatrix4f toOriginalRotation = entitypatch.getArmature().getBoundTransformFor(pose, entitypatch.getArmature().searchJointByName("Head")).removeScale().removeTranslation().invert();
                Vec3f xAxis = OpenMatrix4f.transform3v((OpenMatrix4f)toOriginalRotation, (Vec3f)Vec3f.X_AXIS, null);
                OpenMatrix4f headRotation = OpenMatrix4f.createRotatorDeg((float)(-(pitch + xRot)), (Vec3f)xAxis);
                pose.orElseEmpty("Head").frontResult(JointTransform.fromMatrix((OpenMatrix4f)headRotation), OpenMatrix4f::mul);
            }
        });
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor());
        float elapsedTime = player.getElapsedTime();
        float prevElapsedTime = player.getPrevElapsedTime();
        EntityState state = this.getState(entitypatch, elapsedTime);
        EntityState prevState = this.getState(entitypatch, prevElapsedTime);
        AttackAnimation.Phase phase = this.getPhaseByTime(elapsedTime);
        if (state.getLevel() == 1 && !state.turningLocked() && entitypatch instanceof MobPatch) {
            ((Mob)entitypatch.getOriginal()).m_21573_().m_26573_();
            ((LivingEntity)entitypatch.getOriginal()).f_20921_ = 2.0f;
            LivingEntity target = entitypatch.getTarget();
            if (target != null) {
                entitypatch.rotateTo((Entity)target, entitypatch.getYRotLimit(), false);
            }
        }
        if ((prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2) && (!prevState.attacking() || phase != this.getPhaseByTime(prevElapsedTime) && (state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2))) {
            Joint joint = (Joint)phase.colliders[0].getFirst();
            Collider collider = (Collider)phase.colliders[0].getSecond();
            if (entitypatch.isLogicalClient() && joint != ((HumanoidArmature)Armatures.BIPED.get()).head && joint != ((HumanoidArmature)Armatures.BIPED.get()).rootJoint && collider != WOMWeaponColliders.ENDER_LASER && collider != WOMWeaponColliders.ENDER_PISTOLERO && collider != WOMWeaponColliders.ENDER_DASH && collider != WOMWeaponColliders.ENDER_BULLET_WIDE) {
                EpicFightCameraAPI cameraAPI = EpicFightCameraAPI.getInstance();
                ReuseableEvents.enderblaster_shoot(entitypatch, joint, 20, 0.3f, new Vec2f(cameraAPI.getCameraYRot(), cameraAPI.getCameraXRot()));
            }
            if (!entitypatch.isLogicalClient()) {
                Level worldIn = ((LivingEntity)entitypatch.getOriginal()).m_9236_();
                float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
                float poseTime = state.attacking() ? elapsedTime : phase.contact;
                List list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entitypatch, (AttackAnimation)this, prevPoseTime, poseTime, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
                ArrayList list2 = new ArrayList(list);
                for (Entity entity : list) {
                    if (entity instanceof Projectile) {
                        list2.remove(entity);
                        continue;
                    }
                    if (entity instanceof LivingEntity) continue;
                    list2.remove(entity);
                }
                if (list2.size() == 0 && joint != ((HumanoidArmature)Armatures.BIPED.get()).head && joint != ((HumanoidArmature)Armatures.BIPED.get()).rootJoint && collider != WOMWeaponColliders.ENDER_LASER && collider != WOMWeaponColliders.ENDER_PISTOLERO && collider != WOMWeaponColliders.ENDER_DASH && collider != WOMWeaponColliders.ENDER_BULLET_WIDE) {
                    OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(0.0f), joint).mulFront(OpenMatrix4f.createTranslation((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)((float)((LivingEntity)entitypatch.getOriginal()).m_20189_())).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(0.0f))));
                    transformMatrix.translate(0.0f, -0.6f, -0.3f);
                    Vec3 direction = ((LivingEntity)entitypatch.getOriginal()).m_20252_(1.0f);
                    EnderBullet projectile = new EnderBullet((EntityType<? extends EnderBullet>)((EntityType)WOMEntities.ENDERBLAST.get()), worldIn);
                    projectile.m_20049_("wom_enderbullet:" + phase.getHand().toString());
                    projectile.m_5602_(entitypatch.getOriginal());
                    projectile.m_20343_(transformMatrix.toTranslationVector().x, transformMatrix.toTranslationVector().y, transformMatrix.toTranslationVector().z);
                    projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 2.5f, 0.0f);
                    projectile.life = entitypatch.getValidItemInHand(phase.getHand()).getEnchantmentLevel(Enchantments.f_44961_);
                    worldIn.m_7967_((Entity)projectile);
                }
            }
        }
    }

    @Override
    public boolean isBasicAttackAnimation() {
        return false;
    }
}

