/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.animation.attacks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.joml.Quaternionf;
import reascer.wom.animation.WomAnimationProperty;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.world.entity.mobpatch.WomMobPatch;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.camera.EpicFightCameraAPI;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;

public class BasicMultipleAttackAnimation
extends AttackAnimation {
    public BasicMultipleAttackAnimation(float convertTime, float antic, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(convertTime, antic, antic, contact, recovery, collider, colliderJoint, accessor, armature);
    }

    public BasicMultipleAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(convertTime, accessor, armature, new AttackAnimation.Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, colliderJoint, collider));
    }

    public BasicMultipleAttackAnimation(float convertTime, float antic, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(convertTime, accessor, armature, new AttackAnimation.Phase(0.0f, antic, antic, contact, recovery, Float.MAX_VALUE, hand, colliderJoint, collider));
    }

    public BasicMultipleAttackAnimation(float convertTime, AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, boolean Coordsetter, AttackAnimation.Phase ... phases) {
        super(convertTime, accessor, armature, phases);
    }

    public BasicMultipleAttackAnimation(float convertTime, AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(convertTime, accessor, armature, phases);
        this.newTimePair(0.0f, phases[phases.length - 1].recovery);
        this.addStateRemoveOld(EntityState.TURNING_LOCKED, false);
        this.newTimePair(phases[phases.length - 1].recovery, Float.MAX_VALUE);
        this.addState(EntityState.TURNING_LOCKED, true);
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, (self, pose, entitypatch, time, partialTicks) -> {
            PlayerPatch playerpatch;
            if (!self.isStaticAnimation() || entitypatch instanceof PlayerPatch && (playerpatch = (PlayerPatch)entitypatch).isFirstPerson()) {
                return;
            }
            float pitch = entitypatch.getAttackDirectionPitch();
            JointTransform chest = pose.orElseEmpty("Chest");
            chest.frontResult(JointTransform.rotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch - 10.0f)), OpenMatrix4f::mulAsOriginInverse);
            if (entitypatch instanceof PlayerPatch) {
                float xRot = MathUtils.lerpBetween((float)((LivingEntity)entitypatch.getOriginal()).f_19860_, (float)((LivingEntity)entitypatch.getOriginal()).m_146909_(), (float)partialTicks);
                OpenMatrix4f toOriginalRotation = entitypatch.getArmature().getBoundTransformFor(pose, entitypatch.getArmature().searchJointByName("Head")).removeScale().removeTranslation().invert();
                Vec3f xAxis = OpenMatrix4f.transform3v((OpenMatrix4f)toOriginalRotation, (Vec3f)Vec3f.X_AXIS, null);
                OpenMatrix4f headRotation = OpenMatrix4f.createRotatorDeg((float)(-(pitch + xRot)), (Vec3f)xAxis);
                pose.orElseEmpty("Head").frontResult(JointTransform.fromMatrix((OpenMatrix4f)headRotation), OpenMatrix4f::mul);
            }
        });
    }

    protected void hurtCollidingEntities(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        float poseTime = state.attacking() ? elapsedTime : phase.contact;
        List list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entitypatch, (AttackAnimation)this, prevPoseTime, poseTime, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
        if (list.size() > 0) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            int maxStrikes = this.getMaxStrikes(entitypatch, phase);
            if (phase.getProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER).isPresent()) {
                maxStrikes = (int)ValueModifier.calculator().attach((ValueModifier)phase.getProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER).get()).getResult((float)entitypatch.getMaxStrikes(phase.hand));
            }
            while (entitypatch.getCurrentlyActuallyHitEntities().size() <= (maxStrikes == Integer.MAX_VALUE ? maxStrikes : maxStrikes + 3) && hitEntities.next()) {
                boolean CanImpact;
                Entity hitten = hitEntities.getEntity();
                LivingEntity truehittenEntity = this.getTrueEntity(hitten);
                if (truehittenEntity == null || !truehittenEntity.m_6084_() || entitypatch.getCurrentlyActuallyHitEntities().contains(truehittenEntity) || entitypatch.isTargetInvulnerable(hitten) || !(hitten instanceof LivingEntity) && !(hitten instanceof PartEntity) || !entity.m_142582_(hitten)) continue;
                HurtableEntityPatch hitHurtableEntityPatch = (HurtableEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)hitten, HurtableEntityPatch.class);
                LivingEntityPatch TargetEntityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)hitten, LivingEntityPatch.class);
                EpicFightDamageSource source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                float anti_stunlock = 1.0f;
                boolean bl = CanImpact = !truehittenEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) || source.m_269533_(EpicFightDamageTypeTags.FINISHER);
                if (hitHurtableEntityPatch != null) {
                    if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).isPresent()) {
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.NONE) {
                            if (truehittenEntity instanceof Player) {
                                source.setStunType(StunType.NONE);
                            }
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.HOLD && !CanImpact) {
                            source.setStunType(StunType.NONE);
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.FALL && !CanImpact) {
                            source.setStunType(StunType.NONE);
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.KNOCKDOWN && !CanImpact) {
                            source.setStunType(StunType.NONE);
                        } else {
                            source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                        }
                    } else {
                        source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                    }
                    if (hitHurtableEntityPatch.isStunned()) {
                        for (Object tag : hitten.m_19880_()) {
                            if (!((String)tag).contains("anti_stunlock:")) continue;
                            anti_stunlock = this.applyAntiStunLock(hitten, anti_stunlock, source, phase, (String)tag, elapsedTime);
                            break;
                        }
                    } else {
                        Object tag;
                        boolean firstAttack = true;
                        tag = hitten.m_19880_().iterator();
                        while (tag.hasNext()) {
                            String tag2 = (String)tag.next();
                            if (!tag2.contains("anti_stunlock:")) continue;
                            if (!((float)hitten.f_19797_ - Float.valueOf(tag2.split(":")[2]).floatValue() <= 20.0f)) break;
                            anti_stunlock = this.applyAntiStunLock(hitten, anti_stunlock, source, phase, tag2, elapsedTime);
                            firstAttack = false;
                            break;
                        }
                        if (firstAttack) {
                            int i = 0;
                            while (i < hitten.m_19880_().size()) {
                                if ((String)hitten.m_19880_().toArray()[i] == null) continue;
                                if (((String)hitten.m_19880_().toArray()[i]).contains("anti_stunlock:")) {
                                    hitten.m_19880_().remove(hitten.m_19880_().toArray()[i]);
                                    continue;
                                }
                                ++i;
                            }
                            anti_stunlock = this.applyAntiStunLock(hitten, anti_stunlock, source, phase, null, elapsedTime);
                        }
                    }
                    if (anti_stunlock <= 0.0f) {
                        for (String tag : hitten.m_19880_()) {
                            if (!tag.contains("anti_stunlock:")) continue;
                            hitten.m_20137_(tag);
                            LivingEntityPatch livingEntityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)hitten, LivingEntityPatch.class);
                            if (livingEntityPatch == null) break;
                            livingEntityPatch.setStunShield(0.0f);
                            livingEntityPatch.setMaxStunShield(0.0f);
                            break;
                        }
                        source.setStunType(StunType.KNOCKDOWN);
                    }
                }
                int prevInvulTime = hitten.f_19802_;
                hitten.f_19802_ = 0;
                AttackResult attackResult = entitypatch.attack(source, hitten, phase.hand);
                hitten.f_19802_ = prevInvulTime;
                if (attackResult.resultType.dealtDamage() && !truehittenEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                    if (source.getStunType() == StunType.KNOCKDOWN) {
                        truehittenEntity.m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 60, 0, true, false, false));
                        if (truehittenEntity.m_21023_(MobEffects.f_19591_)) {
                            truehittenEntity.m_21195_(MobEffects.f_19591_);
                        }
                        if (truehittenEntity.m_21023_(MobEffects.f_19620_)) {
                            truehittenEntity.m_21195_(MobEffects.f_19620_);
                        }
                    }
                    hitten.m_9236_().m_6263_(null, hitten.m_20185_(), hitten.m_20186_(), hitten.m_20189_(), this.getHitSound(entitypatch, phase), hitten.m_5720_(), 1.0f, 1.0f);
                    this.spawnHitParticle((ServerLevel)hitten.m_9236_(), entitypatch, hitten, phase);
                    if (hitHurtableEntityPatch != null && phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).isPresent() && source.getStunType() != StunType.KNOCKDOWN) {
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.NONE) {
                            float stunTime = (float)((double)(source.calculateImpact() * 0.35f) * (1.0 - truehittenEntity.m_21133_(Attributes.f_22278_)));
                            if (((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_6084_()) {
                                if (!(truehittenEntity instanceof Player)) {
                                    hitten.m_7618_(EntityAnchorArgument.Anchor.FEET, entity.m_20182_());
                                } else {
                                    TargetEntityPatch.rotateTo((Entity)entity, 360.0f, true);
                                }
                                hitHurtableEntityPatch.applyStun(source.getStunType() == StunType.KNOCKDOWN ? StunType.KNOCKDOWN : StunType.NONE, stunTime);
                                if (TargetEntityPatch != null && TargetEntityPatch.getArmature() instanceof HumanoidArmature) {
                                    if (hitten.m_6084_()) {
                                        if (source.calculateImpact() == 0.0f) {
                                            // empty if block
                                        }
                                        if (source.calculateImpact() < 0.3f) {
                                            TargetEntityPatch.playAnimationSynchronized((AssetAccessor)Animations.BIPED_HIT_SHORT, stunTime);
                                        } else if (source.calculateImpact() < 0.5f) {
                                            TargetEntityPatch.playAnimationSynchronized((AssetAccessor)Animations.BIPED_HIT_LONG, 0.0f);
                                        } else if (source.calculateImpact() <= 1.5f) {
                                            TargetEntityPatch.playAnimationSynchronized(WOMAnimations.BIPED_HIT_SHORT_DISTANCE, -0.25f * (1.0f - source.calculateImpact() / 1.35f));
                                        } else if (source.calculateImpact() > 1.5f) {
                                            TargetEntityPatch.playAnimationSynchronized(WOMAnimations.BIPED_HIT_EXTRA_LONG, Math.min(-2.0f * (1.0f - source.calculateImpact() / 5.0f), 0.0f));
                                        }
                                    } else {
                                        TargetEntityPatch.playAnimationSynchronized((AssetAccessor)Animations.BIPED_DEATH, 0.0f);
                                    }
                                } else if (TargetEntityPatch instanceof WomMobPatch) {
                                    hitHurtableEntityPatch.applyStun(source.getStunType() == StunType.KNOCKDOWN ? StunType.KNOCKDOWN : StunType.NONE, source.calculateImpact());
                                } else {
                                    hitHurtableEntityPatch.applyStun(source.getStunType() == StunType.KNOCKDOWN ? StunType.KNOCKDOWN : StunType.SHORT, stunTime);
                                }
                            }
                        }
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.FALL) {
                            float stunTime = (float)((double)(source.calculateImpact() * 0.45f) * (1.0 - truehittenEntity.m_21133_(Attributes.f_22278_)));
                            if (((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_6084_()) {
                                hitHurtableEntityPatch.applyStun(source.getStunType() == StunType.KNOCKDOWN ? StunType.KNOCKDOWN : StunType.SHORT, stunTime);
                                double power = source.calculateImpact() * 0.25f;
                                double d1 = entity.m_20185_() - hitten.m_20185_();
                                double d2 = entity.m_20186_() - hitten.m_20186_() - 2.0;
                                double d0 = entity.m_20189_() - hitten.m_20189_();
                                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                                    d1 = (Math.random() - Math.random()) * 0.01;
                                    d0 = (Math.random() - Math.random()) * 0.01;
                                }
                                if (!(truehittenEntity instanceof Player)) {
                                    power *= 1.0 - truehittenEntity.m_21133_(Attributes.f_22278_);
                                }
                                if (power > 0.0) {
                                    hitten.f_19812_ = true;
                                    Vec3 vec3 = entity.m_20184_();
                                    Vec3 vec31 = new Vec3(d1, d2, d0).m_82541_().m_82490_(power * (double)0.4f);
                                    if (!(truehittenEntity instanceof Player) || !(entitypatch instanceof PlayerPatch)) {
                                        hitten.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, vec3.f_82480_ / 2.0 - vec31.f_82480_ + power, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                                        truehittenEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, 0, true, false, false));
                                    }
                                }
                                if (truehittenEntity instanceof Player && entitypatch instanceof PlayerPatch) {
                                    truehittenEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, (int)(power * 4.0 * 6.0), true, false, false));
                                }
                                truehittenEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, (int)(power * 4.0 * 6.0), 20, true, false, false));
                            }
                        }
                    }
                }
                entitypatch.getCurrentlyActuallyHitEntities().add(truehittenEntity);
                if (!attackResult.resultType.shouldCount()) continue;
                entitypatch.getCurrentlyActuallyHitEntities().add(truehittenEntity);
            }
        }
    }

    public Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> dynamicAnimation) {
        if (entitypatch.isLogicalClient()) {
            EpicFightCameraAPI.getInstance().setLockOn(false);
        }
        Vec3 vec3 = super.getCoordVector(entitypatch, dynamicAnimation);
        if (entitypatch.shouldBlockMoving() && this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE).orElse(false).booleanValue()) {
            vec3 = vec3.m_82490_(0.0);
        }
        return vec3;
    }

    public boolean isBasicAttackAnimation() {
        return true;
    }

    public float applyAntiStunLock(Entity hitten, float anti_stunlock, EpicFightDamageSource source, AttackAnimation.Phase phase, String tag, float poseTime) {
        boolean isPhaseFromSameAnimnation = false;
        float anti_stun_multiplier = this.getProperty((AnimationProperty)WomAnimationProperty.ANTI_STUN_MULTIPLYER).orElse(Float.valueOf(1.0f)).floatValue();
        if (tag != null) {
            if (hitten.m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos(hitten.m_20185_(), hitten.m_20186_() - 1.0, hitten.m_20189_())).m_60795_()) {
                if (String.valueOf(this.getId()).equals(tag.split(":")[3].split("-")[0]) && (float)hitten.f_19797_ / 20.0f - poseTime < Float.valueOf(tag.split(":")[3].split("-")[1]).floatValue()) {
                    anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue() - 0.005f * anti_stun_multiplier;
                    isPhaseFromSameAnimnation = true;
                } else {
                    anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue() - 0.1f * anti_stun_multiplier;
                    isPhaseFromSameAnimnation = false;
                }
            } else if (String.valueOf(this.getId()).equals(tag.split(":")[3].split("-")[0]) && (float)hitten.f_19797_ / 20.0f - poseTime < Float.valueOf(tag.split(":")[3].split("-")[1]).floatValue()) {
                anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue() - 0.01f * anti_stun_multiplier;
                isPhaseFromSameAnimnation = true;
            } else {
                anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue() - 0.2f * anti_stun_multiplier;
                isPhaseFromSameAnimnation = false;
            }
        } else {
            anti_stunlock = 1.0f;
            hitten.m_20049_("anti_stunlock:" + anti_stunlock + ":" + hitten.f_19797_ + ":" + this.getId() + "-" + ((float)hitten.f_19797_ / 20.0f - poseTime + this.phases[this.phases.length - 1].recovery));
            return anti_stunlock;
        }
        hitten.m_20137_(tag);
        int maxSavedAttack = 6;
        if (((LivingEntity)hitten).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
            anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue();
            isPhaseFromSameAnimnation = true;
        }
        Object replaceTag = "anti_stunlock:" + anti_stunlock + ":" + hitten.f_19797_;
        if (isPhaseFromSameAnimnation) {
            maxSavedAttack = 7;
        } else if (!this.getProperty((AnimationProperty)WomAnimationProperty.CAN_SPAM).orElse(false).booleanValue()) {
            String phaseID = String.valueOf(this.getId());
            for (int i = 3; i < tag.split(":").length && i < maxSavedAttack; ++i) {
                if (!tag.split(":")[i].split("-")[0].equals(phaseID) || !(anti_stun_multiplier > 0.0f)) continue;
                anti_stunlock -= 0.8f;
            }
            replaceTag = "anti_stunlock:" + anti_stunlock + ":" + hitten.f_19797_ + ":" + this.getId() + "-" + ((float)hitten.f_19797_ / 20.0f - poseTime + this.phases[this.phases.length - 1].recovery);
        }
        for (int i = 3; i < tag.split(":").length && i < maxSavedAttack; ++i) {
            replaceTag = ((String)replaceTag).concat(":" + tag.split(":")[i]);
        }
        hitten.m_20049_((String)replaceTag);
        return anti_stunlock;
    }
}

