/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.difficulty.impl;

import io.github.flemmli97.improvedmobs.api.difficulty.DifficultyGetter;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.difficulty.PlayerDifficulty;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.phys.Vec3;

public class DefaultDifficulty
implements DifficultyGetter {
    @Override
    public float getDifficulty(ServerLevel level, Vec3 pos) {
        return switch (Config.CommonConfig.difficultyType) {
            default -> throw new IncompatibleClassChangeError();
            case Config.DifficultyType.GLOBAL -> DifficultyData.get(level.m_7654_()).getDifficulty();
            case Config.DifficultyType.PLAYERMAX -> {
                float diff = 0.0f;
                for (Player player : DifficultyGetter.playersIn((EntityGetter)level, pos, 256.0)) {
                    float pD = CrossPlatformStuff.INSTANCE.getPlayerDifficultyData((ServerPlayer)player).map(PlayerDifficulty::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue();
                    if (!(pD > diff)) continue;
                    diff = pD;
                }
                yield diff;
            }
            case Config.DifficultyType.PLAYERSUM -> {
                float diff = 0.0f;
                for (Player player : DifficultyData.playersIn((EntityGetter)level, pos, 256.0)) {
                    diff += CrossPlatformStuff.INSTANCE.getPlayerDifficultyData((ServerPlayer)player).map(PlayerDifficulty::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue();
                }
                yield diff;
            }
            case Config.DifficultyType.PLAYERMEAN -> {
                float diff = 0.0f;
                List<Player> list = DifficultyGetter.playersIn((EntityGetter)level, pos, 256.0);
                if (list.isEmpty()) {
                    yield 0.0f;
                }
                for (Player player : list) {
                    diff += CrossPlatformStuff.INSTANCE.getPlayerDifficultyData((ServerPlayer)player).map(PlayerDifficulty::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue();
                }
                yield diff / (float)list.size();
            }
            case Config.DifficultyType.DISTANCE, Config.DifficultyType.DISTANCESPAWN -> DifficultyData.getDifficultyFromDist(level, pos);
        };
    }

    @Override
    public Config.IntegrationType getType() {
        return Config.IntegrationType.ON;
    }
}

