/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.boat.impl.item;

import com.terraformersmc.terraform.boat.api.TerraformBoatType;
import com.terraformersmc.terraform.boat.api.TerraformBoatTypeRegistry;
import com.terraformersmc.terraform.boat.impl.entity.TerraformBoatEntity;
import com.terraformersmc.terraform.boat.impl.entity.TerraformBoatHolder;
import com.terraformersmc.terraform.boat.impl.entity.TerraformChestBoatEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class TerraformBoatDispenserBehavior
extends DefaultDispenseItemBehavior {
    private static final DispenseItemBehavior FALLBACK_BEHAVIOR = new DefaultDispenseItemBehavior();
    private static final float OFFSET_MULTIPLIER = 1.125f;
    private final ResourceKey<TerraformBoatType> boatKey;
    private final boolean chest;

    public TerraformBoatDispenserBehavior(ResourceKey<TerraformBoatType> boatKey, boolean chest) {
        this.boatKey = boatKey;
        this.chest = chest;
    }

    public ItemStack m_7498_(BlockSource pointer, ItemStack stack) {
        TerraformBoatHolder boatEntity;
        BlockPos pos;
        Direction facing = (Direction)pointer.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        double x = pointer.m_7096_() + (double)((float)facing.m_122429_() * 1.125f);
        double y = pointer.m_7098_() + (double)((float)facing.m_122430_() * 1.125f);
        double z = pointer.m_7094_() + (double)((float)facing.m_122431_() * 1.125f);
        ServerLevel world = pointer.m_7727_();
        if (world.m_6425_(pos = pointer.m_7961_().m_121945_(facing)).m_205070_(FluidTags.f_13131_)) {
            y += 1.0;
        } else if (!world.m_8055_(pos).m_60795_() || !world.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
            return FALLBACK_BEHAVIOR.m_6115_(pointer, stack);
        }
        TerraformBoatType boatType = (TerraformBoatType)TerraformBoatTypeRegistry.INSTANCE.m_123013_(this.boatKey);
        if (this.chest) {
            TerraformChestBoatEntity chestBoat = new TerraformChestBoatEntity((Level)world, x, y, z);
            chestBoat.setTerraformBoat(boatType);
            boatEntity = chestBoat;
        } else {
            TerraformBoatEntity boat = new TerraformBoatEntity((Level)world, x, y, z);
            boat.setTerraformBoat(boatType);
            boatEntity = boat;
        }
        boatEntity.m_146922_(facing.m_122435_());
        world.m_7967_((Entity)boatEntity);
        stack.m_41774_(1);
        return stack;
    }
}

