/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.sugar.impl.ref;

import com.llamalad7.mixinextras.sugar.impl.ref.LocalRefUtils;
import com.llamalad7.mixinextras.utils.ClassGenUtils;
import com.llamalad7.mixinextras.utils.PackageUtils;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class LocalRefClassGenerator {
    private static final String IMPL_PACKAGE = StringUtils.substringBeforeLast((String)LocalRefClassGenerator.class.getName(), (String)".").replace('.', '/');
    private static final Map<Class<?>, String> interfaceToImpl = new HashMap();

    public static String getForType(Type type) {
        Class<?> refInterface = LocalRefUtils.getInterfaceFor(type);
        String owner = interfaceToImpl.get(refInterface);
        if (owner != null) {
            return owner;
        }
        owner = IMPL_PACKAGE + '/' + StringUtils.substringAfterLast((String)refInterface.getName(), (String)".") + "Impl";
        String desc = type.getDescriptor();
        String innerDesc = desc.length() == 1 ? desc : Type.getDescriptor(Object.class);
        interfaceToImpl.put(refInterface, owner);
        ClassNode node = new ClassNode();
        node.visit(52, 33, owner, null, Type.getInternalName(Object.class), null);
        LocalRefClassGenerator.generateClass(node, owner, innerDesc, refInterface.getName());
        ClassGenUtils.defineClass(node, MethodHandles.lookup());
        return owner;
    }

    private static void generateClass(ClassNode node, String owner, String innerDesc, String interfaceName) {
        for (String name : PackageUtils.getAllClassNames(interfaceName)) {
            node.interfaces.add(name.replace('.', '/'));
        }
        node.visitField(2, "value", innerDesc, null, null);
        MethodVisitor ctor = node.visitMethod(1, "<init>", "(" + innerDesc + ")V", null, null);
        ctor.visitCode();
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        ctor.visitVarInsn(25, 0);
        ctor.visitVarInsn(Type.getType((String)innerDesc).getOpcode(21), 1);
        ctor.visitFieldInsn(181, owner, "value", innerDesc);
        ctor.visitInsn(177);
        ctor.visitMaxs(3, 3);
        ctor.visitEnd();
        MethodVisitor getter = node.visitMethod(1, "get", "()" + innerDesc, null, null);
        getter.visitCode();
        getter.visitVarInsn(25, 0);
        getter.visitFieldInsn(180, owner, "value", innerDesc);
        getter.visitInsn(Type.getType((String)innerDesc).getOpcode(172));
        getter.visitMaxs(2, 1);
        getter.visitEnd();
        MethodVisitor setter = node.visitMethod(1, "set", "(" + innerDesc + ")V", null, null);
        setter.visitCode();
        setter.visitVarInsn(25, 0);
        setter.visitVarInsn(Type.getType((String)innerDesc).getOpcode(21), 1);
        setter.visitFieldInsn(181, owner, "value", innerDesc);
        setter.visitInsn(177);
        setter.visitMaxs(3, 3);
        setter.visitEnd();
    }
}

