/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.music;

import com.finderfeed.fdlib.FDClientHelpers;
import com.finderfeed.fdlib.systems.music.FDMusic;
import com.finderfeed.fdlib.systems.music.FDMusicSoundInstance;
import com.finderfeed.fdlib.systems.music.FDMusicSystem;
import com.finderfeed.fdlib.systems.music.data.FDMusicPartData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundManager;
import org.lwjgl.openal.AL11;

public class FDMusicPart {
    private FDMusicPartData data;
    private List<SoundInstance> oldSoundInstances = new ArrayList<SoundInstance>();
    private SoundInstance main;
    private FDMusic owner;
    private boolean finishedPlaying = false;

    public FDMusicPart(FDMusicPartData data, FDMusic owner) {
        this.data = data;
        this.owner = owner;
    }

    public void tick() {
        this.deleteEndedSoundInstances();
    }

    public void renderTick(float pticks) {
        this.manageLoopOrEndSound(pticks);
    }

    private void manageLoopOrEndSound(float pticks) {
        if (!this.finishedPlaying) {
            ChannelAccess.ChannelHandle channelHandle;
            Map map;
            if (this.main == null) {
                this.startNewSound(pticks);
            }
            if (!(map = FDClientHelpers.getSoundEngine().f_120226_).containsKey(this.main) && FDClientHelpers.getCurrentMusicVolume() > 0.0f && !Minecraft.m_91087_().m_91104_()) {
                this.startNewSound(pticks);
            }
            if ((channelHandle = (ChannelAccess.ChannelHandle)map.get(this.main)) != null) {
                channelHandle.m_120154_(channel -> {
                    if (!this.finishedPlaying) {
                        float playDuration;
                        int source = channel.f_83642_;
                        float currentPlaytime = AL11.alGetSourcef((int)source, (int)4132);
                        ConcurrentHashMap<Integer, Float> m = FDMusicSystem.StreamingSourcesBufferLengthCache.sourceToProcessedBufferSecondLength;
                        if (m.containsKey(source)) {
                            currentPlaytime += m.get(source).floatValue();
                        }
                        if (currentPlaytime >= (playDuration = this.data.getPlayDuration())) {
                            if (this.data.shouldLoop()) {
                                this.startNewSound(pticks);
                            } else {
                                this.finishedPlaying = true;
                            }
                        }
                    }
                });
            }
        }
    }

    protected void setAllSoundInstancesVolume(float volume) {
        Iterator<SoundInstance> iterator = this.getSoundInstances().iterator();
        while (iterator.hasNext()) {
            Map map = FDClientHelpers.getSoundEngine().f_120226_;
            SoundInstance instance = iterator.next();
            ChannelAccess.ChannelHandle channelHandle = (ChannelAccess.ChannelHandle)map.get(instance);
            if (channelHandle == null) continue;
            channelHandle.m_120154_(channel -> channel.m_83666_(volume));
        }
        Map map = FDClientHelpers.getSoundEngine().f_120226_;
        ChannelAccess.ChannelHandle channelHandle = (ChannelAccess.ChannelHandle)map.get(this.main);
        if (channelHandle != null) {
            channelHandle.m_120154_(channel -> channel.m_83666_(volume));
        }
    }

    private void startNewSound(float pticks) {
        FDMusicSoundInstance soundInstance = new FDMusicSoundInstance(this.data.getSoundEvent(), this.owner.getVolume(pticks) * FDClientHelpers.getCurrentMusicVolume());
        if (this.main != null) {
            this.oldSoundInstances.add(this.main);
        }
        this.main = soundInstance;
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        soundManager.m_120367_((SoundInstance)soundInstance);
    }

    private void deleteEndedSoundInstances() {
        Iterator<SoundInstance> iterator = this.oldSoundInstances.iterator();
        while (iterator.hasNext()) {
            SoundInstance soundInstance = iterator.next();
            SoundManager soundManager = FDClientHelpers.getSoundManager();
            if (soundManager.m_120403_(soundInstance)) continue;
            iterator.remove();
        }
    }

    public boolean hasFinished() {
        return this.finishedPlaying;
    }

    public FDMusicPartData getData() {
        return this.data;
    }

    public List<SoundInstance> getSoundInstances() {
        ArrayList<SoundInstance> c = new ArrayList<SoundInstance>(this.oldSoundInstances);
        if (this.main != null) {
            c.add(this.main);
        }
        return c;
    }
}

