/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.cutscenes;

import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffect;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectData;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectType;
import com.finderfeed.fdlib.systems.stream_codecs.NetworkCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public class CutsceneScreenEffectData {
    private HashMap<Integer, List<ScreenEffectInstance<?, ?>>> screenEffects = new HashMap();

    public <A extends ScreenEffectData, B extends ScreenEffect<A>> void putScreenEffectOnTick(int tick, ScreenEffectType<A, B> type, A data, int inTime, int stayTime, int outTime) {
        this.screenEffects.computeIfAbsent(tick, v -> new ArrayList()).add(new ScreenEffectInstance<A, B>(type, data, inTime, stayTime, outTime));
    }

    public List<ScreenEffectInstance<?, ?>> getAllEffectsOnTick(int tick) {
        return this.screenEffects.get(tick);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.screenEffects.size());
        IForgeRegistry<ScreenEffectType<?, ?>> registry = FDRegistries.SCREEN_EFFECTS.get();
        for (Map.Entry<Integer, List<ScreenEffectInstance<?, ?>>> entry : this.screenEffects.entrySet()) {
            Integer tick = entry.getKey();
            List<ScreenEffectInstance<?, ?>> pairs = entry.getValue();
            int pairsCount = pairs.size();
            buf.writeInt(pairsCount);
            buf.writeInt(tick.intValue());
            for (ScreenEffectInstance<?, ?> pair : pairs) {
                ScreenEffectType type = pair.type;
                Object data = pair.data;
                ResourceLocation location = registry.getKey(type);
                buf.m_130070_(location.toString());
                this.encodeScreenEffectData(buf, type, (ScreenEffectData)data);
                buf.writeInt(pair.inTime);
                buf.writeInt(pair.stayTime);
                buf.writeInt(pair.outTime);
            }
        }
    }

    private <A extends ScreenEffectData, B extends ScreenEffect<A>> void encodeScreenEffectData(FriendlyByteBuf buf, ScreenEffectType<A, B> type, ScreenEffectData data) {
        NetworkCodec codec = type.dataCodec;
        codec.toNetwork(buf, data);
    }

    public static CutsceneScreenEffectData decode(FriendlyByteBuf buf) {
        HashMap screenEffects = new HashMap();
        int effects = buf.readInt();
        IForgeRegistry<ScreenEffectType<?, ?>> registry = FDRegistries.SCREEN_EFFECTS.get();
        for (int i = 0; i < effects; ++i) {
            int pairs = buf.readInt();
            int tick = buf.readInt();
            for (int k = 0; k < pairs; ++k) {
                ScreenEffectData effectData;
                String location = buf.m_130277_();
                ScreenEffectType t = (ScreenEffectType)registry.getValue(ResourceLocation.m_135820_((String)location));
                ScreenEffectData data = effectData = (ScreenEffectData)t.dataCodec.fromNetwork(buf);
                int inTime = buf.readInt();
                int stayTime = buf.readInt();
                int outTime = buf.readInt();
                CutsceneScreenEffectData.putInMap(screenEffects, t, data, inTime, stayTime, outTime, tick);
            }
        }
        CutsceneScreenEffectData cutsceneScreenEffectData = new CutsceneScreenEffectData();
        cutsceneScreenEffectData.screenEffects = screenEffects;
        return cutsceneScreenEffectData;
    }

    private static <A extends ScreenEffectData, B extends ScreenEffect<A>> void putInMap(HashMap<Integer, List<ScreenEffectInstance<?, ?>>> map, ScreenEffectType<A, B> type, ScreenEffectData data, int inTime, int stayTime, int outTime, int tick) {
        map.computeIfAbsent(tick, v -> new ArrayList()).add(new ScreenEffectInstance<ScreenEffectData, B>(type, data, inTime, stayTime, outTime));
    }

    public record ScreenEffectInstance<A extends ScreenEffectData, B extends ScreenEffect<A>>(ScreenEffectType<A, B> type, A data, int inTime, int stayTime, int outTime) {
    }
}

