/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.ticking.tickers.BlockPosTicker;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class WaterfallTicker
extends BlockPosTicker {
    public static final Map<BlockPos, WaterfallTicker> WATERFALLS = new HashMap<BlockPos, WaterfallTicker>();
    private final BlockPos waterfallPos;
    private WaterfallData data;
    private int updateTicks;

    public WaterfallTicker(Level level, BlockPos pos, BlockPos waterfallPos, WaterfallData data) {
        super(level, pos);
        this.waterfallPos = waterfallPos;
        this.data = data;
    }

    public static void trySpawn(Level level, FluidState fluidState, BlockPos pos) {
        BlockPos waterfallPos;
        WaterfallData data;
        if (!ModConfigs.ENVIRONMENT.waterfalls.waterfallsEnabled) {
            return;
        }
        if (fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76170_() && !WATERFALLS.containsKey(pos) && !(data = WaterfallTicker.evaluateWaterfall(level, pos, waterfallPos = pos.m_7494_())).equals(WaterfallData.EMPTY_WATERFALL_DATA)) {
            WaterfallTicker ticker = new WaterfallTicker(level, pos, waterfallPos, data);
            WATERFALLS.put(pos, ticker);
            TickerManager.add(ticker);
        }
    }

    @Override
    public void positionedTick() {
        Vec3 flow = this.data.flow();
        WaterfallType type = this.data.type();
        int x = this.waterfallPos.m_123341_();
        int y = this.waterfallPos.m_123342_();
        int z = this.waterfallPos.m_123343_();
        for (Direction direction : this.data.openSides()) {
            double zFlow;
            double xOffset;
            boolean isLarge;
            Direction.Axis axis = direction.m_122434_();
            boolean isX = axis == Direction.Axis.X;
            boolean isZ = axis == Direction.Axis.Z;
            int stepX = direction.m_122429_();
            int stepZ = direction.m_122431_();
            boolean bl = isLarge = type == WaterfallType.LARGE;
            double d = isX ? 0.5 + 0.7 * (double)stepX : (xOffset = (double)this.random.m_188501_() + (isLarge ? 0.5 * (double)MathUtil.nextSign(this.random) : 0.0));
            double zOffset = isZ ? 0.5 + 0.7 * (double)stepZ : (double)this.random.m_188501_() + (isLarge ? 0.5 * (double)MathUtil.nextSign(this.random) : 0.0);
            double xFlow = isX ? flow.m_7096_() : 0.0;
            double d2 = zFlow = isZ ? flow.m_7094_() : 0.0;
            if (type == WaterfallType.NORMAL) {
                if (!(this.random.m_188500_() < (double)((Float)ModConfigs.ENVIRONMENT.waterfalls.mediumWaterfallParticleDensity.get()).floatValue())) continue;
                this.level.m_6485_((ParticleOptions)ModParticles.WATERFALL_CLOUD.get(), ModConfigs.ENVIRONMENT.waterfalls.forceSpawnMediumWaterfallParticles, (double)x + xOffset + MathUtil.nextDouble(this.random, 0.2), (double)((float)y + 0.2f), (double)z + zOffset + MathUtil.nextDouble(this.random, 0.2), Mth.m_216263_((RandomSource)this.random, (double)0.5, (double)1.0) * xFlow, 0.0, Mth.m_216263_((RandomSource)this.random, (double)0.5, (double)1.0) * zFlow);
                continue;
            }
            if (type == WaterfallType.SMALL) {
                this.level.m_7106_((ParticleOptions)ModParticles.WATERFALL_DROPLET.get(), (double)x + xOffset - (isX ? 0.2 * (double)stepX : 0.0), (double)y, (double)z + zOffset - (isZ ? 0.2 * (double)stepZ : 0.0), Mth.m_216263_((RandomSource)this.random, (double)0.05, (double)0.15) * (xFlow == 0.0 ? 0.5 * (double)stepX : (double)(xFlow < 0.0 ? -1 : 1)), Mth.m_216263_((RandomSource)this.random, (double)0.05, (double)0.1), Mth.m_216263_((RandomSource)this.random, (double)0.05, (double)0.15) * (zFlow == 0.0 ? 0.5 * (double)stepZ : (double)(zFlow < 0.0 ? -1 : 1)));
                continue;
            }
            if (!isLarge) continue;
            boolean forceSpawn = ModConfigs.ENVIRONMENT.waterfalls.forceSpawnLargeWaterfallParticles;
            for (int i = 0; i < 6; ++i) {
                if (!(this.random.m_188500_() < (double)((Float)ModConfigs.ENVIRONMENT.waterfalls.largeWaterfallParticleDensity.get()).floatValue())) continue;
                this.level.m_6485_((ParticleOptions)ModParticles.WATERFALL_CLOUD.get(), forceSpawn, (double)x + xOffset + MathUtil.nextDouble(this.random, 0.3) * (double)stepX, (double)y + MathUtil.nextDouble(this.random, 2.0) + (double)0.2f, (double)z + zOffset + MathUtil.nextDouble(this.random, 0.3) * (double)stepZ, Mth.m_216263_((RandomSource)this.random, (double)0.5, (double)1.0) * xFlow, 0.0, Mth.m_216263_((RandomSource)this.random, (double)0.5, (double)1.0) * zFlow);
            }
            if (this.random.m_188503_(3) != 0 || !(this.random.m_188500_() < (double)((Float)ModConfigs.ENVIRONMENT.waterfalls.largeWaterfallParticleDensity.get()).floatValue())) continue;
            this.level.m_6485_((ParticleOptions)ModParticles.WATERFALL_MIST.get(), forceSpawn, (double)x + xOffset, (double)(y + 1), (double)z + zOffset, Mth.m_216263_((RandomSource)this.random, (double)0.5, (double)1.0) * (xFlow * 0.5), Mth.m_216263_((RandomSource)this.random, (double)0.3, (double)0.7), Mth.m_216263_((RandomSource)this.random, (double)0.5, (double)1.0) * (zFlow * 0.5));
        }
        if (this.updateTicks++ >= (Integer)ModConfigs.ENVIRONMENT.waterfalls.waterfallUpdateFrequency.get()) {
            WaterfallData newData = WaterfallTicker.evaluateWaterfall(this.level, this.pos, this.waterfallPos);
            if (newData.equals(WaterfallData.EMPTY_WATERFALL_DATA)) {
                this.remove();
                return;
            }
            this.data = newData;
            this.updateTicks = 0;
        }
    }

    @Override
    public void remove() {
        super.remove();
        WATERFALLS.remove(this.pos);
    }

    @Override
    protected boolean shouldCheckDistance() {
        WaterfallType type = this.data.type();
        if (type == WaterfallType.NORMAL && ModConfigs.ENVIRONMENT.waterfalls.forceSpawnMediumWaterfallParticles) {
            return false;
        }
        return type != WaterfallType.LARGE || !ModConfigs.ENVIRONMENT.waterfalls.forceSpawnLargeWaterfallParticles;
    }

    private static WaterfallData evaluateWaterfall(Level level, BlockPos lakePos, BlockPos waterfallPos) {
        FluidState lakeFluidState;
        if (!ModConfigs.ENVIRONMENT.waterfalls.waterfallsEnabled || !Util.isChunkLoaded(level, waterfallPos.m_123341_(), waterfallPos.m_123343_())) {
            return WaterfallData.EMPTY_WATERFALL_DATA;
        }
        FluidState waterfallState = level.m_6425_(waterfallPos);
        Fluid waterfallFluid = waterfallState.m_76152_();
        if (waterfallFluid.m_6212_((lakeFluidState = level.m_6425_(lakePos)).m_76152_()) && lakeFluidState.m_76170_() && !level.m_8055_(waterfallPos).m_60713_(Blocks.f_50628_)) {
            ArrayList<Direction> openSides = new ArrayList<Direction>();
            for (Direction waterfallDirection : Direction.Plane.HORIZONTAL) {
                BlockPos openSidePos = waterfallPos.m_121945_(waterfallDirection);
                if (!level.m_6425_(openSidePos).m_76178_() || !level.m_8055_(openSidePos).m_60812_((BlockGetter)level, openSidePos).m_83263_(waterfallDirection.m_122424_()).m_83281_() || !level.m_6425_(openSidePos).m_76178_()) continue;
                boolean notSurrounded = false;
                for (Direction relativeDirection : Direction.Plane.HORIZONTAL) {
                    BlockPos relativePos = openSidePos.m_121945_(relativeDirection);
                    if (Util.isSolidOrNotEmpty(level, relativePos)) continue;
                    notSurrounded = true;
                    break;
                }
                if (!notSurrounded) continue;
                openSides.add(waterfallDirection);
            }
            if (!openSides.isEmpty()) {
                boolean surroundedByWater = false;
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && z == 0 || !waterfallFluid.m_6212_(level.m_6425_(lakePos.m_7918_(x, 0, z)).m_76152_())) continue;
                        surroundedByWater = true;
                    }
                }
                if (surroundedByWater) {
                    int distance = 0;
                    for (int i = 19; i > -1; --i) {
                        BlockPos abovePos = waterfallPos.m_6630_(20 - i);
                        FluidState aboveFluidState = level.m_6425_(abovePos);
                        if (!waterfallFluid.m_6212_(aboveFluidState.m_76152_())) continue;
                        ++distance;
                    }
                    boolean canBeLarge = false;
                    WaterfallType type = WaterfallType.NORMAL;
                    if (distance >= 0 && distance <= (Integer)ModConfigs.ENVIRONMENT.waterfalls.mediumWaterfallHeightThreshold.get() - 2) {
                        type = ModConfigs.ENVIRONMENT.waterfalls.smallWaterfallsEnabled ? WaterfallType.SMALL : null;
                    } else if (ModConfigs.ENVIRONMENT.waterfalls.largeWaterfallsEnabled && distance > (Integer)ModConfigs.ENVIRONMENT.waterfalls.largeWaterfallHeightThreshold.get() - 2) {
                        int size = 0;
                        canBeLarge = true;
                        for (Direction direction : Direction.Plane.HORIZONTAL) {
                            BlockPos relativePos = lakePos.m_121945_(direction);
                            WaterfallTicker relativeTicker = WATERFALLS.get(relativePos);
                            if (relativeTicker == null) {
                                relativePos = relativePos.m_121945_(direction.m_122427_());
                                relativeTicker = WATERFALLS.get(relativePos);
                            }
                            if (relativeTicker == null || !relativeTicker.data.canBeLarge()) continue;
                            if (relativeTicker.data.type() == WaterfallType.LARGE) {
                                type = WaterfallType.LARGE;
                                break;
                            }
                            ++size;
                            BlockPos neighborPos = relativePos.m_121945_(direction);
                            WaterfallTicker neighborTicker = WATERFALLS.get(neighborPos);
                            if (neighborTicker == null) {
                                neighborPos = neighborPos.m_121945_(direction.m_122427_());
                                neighborTicker = WATERFALLS.get(neighborPos);
                            }
                            if (neighborTicker == null || !neighborTicker.data.canBeLarge()) continue;
                            ++size;
                            break;
                        }
                        if (size >= 2) {
                            type = WaterfallType.LARGE;
                        }
                    }
                    if (type == null) {
                        return WaterfallData.EMPTY_WATERFALL_DATA;
                    }
                    Vec3 flow = waterfallState.m_76179_((BlockGetter)level, waterfallPos);
                    if (flow.equals((Object)Vec3.f_82478_)) {
                        for (Direction openSide : openSides) {
                            flow = flow.m_82520_((double)openSide.m_122429_(), 0.0, (double)openSide.m_122431_());
                        }
                    }
                    return new WaterfallData(type, canBeLarge, openSides, flow);
                }
            }
        }
        return WaterfallData.EMPTY_WATERFALL_DATA;
    }

    public record WaterfallData(WaterfallType type, boolean canBeLarge, List<Direction> openSides, Vec3 flow) {
        public static final WaterfallData EMPTY_WATERFALL_DATA = new WaterfallData(WaterfallType.NORMAL, false, new ArrayList<Direction>(), Vec3.f_82478_);
    }

    public static enum WaterfallType {
        NORMAL,
        SMALL,
        LARGE;

    }
}

