/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.particle;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.FallenLeafParticleOptions;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.CherryParticle;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CherryParticle.class})
public abstract class CherryParticleMixin
extends TextureSheetParticle {
    @Unique
    private final BlockPos.MutableBlockPos subtleEffects$pos = new BlockPos.MutableBlockPos();

    protected CherryParticleMixin(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @ModifyExpressionValue(method={"tick"}, at={@At(value="CONSTANT", args={"doubleValue=2.0"})})
    private double replaceGravity(double original) {
        if (ModConfigs.GENERAL.rainIncreasesLeavesMovementSpeed && Util.isRainingAt((Level)this.f_107208_, BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_))) {
            return 6.0;
        }
        return original;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        if (!ModConfigs.GENERAL.leavesLandOnGround && !ModConfigs.GENERAL.leavesLandOnWater) {
            return;
        }
        this.subtleEffects$pos.m_122169_(this.f_107212_, this.f_107213_, this.f_107214_);
        BlockState state = this.f_107208_.m_8055_((BlockPos)this.subtleEffects$pos);
        FluidState fluidState = this.f_107208_.m_6425_((BlockPos)this.subtleEffects$pos);
        boolean isWaterCauldron = state.m_60713_(Blocks.f_152476_);
        double fluidHeight = ModConfigs.GENERAL.leavesLandOnWater ? (fluidState.m_192917_((Fluid)Fluids.f_76193_) ? (double)fluidState.m_76155_((BlockGetter)this.f_107208_, (BlockPos)this.subtleEffects$pos) : (isWaterCauldron ? Util.getCauldronFillHeight(state) : 0.0)) : 0.0;
        double surface = (double)this.subtleEffects$pos.m_123342_() + Math.max(fluidHeight, isWaterCauldron ? 0.0 : state.m_60812_((BlockGetter)this.f_107208_, (BlockPos)this.subtleEffects$pos).m_83297_(Direction.Axis.Y)) + 0.01;
        if (fluidHeight > 0.0 && this.f_107213_ <= surface && ModConfigs.GENERAL.leavesLandOnWater || this.f_107218_ && !state.m_60713_(Blocks.f_49990_) && ModConfigs.GENERAL.leavesLandOnGround) {
            this.f_107208_.m_7106_((ParticleOptions)new FallenLeafParticleOptions(this.f_108321_, this.f_107663_, this.f_107221_, this.f_107222_, this.f_107218_, new Vector3f(this.f_107227_, this.f_107228_, this.f_107229_), this.f_107230_, this.f_107231_), this.f_107212_, surface + (double)Mth.m_216267_((RandomSource)this.f_107223_, (float)0.001f, (float)0.005f), this.f_107214_, this.f_107215_, 0.0, this.f_107217_);
            if (!this.f_107218_ && ModConfigs.GENERAL.leavesLandingOnWaterRipples) {
                double halfSize = this.f_107663_ / 2.0f;
                this.f_107208_.m_7106_((ParticleOptions)new FloatParticleOptions(ModParticles.WATER_RIPPLE.get(), Math.max(this.f_107663_, Math.max(this.f_107221_, this.f_107222_)) + 0.90000004f), this.f_107212_ + halfSize, surface, this.f_107214_ + halfSize, 0.0, 0.0, 0.0);
            }
            this.m_107274_();
        }
    }
}

