/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.client.model.entity.PartyHatModel;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.platform.Services;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PartyHatLayer<T extends AbstractClientPlayer, V extends HumanoidModel<T>>
extends RenderLayer<T, V> {
    public static final List<ResourceLocation> TEXTURES = (List)Util.m_137469_(new ArrayList(), textures -> {
        PartyHatLayer.addTexture(textures, "big_fuzz_0");
        PartyHatLayer.addTexture(textures, "big_fuzz_1");
        PartyHatLayer.addTexture(textures, "big_fuzz_2");
        PartyHatLayer.addTexture(textures, "big_fuzz_3");
        PartyHatLayer.addTexture(textures, "big_fuzz_4");
        PartyHatLayer.addTexture(textures, "small_fuzz_0");
        PartyHatLayer.addTexture(textures, "small_fuzz_1");
        PartyHatLayer.addTexture(textures, "small_fuzz_2");
        PartyHatLayer.addTexture(textures, "small_fuzz_3");
        PartyHatLayer.addTexture(textures, "small_fuzz_4");
    });
    private final PartyHatModel<T> model;

    public PartyHatLayer(RenderLayerParent<T, V> renderer, EntityRendererProvider.Context context) {
        super(renderer);
        this.model = new PartyHatModel(context.m_174023_(PartyHatModel.MODEL_LAYER));
    }

    public static void addTexture(List<ResourceLocation> textures, String name) {
        textures.add(SubtleEffects.loc("textures/entity/party_hat/" + name + ".png"));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (PartyHatLayer.shouldRender(player)) {
            poseStack.m_85836_();
            ((HumanoidModel)this.m_117386_()).m_5585_().m_104299_(poseStack);
            float id = (float)Math.sin(player.m_20149_().hashCode());
            poseStack.m_85837_(0.0, -0.5, 0.0);
            poseStack.m_272245_(Axis.f_252403_.m_252977_(id * 22.5f), 0.0f, 0.25f, 0.0f);
            VertexConsumer consumer = bufferSource.m_6299_(this.model.m_103119_(PartyHatLayer.getHatTexture(id, player)));
            this.model.m_7695_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 0.0f, 0.0f, 0.0f, 0.0f);
            poseStack.m_85849_();
        }
    }

    private static ResourceLocation getHatTexture(float id, AbstractClientPlayer player) {
        if (einstein.subtle_effects.util.Util.isMincraftEinstein(player)) {
            return TEXTURES.get(0);
        }
        int index = (int)(Mth.m_14154_((float)id) * (float)TEXTURES.size());
        return TEXTURES.get(index >= TEXTURES.size() ? TEXTURES.size() - 1 : index);
    }

    public static boolean shouldRender(AbstractClientPlayer player) {
        return ModConfigs.GENERAL.enableEasterEggs && !player.m_20145_();
    }

    public static boolean isModBirthday(boolean ignoreInDev) {
        if (!ignoreInDev && Services.PLATFORM.isDevelopmentEnvironment()) {
            return true;
        }
        LocalDate date = LocalDate.now();
        Month month = date.getMonth();
        int dayOfMonth = date.getDayOfMonth();
        return month == Month.OCTOBER && dayOfMonth >= 3 && dayOfMonth <= 5;
    }
}

