/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.effect.HighOrbitingEffect;
import net.sweenus.simplyswords.item.custom.MagiscytheSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class MagistormEffect
extends HighOrbitingEffect {
    public MagistormEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType1((ParticleOptions)ParticleTypes.f_123809_);
        this.setParticleType2((ParticleOptions)ParticleTypes.f_123759_);
        this.setParticleType3((ParticleOptions)ParticleTypes.f_123797_);
        this.yOffset = 4.0f;
        this.width = 4.0f;
    }

    @Override
    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)livingEntity.m_9236_();
            double x = livingEntity.m_20185_();
            double y = livingEntity.m_20186_();
            double z = livingEntity.m_20189_();
            float damage = Config.getFloat("magistormDamage", "UniqueEffects", ConfigDefaultValues.magistormDamage);
            double radius = Config.getFloat("magistormRadius", "UniqueEffects", ConfigDefaultValues.magistormRadius);
            float duration = Config.getFloat("magistormDuration", "UniqueEffects", ConfigDefaultValues.magistormDuration);
            int frequency = Math.max(3, 10 - amplifier);
            float spellScalingModifier = Config.getFloat("magistormSpellScaling", "UniqueEffects", ConfigDefaultValues.magistormSpellScaling);
            if (HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)livingEntity, "arcane") > damage) {
                damage = HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)livingEntity, "arcane");
            }
            DamageSource damageSource = livingEntity.m_269291_().m_269104_((Entity)livingEntity, (Entity)livingEntity);
            if (livingEntity.f_19797_ % frequency == 0 && livingEntity instanceof Player) {
                LivingEntity target;
                Entity randomEntity;
                Player player = (Player)livingEntity;
                AABB box = new AABB(x - radius, y - 1.0, z - radius, x + radius, y + 1.0, z + radius);
                List nearbyEntities = world.m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_);
                if (!nearbyEntities.isEmpty() && player.m_21205_().m_41720_() instanceof MagiscytheSwordItem && (randomEntity = (Entity)nearbyEntities.get(new Random().nextInt(nearbyEntities.size()))) instanceof LivingEntity && HelperMethods.checkFriendlyFire(target = (LivingEntity)randomEntity, (LivingEntity)player)) {
                    if (target instanceof Player) {
                        damageSource = livingEntity.m_269291_().m_269075_(player);
                    }
                    target.f_19802_ = 0;
                    HelperMethods.applyDamageWithoutKnockback(target, damageSource, damage);
                    target.f_19802_ = 0;
                    HelperMethods.spawnRainingParticles(world, (ParticleOptions)ParticleTypes.f_123809_, (Entity)target, 20, this.yOffset);
                    HelperMethods.spawnRainingParticles(world, (ParticleOptions)ParticleTypes.f_175827_, (Entity)target, 4, this.yOffset);
                    HelperMethods.spawnOrbitParticles(world, target.m_20182_(), (ParticleOptions)ParticleTypes.f_175827_, 0.5, 6);
                    player.m_9236_().m_6269_(null, (Entity)player, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_HOLY_SHOOT_IMPACT_03.get(), SoundSource.PLAYERS, 0.1f, 1.0f + player.m_217043_().m_188501_());
                    if (new Random().nextInt(100) < 5) {
                        HelperMethods.incrementStatusEffect(livingEntity, (MobEffect)EffectRegistry.MAGISTORM.get(), (int)duration, 1, 10);
                    }
                }
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    @Override
    public boolean m_6584_(int duration, int amplifier) {
        return super.m_6584_(duration, amplifier);
    }
}

