/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.tipsylib.mixin.server;

import java.util.Random;
import net.azurune.tipsylib.init.TLDamageTypes;
import net.azurune.tipsylib.init.TLTags;
import net.azurune.tipsylib.register.TLAttributes;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityAttributesMixin {
    LivingEntity living = (LivingEntity)this;
    private static Random random = new Random();

    @Inject(at={@At(value="TAIL")}, method={"createLivingAttributes"})
    private static void tipsylib$createLivingAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        ((AttributeSupplier.Builder)cir.getReturnValue()).m_22266_(TLAttributes.DODGE_CHANCE.get()).m_22266_(TLAttributes.LIFESTEAL_CHANCE.get()).m_22266_(TLAttributes.LIFESTEAL_HEAL_AMOUNT.get()).m_22266_(TLAttributes.VULNERABILITY_CHANCE.get()).m_22266_(TLAttributes.VULNERABILITY_MULTIPLIER.get()).m_22266_(TLAttributes.RETALIATION_CHANCE.get()).m_22266_(TLAttributes.RETALIATION_AMOUNT.get()).m_22266_(TLAttributes.BURNING_RETALIATION_LENGTH.get()).m_22266_(TLAttributes.BURNING_RETALIATION_CHANCE.get()).m_22266_(TLAttributes.CRITICAL_STRIKE_CHANCE.get()).m_22266_(TLAttributes.CRITICAL_STRIKE_MULTIPLIER.get()).m_22266_(TLAttributes.REJUVENATE_CHANCE.get()).m_22266_(TLAttributes.REJUVENATE_AMOUNT.get());
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"})
    public void tipsylib$hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        double dodgeChance = this.living.m_21133_(TLAttributes.DODGE_CHANCE.get());
        if (!source.m_269533_(TLTags.DamageTypeTags.BYPASSES_DODGE) && dodgeChance != 0.0 && this.living.m_6084_() && random.nextDouble(100.0) < dodgeChance) {
            this.living.m_9236_().m_6263_(null, this.living.m_20185_(), this.living.m_20186_(), this.living.m_20189_(), SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
            cir.cancel();
        }
        double rejuvenateChance = this.living.m_21133_(TLAttributes.REJUVENATE_CHANCE.get());
        float rejuvenateHealAmount = (float)this.living.m_21133_(TLAttributes.REJUVENATE_AMOUNT.get());
        if (rejuvenateChance != 0.0 && this.living.m_6084_() && random.nextDouble(100.0) < rejuvenateChance) {
            this.living.m_5634_(rejuvenateHealAmount);
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"hurt"}, argsOnly=true)
    public float tipsylib$vulnerability(float amount) {
        double vulnerabilityChance = this.living.m_21133_(TLAttributes.VULNERABILITY_CHANCE.get());
        float vulnerabilityModifier = (float)this.living.m_21133_(TLAttributes.VULNERABILITY_MULTIPLIER.get());
        if (vulnerabilityChance != 0.0 && this.living.m_6084_() && random.nextDouble(100.0) < vulnerabilityChance) {
            return amount + amount * vulnerabilityModifier;
        }
        return amount;
    }

    @Inject(at={@At(value="TAIL")}, method={"getDamageAfterMagicAbsorb"})
    public void tipsylib$getDamageAfterMagicAbsorb(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        LivingEntity attacker;
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).m_6084_()) {
            double retaliationChance = this.living.m_21133_(TLAttributes.RETALIATION_CHANCE.get());
            double retaliationDamageAmount = this.living.m_21133_(TLAttributes.RETALIATION_AMOUNT.get());
            if (retaliationChance != 0.0 && random.nextDouble(100.0) < retaliationChance) {
                DamageSource damagesource = new DamageSource((Holder)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(TLDamageTypes.RETALIATION));
                attacker.m_6469_(damagesource, (float)retaliationDamageAmount);
            }
            double burningRetaliationChance = this.living.m_21133_(TLAttributes.BURNING_RETALIATION_CHANCE.get());
            double burningRetaliationLength = this.living.m_21133_(TLAttributes.BURNING_RETALIATION_LENGTH.get());
            if (burningRetaliationChance != 0.0 && random.nextDouble(100.0) < burningRetaliationChance && burningRetaliationLength > (double)attacker.m_20094_()) {
                attacker.m_7311_((int)burningRetaliationLength);
            }
        }
    }
}

