/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_attributes.compat.irons_spellbooks;

import de.cadentem.additional_attributes.AA;
import de.cadentem.additional_attributes.compat.irons_spellbooks.InnateAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class ISAttributes {
    public static final DeferredRegister<Attribute> REGISTRY = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ATTRIBUTES, (String)"additional_attributes");
    public static final List<Attribute> ATTRIBUTE_ENTRIES = new ArrayList<Attribute>();
    public static final String SEPARATOR = "/";
    public static final String SPELL_PREFIX = "spell_type_";
    public static final String SPELL_PREFIX_NEW = "spell/";
    public static final String SCHOOL_PREFIX = "spell_school_";
    public static final String SCHOOL_PREFIX_NEW = "school/";
    public static final String INNATE_SPELL_PREFIX = "innate_spell/";
    public static final String INNATE_SPELL_DESCRIPTION_PREFIX = "attribute.additional_attributes.innate_spell/";
    public static final String INNATE_SCHOOL_PREFIX = "innate_school/";
    public static final String INNATE_SCHOOL_DESCRIPTION_PREFIX = "attribute.additional_attributes.innate_school/";
    public static final int LIMIT = 100;
    public static RegistryObject<Attribute> KEEP_SCROLL = REGISTRY.register("keep_scroll", () -> new RangedAttribute("attribute.additional_attributes.keep_scroll", 0.0, 0.0, 1.0).m_22084_(true));
    public static RegistryObject<Attribute> SPELL_GENERAL = REGISTRY.register("spell_general", () -> new RangedAttribute("attribute.additional_attributes.spell_general", 0.0, 0.0, 100.0).m_22084_(true));

    @Nullable
    public static Attribute getInnateSpell(ResourceLocation resource) {
        return (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_214293_((String)"additional_attributes", (String)(INNATE_SPELL_PREFIX + resource.m_135827_() + SEPARATOR + resource.m_135815_())));
    }

    @Nullable
    public static Attribute getInnateSchool(ResourceLocation resource) {
        return (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_214293_((String)"additional_attributes", (String)(INNATE_SCHOOL_PREFIX + resource.m_135827_() + SEPARATOR + resource.m_135815_())));
    }

    public static void registerAttribute(String id) {
        Attribute attribute = new RangedAttribute("attribute.additional_attributes." + id, 0.0, 0.0, 100.0).m_22084_(true);
        ForgeRegistries.ATTRIBUTES.register(id, (Object)attribute);
        ATTRIBUTE_ENTRIES.add(attribute);
        AA.LOG.debug("Registered attribute [{}]", (Object)id);
    }

    public static void setAttributes(EntityAttributeModificationEvent event) {
        REGISTRY.getEntries().forEach(attribute -> {
            if (attribute == SPELL_GENERAL) {
                event.getTypes().forEach(type -> event.add(type, (Attribute)attribute.get()));
            } else {
                event.add(EntityType.f_20532_, (Attribute)attribute.get());
            }
        });
        for (Attribute attribute2 : ATTRIBUTE_ENTRIES) {
            String id = attribute2.m_22087_().replace("attribute.additional_attributes.", "");
            if (id.startsWith(SCHOOL_PREFIX) || id.startsWith(SCHOOL_PREFIX_NEW) || id.startsWith(SPELL_PREFIX) || id.startsWith(SPELL_PREFIX_NEW)) {
                event.getTypes().forEach(type -> event.add(type, attribute2));
                continue;
            }
            event.add(EntityType.f_20532_, attribute2);
        }
        ATTRIBUTE_ENTRIES.removeIf(attribute -> !((InnateAttribute)attribute).additional_attributes$isInnateAttribute());
    }

    public static ResourceLocation getLocation(Attribute attribute, String prefix) {
        return ResourceLocation.m_135820_((String)attribute.m_22087_().replace(prefix, "").replaceFirst(SEPARATOR, ":"));
    }
}

