/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.p1nero_ec.utils;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.effect.Void_Vortex_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Void_Howitzer_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Void_Rune_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Void_Shard_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoidEffectInvoker {
    public static boolean spawnVoidRune(Level world, double x, double y, double z, float rotation, int delay, float damage, @Nullable LivingEntity caster) {
        if (world == null) {
            return false;
        }
        world.m_7967_((Entity)new Void_Rune_Entity(world, x, y, z, rotation, delay, damage, caster));
        return true;
    }

    public static Void_Howitzer_Entity spawnVoidHowitzer(Level world, double x, double y, double z, @Nullable LivingEntity thrower) {
        if (world == null) {
            return null;
        }
        Void_Howitzer_Entity howitzer = null;
        howitzer = thrower != null ? new Void_Howitzer_Entity((EntityType)ModEntities.VOID_HOWITZER.get(), world, thrower) : new Void_Howitzer_Entity((EntityType)ModEntities.VOID_HOWITZER.get(), world);
        howitzer.m_6034_(x, y, z);
        world.m_7967_((Entity)howitzer);
        return howitzer;
    }

    public static Void_Shard_Entity spawnVoidShard(Level world, double x, double y, double z, @Nullable LivingEntity thrower) {
        if (world == null) {
            return null;
        }
        Void_Shard_Entity shard = null;
        shard = thrower != null ? new Void_Shard_Entity((EntityType)ModEntities.VOID_SHARD.get(), world, thrower) : new Void_Shard_Entity((EntityType)ModEntities.VOID_SHARD.get(), world);
        shard.m_6034_(x, y, z);
        world.m_7967_((Entity)shard);
        return shard;
    }

    public static Void_Shard_Entity spawnVoidShardWithMovement(Level world, double x, double y, double z, Vec3 movement, @Nullable LivingEntity thrower, @Nullable Entity ignoreEntity) {
        if (world == null) {
            return null;
        }
        Void_Shard_Entity shard = new Void_Shard_Entity(world, thrower, x, y, z, movement, ignoreEntity);
        world.m_7967_((Entity)shard);
        return shard;
    }

    public static boolean spawnVoidVortex(Level world, double x, double y, double z, float rotation, @Nullable LivingEntity caster, int lifespan) {
        if (world == null) {
            return false;
        }
        world.m_7967_((Entity)new Void_Vortex_Entity(world, x, y, z, rotation, caster, lifespan));
        return true;
    }

    public static boolean spawnVoidVortex(Level world, double x, double y, double z, float rotation, @Nullable LivingEntity caster) {
        return VoidEffectInvoker.spawnVoidVortex(world, x, y, z, rotation, caster, 60);
    }

    public static boolean spawnVoidVortexInFront(Level world, LivingEntity caster, double distance, int lifespan) {
        if (world == null || caster == null) {
            return false;
        }
        Vec3 lookVec = caster.m_20154_();
        Vec3 baseSpawnPos = caster.m_146892_().m_82520_(lookVec.f_82479_ * distance, -1.7, lookVec.f_82481_ * distance);
        BlockPos spawnBlockPos = BlockPos.m_274446_((Position)baseSpawnPos);
        Vec3 finalSpawnPos = baseSpawnPos;
        BlockState blockState = world.m_8055_(spawnBlockPos.m_7495_());
        if (!blockState.m_60783_((BlockGetter)world, spawnBlockPos.m_7495_(), Direction.UP)) {
            BlockState checkState;
            BlockPos checkPos;
            int i;
            for (i = 1; i <= 5; ++i) {
                checkPos = spawnBlockPos.m_6625_(i);
                checkState = world.m_8055_(checkPos);
                if (!checkState.m_60783_((BlockGetter)world, checkPos, Direction.UP)) continue;
                finalSpawnPos = new Vec3(baseSpawnPos.f_82479_, (double)checkPos.m_123342_() + 1.0, baseSpawnPos.f_82481_);
                break;
            }
            if (finalSpawnPos.equals((Object)baseSpawnPos)) {
                for (i = 1; i <= 3; ++i) {
                    checkPos = spawnBlockPos.m_6630_(i);
                    checkState = world.m_8055_(checkPos.m_7495_());
                    if (!checkState.m_60783_((BlockGetter)world, checkPos.m_7495_(), Direction.UP)) continue;
                    finalSpawnPos = new Vec3(baseSpawnPos.f_82479_, (double)checkPos.m_123342_(), baseSpawnPos.f_82481_);
                    break;
                }
            }
        }
        float rotation = caster.m_146908_() * ((float)Math.PI / 180);
        return VoidEffectInvoker.spawnVoidVortex(world, finalSpawnPos.f_82479_, finalSpawnPos.f_82480_, finalSpawnPos.f_82481_, rotation, caster, lifespan);
    }

    public static void createVoidRuneRing(Level world, double centerX, double centerY, double centerZ, @Nullable LivingEntity caster) {
        if (world == null || world.m_5776_()) {
            return;
        }
        int standingOnY = Mth.m_14107_((double)centerY) - 3;
        VoidEffectInvoker.createVoidRuneCircle(world, centerX, centerZ, standingOnY, centerY + 1.0, 6, 2.5, 0.4f, 0, caster);
        VoidEffectInvoker.createVoidRuneCircle(world, centerX, centerZ, standingOnY, centerY + 1.0, 11, 3.5, 0.36f, 2, caster);
        VoidEffectInvoker.createVoidRuneCircle(world, centerX, centerZ, standingOnY, centerY + 1.0, 14, 4.5, 0.32f, 4, caster);
        VoidEffectInvoker.createVoidRuneCircle(world, centerX, centerZ, standingOnY, centerY + 1.0, 19, 5.5, 0.28f, 6, caster);
        VoidEffectInvoker.createVoidRuneCircle(world, centerX, centerZ, standingOnY, centerY + 1.0, 26, 6.5, 0.24f, 8, caster);
        ScreenShake_Entity.ScreenShake((Level)world, (Vec3)new Vec3(centerX, centerY, centerZ), (float)30.0f, (float)0.2f, (int)0, (int)20);
    }

    private static void createVoidRuneCircle(Level world, double centerX, double centerZ, double minY, double maxY, int count, double radius, float angleOffset, int baseDelay, @Nullable LivingEntity caster) {
        for (int i = 0; i < count; ++i) {
            float angle = (float)i * (float)Math.PI * 2.0f / (float)count + angleOffset;
            double x = centerX + radius * (double)Mth.m_14089_((float)angle);
            double z = centerZ + radius * (double)Mth.m_14031_((float)angle);
            int delay = baseDelay + i % 3;
            VoidEffectInvoker.spawnVoidRuneOnGround(world, x, z, minY, maxY, angle, delay, (float)CMConfig.Voidrunedamage, caster);
        }
    }

    public static void createVoidRuneInGaps(Level world, LivingEntity caster) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 center = caster.m_20182_().m_82520_(0.0, 0.1, 0.0);
        float yawRadians = caster.m_146908_() * ((float)Math.PI / 180);
        float width = 5.0f;
        float length = 5.0f;
        double startDistance = 1.0;
        Vec3[] corners = new Vec3[]{new Vec3((double)(-width / 2.0f), 0.0, startDistance), new Vec3((double)(width / 2.0f), 0.0, startDistance), new Vec3((double)(-width / 2.0f), 0.0, startDistance + (double)length), new Vec3((double)(width / 2.0f), 0.0, startDistance + (double)length)};
        for (int i = 0; i < 4; ++i) {
            double rotatedX = corners[i].f_82479_ * Math.cos(yawRadians) - corners[i].f_82481_ * Math.sin(yawRadians);
            double rotatedZ = corners[i].f_82479_ * Math.sin(yawRadians) + corners[i].f_82481_ * Math.cos(yawRadians);
            corners[i] = new Vec3(rotatedX, corners[i].f_82480_, rotatedZ).m_82549_(center);
        }
        int runeRows = 3;
        int runeCols = 6;
        for (int row = 0; row < runeRows; ++row) {
            for (int col = 0; col < runeCols; ++col) {
                float u = ((float)row + 0.5f) / (float)runeRows;
                float v = ((float)col + 0.5f) / (float)runeCols;
                Vec3 topPos = corners[0].m_82549_(corners[1].m_82546_(corners[0]).m_82490_((double)u));
                Vec3 bottomPos = corners[2].m_82549_(corners[3].m_82546_(corners[2]).m_82490_((double)u));
                Vec3 runePos = topPos.m_82549_(bottomPos.m_82546_(topPos).m_82490_((double)v));
                double randomOffsetX = (world.f_46441_.m_188500_() - 0.5) * 0.8;
                double randomOffsetZ = (world.f_46441_.m_188500_() - 0.5) * 0.8;
                double finalX = runePos.f_82479_ + randomOffsetX;
                double finalZ = runePos.f_82481_ + randomOffsetZ;
                int delay = row * 3 + col * 2;
                VoidEffectInvoker.spawnVoidRuneOnGround(world, finalX, finalZ, caster.m_20186_() - 1.0, caster.m_20186_() + 2.0, 0.0f, delay, (float)CMConfig.Voidrunedamage * 0.6f, caster);
            }
        }
    }

    public static void spawnVoidRuneOnGround(Level world, double x, double z, double minY, double maxY, float rotation, int delay, float damage, @Nullable LivingEntity caster) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)maxY, (double)z);
        boolean foundGround = false;
        double groundY = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos belowPos;
            BlockState blockstate;
            if (!(blockstate = world.m_8055_(belowPos = blockpos.m_7495_())).m_60783_((BlockGetter)world, belowPos, Direction.UP)) continue;
            if (!world.m_46859_(blockpos) && !(voxelshape = (blockstate1 = world.m_8055_(blockpos)).m_60812_((BlockGetter)world, blockpos)).m_83281_()) {
                groundY = voxelshape.m_83297_(Direction.Axis.Y);
            }
            foundGround = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (foundGround) {
            VoidEffectInvoker.spawnVoidRune(world, x, (double)blockpos.m_123342_() + groundY, z, rotation, delay, damage, caster);
        }
    }

    public static void createSimpleVoidRuneRing(Level world, double centerX, double centerY, double centerZ, @Nullable LivingEntity caster, int rings, float maxRadius) {
        if (world == null || world.m_5776_()) {
            return;
        }
        for (int ring = 1; ring <= rings; ++ring) {
            int runeCount = 6 + ring * 2;
            double radius = maxRadius * ((float)ring / (float)rings);
            for (int i = 0; i < runeCount; ++i) {
                float angle = (float)i * (float)Math.PI * 2.0f / (float)runeCount;
                double x = centerX + radius * (double)Mth.m_14089_((float)angle);
                double z = centerZ + radius * (double)Mth.m_14031_((float)angle);
                int delay = ring * 2;
                VoidEffectInvoker.spawnVoidRuneOnGround(world, x, z, centerY - 3.0, centerY + 1.0, angle, delay, (float)CMConfig.Voidrunedamage, caster);
            }
        }
    }

    public static void createForwardVoidRuneCluster(Level world, double startX, double startY, double startZ, LivingEntity caster, float yaw) {
        if (world.m_5776_()) {
            return;
        }
        float damage = (float)CMConfig.Voidrunedamage;
        Vec3 lookVec = caster.m_20154_();
        int clawCount = 3;
        double baseDistance = 1.4;
        double maxDistance = 6.0;
        double spreadAngle = 60.0;
        Vec3 upVec = new Vec3(0.0, 1.0, 0.0);
        Vec3 rightVec = lookVec.m_82537_(upVec).m_82541_();
        for (int claw = 0; claw < clawCount; ++claw) {
            double angle = -spreadAngle / 2.0 + spreadAngle * (double)claw / (double)(clawCount - 1);
            double angleRad = angle * (Math.PI / 180);
            Vec3 clawDirection = lookVec.m_82524_((float)angleRad).m_82541_();
            int runesPerClaw = claw == 1 ? 5 : 4;
            for (int i = 0; i < runesPerClaw; ++i) {
                double progress = (double)i / (double)(runesPerClaw - 1);
                double easedProgress = 1.0 - Math.pow(1.0 - progress, 1.5);
                double distance = baseDistance + (maxDistance - baseDistance) * easedProgress;
                double curveOffset = Math.sin(progress * Math.PI) * 0.5;
                Vec3 curveVector = rightVec.m_82490_(curveOffset * Math.signum(angle));
                Vec3 basePos = new Vec3(startX + clawDirection.f_82479_ * distance, startY, startZ + clawDirection.f_82481_ * distance);
                Vec3 finalPos = basePos.m_82549_(curveVector);
                double randomOffsetX = (world.f_46441_.m_188500_() - 0.5) * 0.4;
                double randomOffsetZ = (world.f_46441_.m_188500_() - 0.5) * 0.4;
                double runeX = finalPos.f_82479_ + randomOffsetX;
                double runeZ = finalPos.f_82481_ + randomOffsetZ;
                int delay = (int)(progress * 12.0) + world.f_46441_.m_188503_(4);
                float runeDamage = damage * (1.0f - (float)progress * 0.4f);
                float rotation = (float)Math.atan2(runeZ - startZ, runeX - startX);
                VoidEffectInvoker.spawnVoidRuneOnGround(world, runeX, runeZ, startY - 1.0, startY + 2.0, rotation, delay, runeDamage, caster);
            }
        }
    }
}

