/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.p1nero_ec.network.packet.clientbound;

import com.p1nero.p1nero_ec.capability.DataManager;
import com.p1nero.p1nero_ec.network.BasePacket;
import com.p1nero.p1nero_ec.network.packet.clientbound.helper.DistHelper;
import com.p1nero.p1nero_ec.network.packet.clientbound.helper.PECClientHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public record PersistentBoolDataSyncPacket(String key, boolean isLocked, boolean value) implements BasePacket
{
    public static PersistentBoolDataSyncPacket decode(FriendlyByteBuf buf) {
        String key = buf.m_130238_().getString();
        boolean isLocked = buf.readBoolean();
        boolean value = buf.readBoolean();
        return new PersistentBoolDataSyncPacket(key, isLocked, value);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130083_((Component)Component.m_237113_((String)this.key));
        buf.writeBoolean(this.isLocked);
        buf.writeBoolean(this.value);
    }

    @Override
    public void execute(Player player) {
        if (player != null) {
            if (this.isLocked) {
                DataManager.putData(player, this.key + "isLocked", true);
                return;
            }
            DataManager.putData(player, this.key, this.value);
            DataManager.putData(player, this.key + "isLocked", false);
        }
        DistHelper.runClient(() -> () -> PECClientHandler.syncBoolData(this.key, this.isLocked, this.value));
    }
}

