/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.p1nero_ec.capability;

import com.github.L_Ender.cataclysm.init.ModItems;
import com.p1nero.p1nero_ec.capability.DataManager;
import com.p1nero.p1nero_ec.client.PECSounds;
import com.p1nero.p1nero_ec.client.gui.CustomGuiRenderer;
import com.p1nero.p1nero_ec.network.PECPacketHandler;
import com.p1nero.p1nero_ec.network.PECPacketRelay;
import com.p1nero.p1nero_ec.network.packet.clientbound.SyncPECPlayerPacket;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class PECPlayer {
    public static final int MAX_SKILL_POINTS = 5;
    private CompoundTag data = new CompoundTag();
    private int lastSkillPoints;
    private boolean isClientLockOn;

    public static boolean isValidWeapon(ItemStack itemStack) {
        return itemStack.m_150930_((Item)ModItems.CERAUNUS.get()) || itemStack.m_150930_((Item)ModItems.INFERNAL_FORGE.get()) || itemStack.m_150930_((Item)ModItems.GAUNTLET_OF_GUARD.get()) || itemStack.m_150930_((Item)ModItems.THE_ANNIHILATOR.get()) || itemStack.m_150930_((Item)ModItems.THE_INCINERATOR.get()) || itemStack.m_150930_((Item)ModItems.SOUL_RENDER.get()) || itemStack.m_150930_((Item)ModItems.ASTRAPE.get()) || itemStack.m_150930_((Item)ModItems.WRATH_OF_THE_DESERT.get()) || itemStack.m_150930_((Item)ModItems.TIDAL_CLAWS.get());
    }

    public static void addSkillPoint(ServerPlayer serverPlayer) {
        serverPlayer.m_5634_(2.0f);
        double current = DataManager.skillPoint.get((Player)serverPlayer);
        if (current < 5.0) {
            DataManager.skillPoint.put((Player)serverPlayer, current + 1.0);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)PECSounds.GAIN_ABILITY_POINTS.getHolder().orElseThrow(), SoundSource.PLAYERS, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), (float)(1.0 + (double)0.1f * current), (float)((double)0.7f + (double)0.1f * current), (long)serverPlayer.m_217043_().m_188502_()));
        }
    }

    public static void setSkillPoint(ServerPlayer serverPlayer, int point) {
        if (point < 5 && point >= 0) {
            int current = DataManager.skillPoint.get((Player)serverPlayer).intValue();
            DataManager.skillPoint.put((Player)serverPlayer, Double.valueOf(point));
            if (point > current) {
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)PECSounds.GAIN_ABILITY_POINTS.getHolder().orElseThrow(), SoundSource.PLAYERS, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 1.0f + 0.1f * (float)point, 0.7f + 0.1f * (float)point, (long)serverPlayer.m_217043_().m_188502_()));
            }
        }
    }

    public static boolean hasSkillPoint(Player player, int count) {
        return DataManager.skillPoint.get(player) > (double)count;
    }

    public static boolean consumeSkillPoint(ServerPlayer serverPlayer, int consumeValue) {
        if (serverPlayer.m_7500_()) {
            return true;
        }
        int current = PECPlayer.getSkillPoint((Player)serverPlayer);
        if (current >= consumeValue) {
            PECPlayer.setSkillPoint(serverPlayer, current - consumeValue);
            return true;
        }
        return false;
    }

    public static int getSkillPoint(Player player) {
        return DataManager.skillPoint.get(player).intValue();
    }

    public int getLastSkillPoints() {
        return this.lastSkillPoints;
    }

    public void setLastSkillPoints(int lastSkillPoints) {
        this.lastSkillPoints = lastSkillPoints;
    }

    public boolean isClientLockOn() {
        return this.isClientLockOn;
    }

    public void setClientLockOn(boolean clientLockOn) {
        this.isClientLockOn = clientLockOn;
    }

    public boolean getBoolean(String key) {
        return this.data.m_128471_(key);
    }

    public double getDouble(String key) {
        return this.data.m_128459_(key);
    }

    public String getString(String key) {
        return this.data.m_128461_(key);
    }

    public void putBoolean(String key, boolean value) {
        this.data.m_128379_(key, value);
    }

    public void putDouble(String key, double v) {
        this.data.m_128347_(key, v);
    }

    public void putString(String k, String v) {
        this.data.m_128359_(k, v);
    }

    public CompoundTag getData() {
        return this.data;
    }

    public void setData(Consumer<CompoundTag> consumer) {
        consumer.accept(this.data);
    }

    public CompoundTag saveNBTData(CompoundTag tag) {
        tag.m_128365_("customDataManager", (Tag)this.data);
        return tag;
    }

    public void loadNBTData(CompoundTag tag) {
        this.lastSkillPoints = 0;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CustomGuiRenderer.reset();
        }
        this.data = tag.m_128469_("customDataManager");
    }

    public void copyFrom(PECPlayer old) {
        this.data = old.data;
    }

    public void syncToClient(ServerPlayer serverPlayer) {
        PECPacketRelay.sendToPlayer(PECPacketHandler.INSTANCE, new SyncPECPlayerPacket(this.saveNBTData(new CompoundTag())), serverPlayer);
    }

    public void tick(Player player) {
        if (player.m_7578_()) {
            // empty if block
        }
    }
}

