/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.p1nero_ec.capability;

import com.p1nero.p1nero_ec.capability.PECPlayer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="p1nero_ec")
public class PECCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<PECPlayer> TCR_PLAYER = CapabilityManager.get((CapabilityToken)new CapabilityToken<PECPlayer>(){});
    private PECPlayer PECPlayer = null;
    private final LazyOptional<PECPlayer> optional = LazyOptional.of(this::createTCRPlayer);

    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Player player;
        Object object = event.getObject();
        if (object instanceof Player && !(player = (Player)object).getCapability(TCR_PLAYER).isPresent()) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"p1nero_ec", (String)"pec_player"), (ICapabilityProvider)new PECCapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(TCR_PLAYER).ifPresent(oldStore -> event.getEntity().getCapability(TCR_PLAYER).ifPresent(newStore -> {
                newStore.copyFrom((PECPlayer)oldStore);
                newStore.syncToClient((ServerPlayer)event.getEntity());
            }));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            PECCapabilityProvider.getPlayer(event.player).tick(event.player);
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PECPlayer.class);
    }

    public static PECPlayer getPlayer(Player player) {
        if (player == null) {
            return new PECPlayer();
        }
        return (PECPlayer)player.getCapability(TCR_PLAYER).orElse((Object)new PECPlayer());
    }

    public static void syncPlayerDataToClient(ServerPlayer serverPlayer) {
        PECCapabilityProvider.getPlayer((Player)serverPlayer).syncToClient(serverPlayer);
    }

    private PECPlayer createTCRPlayer() {
        if (this.PECPlayer == null) {
            this.PECPlayer = new PECPlayer();
        }
        return this.PECPlayer;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        if (capability == TCR_PLAYER) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.createTCRPlayer().saveNBTData(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.createTCRPlayer().loadNBTData(tag);
    }
}

