/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.p1nero_ec.capability;

import com.p1nero.p1nero_ec.capability.PECCapabilityProvider;
import com.p1nero.p1nero_ec.capability.PECPlayer;
import com.p1nero.p1nero_ec.network.PECPacketHandler;
import com.p1nero.p1nero_ec.network.PECPacketRelay;
import com.p1nero.p1nero_ec.network.packet.clientbound.PersistentBoolDataSyncPacket;
import com.p1nero.p1nero_ec.network.packet.clientbound.PersistentDoubleDataSyncPacket;
import com.p1nero.p1nero_ec.network.packet.clientbound.PersistentStringDataSyncPacket;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class DataManager {
    private static final Set<String> EXISTING_ID = new HashSet<String>();
    public static BoolData firstJoint = new BoolData("first_joint", false);
    public static DoubleData skillPoint = new DoubleData("skill_point", 0.0);
    public static BoolData isLockOn = new BoolData("is_lock_on", false);

    public static void putData(Player player, String key, double value) {
        DataManager.getSMCPlayer(player).putDouble(key, value);
    }

    public static void putData(Player player, String key, String value) {
        DataManager.getSMCPlayer(player).putString(key, value);
    }

    public static void putData(Player player, String key, boolean value) {
        DataManager.getSMCPlayer(player).putBoolean(key, value);
    }

    public static boolean getBool(Player player, String key) {
        return DataManager.getSMCPlayer(player).getBoolean(key);
    }

    public static double getDouble(Player player, String key) {
        return DataManager.getSMCPlayer(player).getDouble(key);
    }

    public static String getString(Player player, String key) {
        return DataManager.getSMCPlayer(player).getString(key);
    }

    public static PECPlayer getSMCPlayer(Player player) {
        return (PECPlayer)player.getCapability(PECCapabilityProvider.TCR_PLAYER).orElse((Object)new PECPlayer());
    }

    public static class BoolData
    extends Data<Boolean> {
        boolean defaultBool;

        public BoolData(String key, boolean defaultBool) {
            super(key);
            this.defaultBool = defaultBool;
        }

        @Override
        public void init(Player player) {
            this.isLocked = DataManager.getSMCPlayer(player).getBoolean(this.key + "isLocked");
            this.put(player, this.defaultBool);
        }

        @Override
        public void put(Player player, Boolean value) {
            if (this.isLocked(player)) {
                return;
            }
            DataManager.getSMCPlayer(player).putBoolean(this.key, value);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PECPacketRelay.sendToPlayer(PECPacketHandler.INSTANCE, new PersistentBoolDataSyncPacket(this.key, this.isLocked, value), serverPlayer);
            } else {
                PECPacketRelay.sendToServer(PECPacketHandler.INSTANCE, new PersistentBoolDataSyncPacket(this.key, this.isLocked, value));
            }
        }

        @Override
        public Boolean get(Player player) {
            return DataManager.getSMCPlayer(player).getBoolean(this.key);
        }

        public boolean get(CompoundTag playerData) {
            return playerData.m_128471_(this.key);
        }
    }

    public static class DoubleData
    extends Data<Double> {
        private double defaultValue = 0.0;

        public DoubleData(String key, double defaultValue) {
            super(key);
            this.defaultValue = defaultValue;
        }

        @Override
        public void init(Player player) {
            this.isLocked = DataManager.getSMCPlayer(player).getBoolean(this.key + "isLocked");
            this.put(player, this.defaultValue);
        }

        @Override
        public void put(Player player, Double value) {
            if (!this.isLocked(player)) {
                DataManager.getSMCPlayer(player).putDouble(this.key, value);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PECPacketRelay.sendToPlayer(PECPacketHandler.INSTANCE, new PersistentDoubleDataSyncPacket(this.key, this.isLocked, value), serverPlayer);
                }
            }
        }

        @Override
        public Double get(Player player) {
            return DataManager.getSMCPlayer(player).getDouble(this.key);
        }

        public double get(CompoundTag playerData) {
            return playerData.m_128459_(this.key);
        }
    }

    public static class StringData
    extends Data<String> {
        protected boolean isLocked = false;
        protected String defaultString = "";

        public StringData(String key, String defaultString) {
            super(key);
            this.defaultString = defaultString;
        }

        @Override
        public void init(Player player) {
            this.put(player, this.defaultString);
        }

        @Override
        public void put(Player player, String value) {
            if (!this.isLocked(player)) {
                DataManager.getSMCPlayer(player).putString(this.key, value);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PECPacketRelay.sendToPlayer(PECPacketHandler.INSTANCE, new PersistentStringDataSyncPacket(this.key, this.isLocked, value), serverPlayer);
                }
            }
        }

        @Override
        public String get(Player player) {
            return DataManager.getSMCPlayer(player).getString(this.key);
        }

        public String get(CompoundTag playerData) {
            return playerData.m_128461_(this.key);
        }
    }

    public static abstract class Data<T> {
        protected String key;
        protected boolean isLocked = false;
        protected int id;

        public Data(String key) {
            if (EXISTING_ID.contains(key)) {
                throw new IllegalArgumentException(key + " is already exist!");
            }
            this.key = key;
            EXISTING_ID.add(key);
        }

        public String getKey() {
            return this.key;
        }

        public void init(Player player) {
            this.isLocked = DataManager.getSMCPlayer(player).getBoolean(this.key + "isLocked");
        }

        public boolean isLocked(Player player) {
            return DataManager.getSMCPlayer(player).getBoolean(this.key + "isLocked");
        }

        public boolean isLocked(CompoundTag playerData) {
            return playerData.m_128471_(this.key + "isLocked");
        }

        public void lock(Player player) {
            DataManager.getSMCPlayer(player).putBoolean(this.key + "isLocked", true);
            this.isLocked = true;
        }

        public void unLock(Player player) {
            DataManager.getSMCPlayer(player).putBoolean(this.key + "isLocked", false);
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            this.isLocked = false;
        }

        public abstract T get(Player var1);

        public abstract void put(Player var1, T var2);
    }
}

