/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.attachments.WorldDataAttachment;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"settlement-roads");
    private static final DynamicCommandExceptionType STRUCTURE_INVALID_EXCEPTION = new DynamicCommandExceptionType(id -> Component.m_237110_((String)"commands.locate.structure.invalid", (Object[])new Object[]{id}));
    private static final DynamicCommandExceptionType STRUCTURE_NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(id -> Component.m_237110_((String)"commands.locate.structure.not_found", (Object[])new Object[]{id}));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static void locateConfiguredStructure(ServerLevel serverWorld, int locateCount, boolean locateAtPlayer) {
        LOGGER.debug("Locating " + locateCount + " " + ModConfig.structureToLocate);
        try {
            int x = 0;
            while (x < locateCount) {
                if (locateAtPlayer) {
                    for (ServerPlayer player : serverWorld.m_6907_()) {
                        StructureLocator.executeLocateStructure(player.m_20183_(), serverWorld, (ResourceOrTagKeyArgument.Result<Structure>)new ResourceOrTagKeyArgument(Registries.f_256944_).parse(new StringReader(ModConfig.structureToLocate)));
                    }
                } else {
                    StructureLocator.executeLocateStructure(serverWorld.m_220360_(), serverWorld, (ResourceOrTagKeyArgument.Result<Structure>)new ResourceOrTagKeyArgument(Registries.f_256944_).parse(new StringReader(ModConfig.structureToLocate)));
                }
                ++x;
            }
            return;
        }
        catch (CommandSyntaxException e) {
            LOGGER.warn("Failed to locate structure: " + ModConfig.structureToLocate + " in dimension " + String.valueOf(serverWorld.m_46472_().m_135782_()) + " with exception: " + e.getMessage());
        }
    }

    private static void executeLocateStructure(BlockPos locatePos, ServerLevel serverWorld, ResourceOrTagKeyArgument.Result<Structure> predicate) throws CommandSyntaxException {
        Registry registry = serverWorld.m_9598_().m_175515_(Registries.f_256944_);
        HolderSet registryEntryList = (HolderSet)StructureLocator.getStructureListForPredicate(predicate, (Registry<Structure>)registry).orElseThrow(() -> STRUCTURE_INVALID_EXCEPTION.create((Object)predicate.m_245390_()));
        Pair pair = serverWorld.m_7726_().m_8481_().m_223037_(serverWorld, registryEntryList, locatePos, 100, true);
        if (pair == null) {
            throw STRUCTURE_NOT_FOUND_EXCEPTION.create((Object)predicate.m_245390_());
        }
        BlockPos structureLocation = (BlockPos)pair.getFirst();
        LOGGER.debug("Structure found at " + String.valueOf(structureLocation));
        ((Records.StructureLocationData)serverWorld.getAttached(WorldDataAttachment.STRUCTURE_LOCATIONS)).addStructure(structureLocation);
    }

    private static Optional<? extends HolderSet.ListBacked<Structure>> getStructureListForPredicate(ResourceOrTagKeyArgument.Result<Structure> predicate, Registry<Structure> structureRegistry) {
        return (Optional)predicate.m_245276_().map(key -> structureRegistry.m_203636_(key).map(entry -> HolderSet.m_205809_((Holder[])new Holder[]{entry})), arg_0 -> structureRegistry.m_203431_(arg_0));
    }
}

