/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.roadlogic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.countered.settlementroads.features.roadlogic.RoadDirection;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadPathCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"settlement-roads");
    private static final int neighborDistance = 4;
    public static final Map<Long, Integer> heightCache = new ConcurrentHashMap<Long, Integer>();

    private static long hashXZ(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static List<Records.RoadSegmentPlacement> calculateAStarRoadPath(BlockPos start, BlockPos end, int width, ServerLevel serverWorld, int maxSteps) {
        PriorityQueue<Node> openSet = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.fScore));
        HashMap<BlockPos, Node> allNodes = new HashMap<BlockPos, Node>();
        HashSet<BlockPos> closedSet = new HashSet<BlockPos>();
        HashMap<BlockPos, List<BlockPos>> interpolatedSegments = new HashMap<BlockPos, List<BlockPos>>();
        int startX = RoadPathCalculator.snapToGrid(start.m_123341_(), 4);
        int startZ = RoadPathCalculator.snapToGrid(start.m_123343_(), 4);
        int endX = RoadPathCalculator.snapToGrid(end.m_123341_(), 4);
        int endZ = RoadPathCalculator.snapToGrid(end.m_123343_(), 4);
        start = new BlockPos(startX, start.m_123342_(), startZ);
        end = new BlockPos(endX, end.m_123342_(), endZ);
        BlockPos startGround = new BlockPos(start.m_123341_(), RoadPathCalculator.heightSampler(start.m_123341_(), start.m_123343_(), serverWorld), start.m_123343_());
        BlockPos endGround = new BlockPos(end.m_123341_(), RoadPathCalculator.heightSampler(end.m_123341_(), end.m_123343_(), serverWorld), end.m_123343_());
        Node startNode = new Node(startGround, null, 0.0, RoadPathCalculator.heuristic(startGround, endGround));
        openSet.add(startNode);
        allNodes.put(startGround, startNode);
        int d = 4;
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        while (!openSet.isEmpty() && maxSteps-- > 0) {
            Node current = openSet.poll();
            if (current.pos.m_175288_(0).m_123333_((Vec3i)endGround.m_175288_(0)) < 8) {
                LOGGER.debug("Found path! " + String.valueOf(current.pos));
                return RoadPathCalculator.reconstructPath(current, width, interpolatedSegments);
            }
            closedSet.add(current.pos);
            allNodes.remove(current.pos);
            for (int[] offset : neighborOffsets) {
                BlockPos neighborXZ = current.pos.m_7918_(offset[0], 0, offset[1]);
                int y = RoadPathCalculator.heightSampler(neighborXZ.m_123341_(), neighborXZ.m_123343_(), serverWorld);
                BlockPos neighborPos = new BlockPos(neighborXZ.m_123341_(), y, neighborXZ.m_123343_());
                if (closedSet.contains(neighborPos)) continue;
                Holder<Biome> biomeRegistryEntry = RoadPathCalculator.biomeSampler(neighborPos, serverWorld);
                int biomeCost = biomeRegistryEntry.m_203656_(BiomeTags.f_207605_) || biomeRegistryEntry.m_203656_(BiomeTags.f_207603_) || biomeRegistryEntry.m_203656_(BiomeTags.f_207602_) ? 50 : 0;
                int elevation = Math.abs(y - current.pos.m_123342_());
                if (elevation > 3) continue;
                int offsetSum = Math.abs(Math.abs(offset[0])) + Math.abs(offset[1]);
                double stepCost = offsetSum == 8 ? 1.5 : 1.0;
                int terrainStabilityCost = RoadPathCalculator.calculateTerrainStability(neighborPos, y, serverWorld);
                if (terrainStabilityCost > 2) continue;
                int yLevelCost = y == 62 ? 20 : 0;
                double tentativeG = current.gScore + stepCost + (double)(elevation * 40) + (double)(biomeCost * 8) + (double)(yLevelCost * 8) + (double)(terrainStabilityCost * 16);
                Node neighbor = (Node)allNodes.get(neighborPos);
                if (neighbor != null && !(tentativeG < neighbor.gScore)) continue;
                double h = RoadPathCalculator.heuristic(neighborPos, endGround);
                neighbor = new Node(neighborPos, current, tentativeG, tentativeG + h);
                allNodes.put(neighborPos, neighbor);
                openSet.add(neighbor);
                ArrayList<BlockPos> segmentPoints = new ArrayList<BlockPos>();
                for (int i = 1; i < 4; ++i) {
                    int interpX = current.pos.m_123341_() + offset[0] * i / 4;
                    int interpZ = current.pos.m_123343_() + offset[1] * i / 4;
                    BlockPos interpolated = new BlockPos(interpX, current.pos.m_123342_(), interpZ);
                    segmentPoints.add(interpolated);
                }
                interpolatedSegments.put(neighborPos, segmentPoints);
            }
        }
        return Collections.emptyList();
    }

    private static double heuristic(BlockPos a, BlockPos b) {
        int dx = a.m_123341_() - b.m_123341_();
        int dz = a.m_123343_() - b.m_123343_();
        double dxzApprox = (double)(Math.abs(dx) + Math.abs(dz)) - 0.6 * (double)Math.min(Math.abs(dx), Math.abs(dz));
        return dxzApprox * 30.0;
    }

    private static int calculateTerrainStability(BlockPos neighborPos, int y, ServerLevel serverWorld) {
        int cost = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos testPos = neighborPos.m_121945_(direction);
            int testY = RoadPathCalculator.heightSampler(testPos.m_123341_(), testPos.m_123343_(), serverWorld);
            int elevation = Math.abs(y - testY);
            if ((cost += elevation) <= 2) continue;
            return Integer.MAX_VALUE;
        }
        return cost;
    }

    private static List<Records.RoadSegmentPlacement> reconstructPath(Node endNode, int width, Map<BlockPos, List<BlockPos>> interpolatedPathMap) {
        ArrayList<Node> pathNodes = new ArrayList<Node>();
        Node current = endNode;
        while (current != null) {
            pathNodes.add(current);
            current = current.parent;
        }
        Collections.reverse(pathNodes);
        LinkedHashMap<BlockPos, Set<BlockPos>> roadSegments = new LinkedHashMap<BlockPos, Set<BlockPos>>();
        HashSet<BlockPos> widthCache = new HashSet<BlockPos>();
        for (Node node : pathNodes) {
            BlockPos pos = node.pos;
            List interpolated = interpolatedPathMap.getOrDefault(pos, Collections.emptyList());
            RoadDirection roadDirection = RoadDirection.X_AXIS;
            if (!interpolated.isEmpty()) {
                BlockPos firstInterpolated = (BlockPos)interpolated.get(0);
                int dx = pos.m_123341_() - firstInterpolated.m_123341_();
                int dz = pos.m_123343_() - firstInterpolated.m_123343_();
                if (dx < 0 && dz > 0 || dx > 0 && dz < 0) {
                    roadDirection = RoadDirection.DIAGONAL_1;
                } else if (dx < 0 && dz < 0 || dx > 0 && dz > 0) {
                    roadDirection = RoadDirection.DIAGONAL_2;
                } else if (dx == 0 && dz != 0) {
                    roadDirection = RoadDirection.Z_AXIS;
                }
                for (BlockPos interp : interpolated) {
                    Set<BlockPos> widthSetInterp = RoadPathCalculator.generateWidth(interp, width / 2, widthCache, roadDirection);
                    roadSegments.put(interp, widthSetInterp);
                }
            }
            Set<BlockPos> widthSet = RoadPathCalculator.generateWidth(pos, width / 2, widthCache, roadDirection);
            roadSegments.put(pos, widthSet);
        }
        ArrayList<Records.RoadSegmentPlacement> result = new ArrayList<Records.RoadSegmentPlacement>();
        for (Map.Entry entry : roadSegments.entrySet()) {
            result.add(new Records.RoadSegmentPlacement((BlockPos)entry.getKey(), new ArrayList<BlockPos>((Collection)entry.getValue())));
        }
        return result;
    }

    private static int heightSampler(int x, int z, ServerLevel serverWorld) {
        long key = RoadPathCalculator.hashXZ(x, z);
        return heightCache.computeIfAbsent(key, k -> serverWorld.m_7726_().m_8481_().m_223235_(x, z, Heightmap.Types.WORLD_SURFACE_WG, (LevelHeightAccessor)serverWorld, serverWorld.m_7726_().m_214994_()));
    }

    private static Holder<Biome> biomeSampler(BlockPos pos, ServerLevel serverWorld) {
        return serverWorld.m_204166_(pos);
    }

    private static int snapToGrid(int value, int gridSize) {
        return Math.floorDiv(value, gridSize) * gridSize;
    }

    private static Set<BlockPos> generateWidth(BlockPos center, int radius, Set<BlockPos> widthPositionsCache, RoadDirection direction) {
        HashSet<BlockPos> segmentWidthPositions = new HashSet<BlockPos>();
        int centerX = center.m_123341_();
        int centerZ = center.m_123343_();
        int y = 0;
        if (direction == RoadDirection.X_AXIS) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos pos = new BlockPos(centerX, y, centerZ + dz);
                if (widthPositionsCache.contains(pos)) continue;
                widthPositionsCache.add(pos);
                segmentWidthPositions.add(pos);
            }
        } else if (direction == RoadDirection.Z_AXIS) {
            for (int dx = -radius; dx <= radius; ++dx) {
                BlockPos pos = new BlockPos(centerX + dx, y, centerZ);
                if (widthPositionsCache.contains(pos)) continue;
                widthPositionsCache.add(pos);
                segmentWidthPositions.add(pos);
            }
        } else {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos;
                    if (direction == RoadDirection.DIAGONAL_2 && (dx == -radius && dz == -radius || dx == radius && dz == radius) || direction == RoadDirection.DIAGONAL_1 && (dx == -radius && dz == radius || dx == radius && dz == -radius) || widthPositionsCache.contains(pos = new BlockPos(centerX + dx, y, centerZ + dz))) continue;
                    widthPositionsCache.add(pos);
                    segmentWidthPositions.add(pos);
                }
            }
        }
        return segmentWidthPositions;
    }

    private static class Node {
        BlockPos pos;
        Node parent;
        double gScore;
        double fScore;

        Node(BlockPos pos, Node parent, double gScore, double fScore) {
            this.pos = pos;
            this.parent = parent;
            this.gScore = gScore;
            this.fScore = fScore;
        }
    }
}

