/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import net.countered.settlementroads.features.decoration.Decoration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class OrientedDecoration
extends Decoration {
    private final Vec3i orthogonalVector;

    public OrientedDecoration(BlockPos placePos, Vec3i orthogonalVector, WorldGenLevel world) {
        super(placePos, world);
        this.orthogonalVector = orthogonalVector;
    }

    protected final int getCardinalRotationFromVector(Vec3i orthogonalVector, boolean start) {
        if (start) {
            if (Math.abs(orthogonalVector.m_123341_()) > Math.abs(orthogonalVector.m_123343_())) {
                return orthogonalVector.m_123341_() > 0 ? 0 : 8;
            }
            return orthogonalVector.m_123343_() > 0 ? 4 : 12;
        }
        if (Math.abs(orthogonalVector.m_123341_()) > Math.abs(orthogonalVector.m_123343_())) {
            return orthogonalVector.m_123341_() > 0 ? 8 : 0;
        }
        return orthogonalVector.m_123343_() > 0 ? 12 : 4;
    }

    public Vec3i getOrthogonalVector() {
        return this.orthogonalVector;
    }

    protected DirectionProperties getDirectionProperties(int rotation) {
        return switch (rotation) {
            case 12 -> new DirectionProperties(Direction.NORTH, (Property<Boolean>)BlockStateProperties.f_61370_, (Property<Boolean>)BlockStateProperties.f_61368_);
            case 0 -> new DirectionProperties(Direction.EAST, (Property<Boolean>)BlockStateProperties.f_61371_, (Property<Boolean>)BlockStateProperties.f_61369_);
            case 4 -> new DirectionProperties(Direction.SOUTH, (Property<Boolean>)BlockStateProperties.f_61368_, (Property<Boolean>)BlockStateProperties.f_61370_);
            default -> new DirectionProperties(Direction.WEST, (Property<Boolean>)BlockStateProperties.f_61369_, (Property<Boolean>)BlockStateProperties.f_61371_);
        };
    }

    protected static class DirectionProperties {
        Direction offsetDirection;
        Property<Boolean> reverseDirectionProperty;
        Property<Boolean> directionProperty;

        DirectionProperties(Direction offset, Property<Boolean> reverse, Property<Boolean> direction) {
            this.offsetDirection = offset;
            this.reverseDirectionProperty = reverse;
            this.directionProperty = direction;
        }
    }
}

