/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.decoration.Decoration;
import net.countered.settlementroads.features.decoration.DistanceSignDecoration;
import net.countered.settlementroads.features.decoration.FenceWaypointDecoration;
import net.countered.settlementroads.features.decoration.LamppostDecoration;
import net.countered.settlementroads.features.decoration.RoadStructures;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.attachments.WorldDataAttachment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadFeature
extends Feature<RoadFeatureConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"settlement-roads");
    public static final Set<Block> dontPlaceHere = new HashSet<Block>();
    public static int chunksForLocatingCounter;
    public static final ResourceKey<PlacedFeature> ROAD_FEATURE_PLACED_KEY;
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROAD_FEATURE_KEY;
    public static final Feature<RoadFeatureConfig> ROAD_FEATURE;

    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RoadFeatureConfig> context) {
        if (RoadPathCalculator.heightCache.size() > 100000) {
            RoadPathCalculator.heightCache.clear();
        }
        ServerLevel serverWorld = context.m_159774_().m_6018_();
        WorldGenLevel structureWorldAccess = context.m_159774_();
        Records.StructureLocationData structureLocationData = (Records.StructureLocationData)serverWorld.getAttached(WorldDataAttachment.STRUCTURE_LOCATIONS);
        if (structureLocationData == null) {
            return false;
        }
        List<BlockPos> villageLocations = structureLocationData.structureLocations();
        this.tryFindNewStructureConnection(villageLocations, serverWorld);
        HashSet<Decoration> roadDecorationCache = new HashSet<Decoration>();
        this.runRoadLogic(structureWorldAccess, context, roadDecorationCache);
        RoadStructures.tryPlaceDecorations(roadDecorationCache);
        return true;
    }

    private void tryFindNewStructureConnection(List<BlockPos> villageLocations, ServerLevel serverWorld) {
        if ((villageLocations == null || villageLocations.size() < ModConfig.maxLocatingCount) && ++chunksForLocatingCounter > 300) {
            List connectionList = (List)serverWorld.getAttached(WorldDataAttachment.CONNECTED_STRUCTURES);
            serverWorld.m_7654_().execute(() -> StructureConnector.cacheNewConnection(serverWorld, true));
            chunksForLocatingCounter = 1;
        }
    }

    private void runRoadLogic(WorldGenLevel structureWorldAccess, FeaturePlaceContext<RoadFeatureConfig> context, Set<Decoration> roadDecorationPlacementPositions) {
        int averagingRadius = ModConfig.averagingRadius;
        List roadDataList = (List)structureWorldAccess.m_6018_().getAttached(WorldDataAttachment.ROAD_DATA_LIST);
        if (roadDataList == null) {
            return;
        }
        ChunkPos currentChunkPos = new ChunkPos(context.m_159777_());
        HashSet<BlockPos> posAlreadyContainsSegment = new HashSet<BlockPos>();
        for (Records.RoadData data : roadDataList) {
            int roadType = data.roadType();
            List<BlockState> materials = data.materials();
            List<Records.RoadSegmentPlacement> segmentList = data.roadSegmentList();
            List<BlockPos> middlePositions = segmentList.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
            int segmentIndex = 0;
            for (int i = 2; i < segmentList.size() - 2; ++i) {
                ChunkPos middleChunkPos;
                if (posAlreadyContainsSegment.contains(middlePositions.get(i))) continue;
                Records.RoadSegmentPlacement segment = segmentList.get(i);
                BlockPos segmentMiddlePos = segment.middlePos();
                if (++segmentIndex < 60 || segmentIndex > segmentList.size() - 60 || !(middleChunkPos = new ChunkPos(segmentMiddlePos)).equals((Object)currentChunkPos)) continue;
                BlockPos prevPos = middlePositions.get(i - 2);
                BlockPos nextPos = middlePositions.get(i + 2);
                ArrayList<Double> heights = new ArrayList<Double>();
                for (int j = i - averagingRadius; j <= i + averagingRadius; ++j) {
                    if (j < 0 || j >= middlePositions.size()) continue;
                    BlockPos samplePos = middlePositions.get(j);
                    double y = structureWorldAccess.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, samplePos.m_123341_(), samplePos.m_123343_());
                    heights.add(y);
                }
                int averageY = (int)Math.round(heights.stream().mapToDouble(Double::doubleValue).average().orElse(segmentMiddlePos.m_123342_()));
                BlockPos averagedPos = new BlockPos(segmentMiddlePos.m_123341_(), averageY, segmentMiddlePos.m_123343_());
                RandomSource random = context.m_225041_();
                if (!ModConfig.placeWaypoints) {
                    for (BlockPos widthBlock : segment.positions()) {
                        BlockPos correctedYPos = new BlockPos(widthBlock.m_123341_(), averageY, widthBlock.m_123343_());
                        this.placeOnSurface(structureWorldAccess, correctedYPos, materials, roadType, random);
                    }
                }
                this.addDecoration(structureWorldAccess, roadDecorationPlacementPositions, averagedPos, segmentIndex, nextPos, prevPos, middlePositions, roadType, random);
                posAlreadyContainsSegment.add(segmentMiddlePos);
            }
        }
    }

    private void addDecoration(WorldGenLevel structureWorldAccess, Set<Decoration> roadDecorationPlacementPositions, BlockPos placePos, int segmentIndex, BlockPos nextPos, BlockPos prevPos, List<BlockPos> middleBlockPositions, int roadType, RandomSource random) {
        boolean isEnd;
        int dz;
        BlockPos surfacePos = placePos.m_175288_(structureWorldAccess.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, placePos.m_123341_(), placePos.m_123343_()));
        BlockState blockStateAtPos = structureWorldAccess.m_8055_(surfacePos.m_7495_());
        if (blockStateAtPos.equals(Blocks.f_49990_.m_49966_()) && segmentIndex % ModConfig.distanceBetweenBuoys == 0) {
            RoadStructures.placeBuoy(structureWorldAccess, surfacePos);
        }
        if (ModConfig.placeWaypoints) {
            if (segmentIndex % 25 == 0) {
                roadDecorationPlacementPositions.add(new FenceWaypointDecoration(surfacePos, structureWorldAccess));
            }
            return;
        }
        int dx = nextPos.m_123341_() - prevPos.m_123341_();
        double length = Math.sqrt(dx * dx + (dz = nextPos.m_123343_() - prevPos.m_123343_()) * dz);
        int normDx = length != 0.0 ? (int)Math.round((double)dx / length) : 0;
        int normDz = length != 0.0 ? (int)Math.round((double)dz / length) : 0;
        Vec3i directionVector = new Vec3i(normDx, 0, normDz);
        Vec3i orthogonalVector = new Vec3i(-directionVector.m_123343_(), 0, directionVector.m_123341_());
        boolean bl = isEnd = segmentIndex != middleBlockPositions.size() - 65;
        if (segmentIndex == 65 || segmentIndex == middleBlockPositions.size() - 65) {
            BlockPos shiftedPos = isEnd ? placePos.m_121955_(orthogonalVector.m_142393_(2)) : placePos.m_121996_(orthogonalVector.m_142393_(2));
            roadDecorationPlacementPositions.add(new DistanceSignDecoration(shiftedPos, orthogonalVector, structureWorldAccess, isEnd, String.valueOf(middleBlockPositions.size())));
        } else if (segmentIndex % 59 == 0) {
            boolean leftRoadSide = random.m_188499_();
            BlockPos shiftedPos = leftRoadSide ? placePos.m_121955_(orthogonalVector.m_142393_(2)) : placePos.m_121996_(orthogonalVector.m_142393_(2));
            if (Math.abs((shiftedPos = shiftedPos.m_175288_(structureWorldAccess.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, shiftedPos.m_123341_(), shiftedPos.m_123343_()))).m_123342_() - placePos.m_123342_()) > 1) {
                return;
            }
            if (roadType == 0) {
                roadDecorationPlacementPositions.add(new LamppostDecoration(shiftedPos, orthogonalVector, structureWorldAccess, leftRoadSide));
            } else {
                roadDecorationPlacementPositions.add(new FenceWaypointDecoration(shiftedPos, structureWorldAccess));
            }
        }
    }

    private void placeOnSurface(WorldGenLevel structureWorldAccess, BlockPos placePos, List<BlockState> material, int natural, RandomSource random) {
        double naturalBlockChance = 0.5;
        BlockPos surfacePos = placePos;
        if (natural == 1 || ModConfig.averagingRadius == 0) {
            surfacePos = structureWorldAccess.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, placePos);
        }
        BlockState blockStateAtPos = structureWorldAccess.m_8055_(structureWorldAccess.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, surfacePos).m_7495_());
        if (natural == 0 || random.m_188500_() < naturalBlockChance) {
            this.placeRoadBlock(structureWorldAccess, blockStateAtPos, surfacePos, material, random);
        }
    }

    private void placeRoadBlock(WorldGenLevel structureWorldAccess, BlockState blockStateAtPos, BlockPos surfacePos, List<BlockState> materials, RandomSource deterministicRandom) {
        BlockState blockStateUp;
        if (!this.placeAllowedCheck(blockStateAtPos.m_60734_()) || !structureWorldAccess.m_8055_(surfacePos.m_7495_()).m_60815_() && !structureWorldAccess.m_8055_(surfacePos.m_6625_(2)).m_60815_()) {
            return;
        }
        BlockState material = materials.get(deterministicRandom.m_188503_(materials.size()));
        this.m_5974_((LevelWriter)structureWorldAccess, surfacePos.m_7495_(), material);
        for (int i = 0; !(i >= 3 || (blockStateUp = structureWorldAccess.m_8055_(surfacePos.m_6630_(i))).m_60734_().equals(Blocks.f_50016_) || blockStateUp.m_204336_(BlockTags.f_13106_) || blockStateUp.m_204336_(BlockTags.f_13039_)); ++i) {
            this.m_5974_((LevelWriter)structureWorldAccess, surfacePos.m_6630_(i), Blocks.f_50016_.m_49966_());
        }
        BlockPos belowPos1 = surfacePos.m_6625_(2);
        BlockState belowState1 = structureWorldAccess.m_8055_(belowPos1);
        if (belowState1.m_60734_().equals(Blocks.f_50440_)) {
            this.m_5974_((LevelWriter)structureWorldAccess, belowPos1, Blocks.f_50493_.m_49966_());
        }
    }

    private boolean placeAllowedCheck(Block blockToCheck) {
        return !dontPlaceHere.contains(blockToCheck) && !blockToCheck.m_49966_().m_204336_(BlockTags.f_13035_) && !blockToCheck.m_49966_().m_204336_(BlockTags.f_13106_) && !blockToCheck.m_49966_().m_204336_(BlockTags.f_13050_) && !blockToCheck.m_49966_().m_204336_(BlockTags.f_13098_) && !blockToCheck.m_49966_().m_204336_(BlockTags.f_13090_);
    }

    static {
        dontPlaceHere.add(Blocks.f_50354_);
        dontPlaceHere.add(Blocks.f_50126_);
        dontPlaceHere.add(Blocks.f_50568_);
        dontPlaceHere.add(Blocks.f_50038_);
        dontPlaceHere.add(Blocks.f_220833_);
        chunksForLocatingCounter = 1;
        ROAD_FEATURE_PLACED_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)ResourceLocation.m_214293_((String)"settlement-roads", (String)"road_feature_placed"));
        ROAD_FEATURE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocation.m_214293_((String)"settlement-roads", (String)"road_feature"));
        ROAD_FEATURE = new RoadFeature(RoadFeatureConfig.CODEC);
    }
}

