/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.spells;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import java.util.Optional;
import net.alshanex.alshanex_familiars.entity.misc.BlueBirdEntity;
import net.alshanex.alshanex_familiars.registry.AFSchoolRegistry;
import net.alshanex.alshanex_familiars.registry.AFSoundRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class BirdsSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("alshanex_familiars", "birds_spell");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(AFSchoolRegistry.SOUND_RESOURCE).setMaxLevel(4).setCooldownSeconds(80.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.summon_count", (Object[])new Object[]{spellLevel}), Component.m_237110_((String)"ui.irons_spellbooks.hastened", (Object[])new Object[]{Utils.stringTruncation((double)((float)(1 + this.getEffectAmplifier(spellLevel, caster)) * 0.1f * 100.0f), (int)1)}), Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel, caster), (int)1)}));
    }

    public BirdsSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 3;
        this.castTime = 30;
        this.baseManaCost = 50;
    }

    public boolean allowLooting() {
        return false;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)AFSoundRegistry.BIRDS_CAST.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)AFSoundRegistry.BIRDS_SPAWN.get());
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTime = this.getDuration(spellLevel, entity);
        float radius = 1.5f + 0.185f * (float)spellLevel;
        for (int i = 0; i < spellLevel; ++i) {
            BlueBirdEntity bird = new BlueBirdEntity(world, entity, this.getEffectAmplifier(spellLevel, entity));
            bird.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get(), summonTime, 0, false, false, false));
            float yrot = 6.281f / (float)spellLevel * (float)i + entity.m_146908_() * ((float)Math.PI / 180);
            Vec3 spawn = Utils.moveToRelativeGroundLevel((Level)world, (Vec3)entity.m_146892_().m_82549_(new Vec3((double)(radius * Mth.m_14089_((float)yrot)), 0.0, (double)(radius * Mth.m_14031_((float)yrot)))), (int)10);
            bird.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
            bird.m_146922_(entity.m_146908_());
            bird.m_146867_();
            world.m_7967_((Entity)bird);
        }
        int effectAmplifier = spellLevel - 1;
        if (entity.m_21023_((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get())) {
            effectAmplifier += entity.m_21124_((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get()).m_19564_() + 1;
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get(), summonTime, effectAmplifier, false, false, true));
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public int getEffectAmplifier(int spellLevel, LivingEntity caster) {
        return spellLevel - 1;
    }

    public int getDuration(int spellLevel, LivingEntity caster) {
        return 1200;
    }
}

