/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.OwnerGetter;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.ParticleRegistry;
import java.util.EnumSet;
import java.util.List;
import net.alshanex.alshanex_familiars.entity.generic.AbstractFlyingSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.PetSpellRegistry;
import net.alshanex.alshanex_familiars.util.CylinderParticleManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SummonerPetEntity
extends AbstractFlyingSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/summoner_pet.png");

    public SummonerPetEntity(EntityType<? extends AbstractFlyingSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 120, 180).setSpells(List.of((AbstractSpell)SpellRegistry.DEVOUR_SPELL.get(), (AbstractSpell)SpellRegistry.SONIC_BOOM_SPELL.get(), (AbstractSpell)SpellRegistry.SCULK_TENTACLES_SPELL.get(), (AbstractSpell)SpellRegistry.ELDRITCH_BLAST_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.TELEPORT_SPELL.get()), List.of((AbstractSpell)SpellRegistry.EVASION_SPELL.get())).setSingleUseSpell((AbstractSpell)PetSpellRegistry.SUMMON_SHADOW.get(), 200, 400, 1, 4));
        this.f_21345_.m_25352_(3, (Goal)new DisableSculkShriekerGoal(this, this::getSummoner, 10));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22280_, (double)0.1f).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.m_150930_((Item)ItemRegistry.LOST_KNOWLEDGE_FRAGMENT.get());
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ELDRITCH.get()).getTargetingColor(), 2.0f), (double)this.m_20185_(), (double)(this.m_20186_() + (double)0.165f), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getSummoner() != null && this.f_19797_ % 5 == 0) {
            if (this.getSummoner().m_21023_(MobEffects.f_19611_)) {
                if (this.getSummoner().m_21124_(MobEffects.f_19611_).m_19557_() < 500) {
                    this.getSummoner().m_7292_(new MobEffectInstance(MobEffects.f_19611_, 500 - this.getSummoner().m_21124_(MobEffects.f_19611_).m_19557_(), 0, false, false, true));
                }
            } else {
                this.getSummoner().m_7292_(new MobEffectInstance(MobEffects.f_19611_, 500, 0, false, false, true));
            }
            if (this.getSummoner().m_21023_(MobEffects.f_19610_)) {
                this.triggerAnim("interact_controller", "interact");
                this.getSummoner().m_21195_(MobEffects.f_19610_);
            }
            if (this.getSummoner().m_21023_(MobEffects.f_216964_)) {
                this.triggerAnim("interact_controller", "interact");
                this.getSummoner().m_21195_(MobEffects.f_216964_);
            }
        }
    }

    protected class DisableSculkShriekerGoal
    extends Goal {
        private final AbstractSpellCastingPet controllerEntity;
        private final OwnerGetter owner;
        private final int radius;

        public DisableSculkShriekerGoal(AbstractSpellCastingPet controllerEntity, OwnerGetter owner, int radius) {
            this.controllerEntity = controllerEntity;
            this.owner = owner;
            this.radius = radius;
            this.m_7021_(EnumSet.noneOf(Goal.Flag.class));
        }

        public boolean m_8036_() {
            LivingEntity owner = this.owner.get();
            if (owner == null) {
                return false;
            }
            return this.controllerEntity.m_6084_() && owner.m_6084_();
        }

        public void m_8037_() {
            LivingEntity owner = this.owner.get();
            BlockPos controllerPos = owner.m_20183_();
            for (int x = -this.radius; x <= this.radius; ++x) {
                for (int y = -this.radius; y <= this.radius; ++y) {
                    for (int z = -this.radius; z <= this.radius; ++z) {
                        BlockPos currentPos = controllerPos.m_7918_(x, y, z);
                        BlockState blockState = this.controllerEntity.m_9236_().m_8055_(currentPos);
                        if (!blockState.m_60713_(Blocks.f_220858_) || !((Boolean)blockState.m_61143_((Property)SculkShriekerBlock.f_222152_)).booleanValue()) continue;
                        SummonerPetEntity.this.triggerAnim("interact_controller", "interact");
                        CylinderParticleManager.spawnParticlesAtBlockPos(owner.m_9236_(), currentPos.m_252807_(), 50, (ParticleOptions)ParticleRegistry.FIREFLY_PARTICLE.get(), CylinderParticleManager.ParticleDirection.UPWARD, 0.5, 0.0, 0.0);
                        this.controllerEntity.m_9236_().m_7731_(currentPos, (BlockState)blockState.m_61124_((Property)SculkShriekerBlock.f_222152_, (Comparable)Boolean.valueOf(false)), 3);
                    }
                }
            }
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }
    }
}

