/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.effect.SummonTimer;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.util.OwnerHelper;
import java.util.UUID;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.registry.EntityRegistry;
import net.alshanex.alshanex_familiars.registry.PetSpellRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ShadowEntity
extends PathfinderMob
implements MagicSummon,
GeoEntity {
    protected LivingEntity cachedSummoner;
    protected UUID summonerUUID;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ShadowEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 0;
    }

    public ShadowEntity(Level level, LivingEntity owner) {
        this((EntityType<? extends PathfinderMob>)((EntityType)EntityRegistry.SHADOW_SUMMON.get()), level);
        this.setSummoner(owner);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, true));
        this.f_21345_.m_25352_(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, this::getSummoner, (double)0.9f, 15.0f, 5.0f, false, 25.0f));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, this::getSummoner));
        this.f_21346_.m_25352_(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, this::getSummoner));
        this.f_21346_.m_25352_(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, this::getSummoner));
        this.f_21346_.m_25352_(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || this.isAlliedHelper(pEntity);
    }

    public LivingEntity getSummoner() {
        return OwnerHelper.getAndCacheOwner((Level)this.m_9236_(), (LivingEntity)this.cachedSummoner, (UUID)this.summonerUUID);
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.m_20148_();
            this.cachedSummoner = owner;
        }
    }

    public void onRemovedFromWorld() {
        this.onRemovedHelper((Entity)this, (SummonTimer)MobEffectRegistry.RAISE_DEAD_TIMER.get());
        super.onRemovedFromWorld();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!pSource.m_269533_(DamageTypeTags.f_268738_) && this.shouldIgnoreDamage(pSource)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected boolean m_8028_() {
        return false;
    }

    public void onUnSummon() {
        if (!this.m_9236_().f_46443_) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123759_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            this.m_146870_();
        }
    }

    public boolean m_7327_(Entity pEntity) {
        return Utils.doMeleeAttack((Mob)this, (Entity)pEntity, (DamageSource)((AbstractSpell)PetSpellRegistry.SUMMON_SHADOW.get()).getDamageSource((Entity)this, (Entity)this.getSummoner()));
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.summonerUUID = OwnerHelper.deserializeOwner((CompoundTag)compoundTag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 3.8).m_22268_(Attributes.f_22284_, 2.0);
    }

    public boolean m_6673_(DamageSource source) {
        return true;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        OwnerHelper.serializeOwner((CompoundTag)compoundTag, (UUID)this.summonerUUID);
    }

    public float m_20998_(float pPartialTicks) {
        return 11.0f;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 2, state -> {
            if (state.isMoving() && !this.f_20911_) {
                state.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            if (!state.isMoving() && !this.f_20911_) {
                state.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 2, state -> {
            if (this.f_20911_) {
                state.setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
                return PlayState.CONTINUE;
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        })});
    }
}

