/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.OwnerGetter;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class DruidPetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/druid_pet.png");

    public DruidPetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.25, 100, 150).setSpells(List.of((AbstractSpell)SpellRegistry.FIREFLY_SWARM_SPELL.get(), (AbstractSpell)SpellRegistry.LOB_CREEPER_SPELL.get()), List.of((AbstractSpell)SpellRegistry.CHAIN_CREEPER_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.OAKSKIN_SPELL.get(), (AbstractSpell)SpellRegistry.BLIGHT_SPELL.get(), (AbstractSpell)SpellRegistry.SLOW_SPELL.get(), (AbstractSpell)SpellRegistry.INVISIBILITY_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.ROOT_SPELL.get(), 340, 400, 8, 10));
        this.f_21345_.m_25352_(11, (Goal)new ApplyBonemealGoal(this, this::getSummoner, 300));
        this.f_21345_.m_25352_(12, (Goal)new CustomBreedGoal(this));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.m_204117_(ItemTags.f_13180_);
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.NATURE.get()).getTargetingColor(), 2.0f), (double)this.m_20185_(), (double)(this.m_20186_() + (double)0.165f), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    protected class ApplyBonemealGoal
    extends Goal {
        private final AbstractSpellCastingPet controllerEntity;
        private final OwnerGetter owner;
        private final int interval;
        private int tickCounter;

        public ApplyBonemealGoal(AbstractSpellCastingPet controllerEntity, OwnerGetter owner, int interval) {
            this.controllerEntity = controllerEntity;
            this.interval = interval;
            this.owner = owner;
            this.tickCounter = 0;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity owner = this.owner.get();
            if (owner == null || !(owner instanceof Player)) {
                return false;
            }
            return this.controllerEntity.m_6084_() && owner.m_6084_();
        }

        public void m_8037_() {
            ++this.tickCounter;
            if (this.tickCounter >= this.interval) {
                this.tickCounter = 0;
                BlockPos targetPos = this.controllerEntity.m_20183_();
                Level level = this.controllerEntity.m_9236_();
                Player player = (Player)this.owner.get();
                DruidPetEntity.this.triggerAnim("interact_controller", "interact");
                for (int x = -5; x <= 5; ++x) {
                    for (int y = -5; y <= 5; ++y) {
                        for (int z = -5; z <= 5; ++z) {
                            BlockPos currentPos = targetPos.m_7918_(x, y, z);
                            if (!this.applyBonemeal(level, currentPos, player) || level.f_46443_) continue;
                            level.m_46796_(1505, currentPos, 15);
                        }
                    }
                }
            }
        }

        boolean applyBonemeal(Level level, BlockPos pos, Player player) {
            BonemealableBlock bonemealableblock;
            BlockState blockstate = level.m_8055_(pos);
            int hook = ForgeEventFactory.onApplyBonemeal((Player)player, (Level)level, (BlockPos)pos, (BlockState)blockstate, (ItemStack)new ItemStack((ItemLike)Items.f_42499_));
            if (hook != 0) {
                return hook > 0;
            }
            Block block = blockstate.m_60734_();
            if (block instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)block).m_7370_((LevelReader)level, pos, blockstate, level.f_46443_) && !(bonemealableblock instanceof TallGrassBlock) && bonemealableblock != Blocks.f_50035_ && !(bonemealableblock instanceof GrassBlock)) {
                if (level instanceof ServerLevel && bonemealableblock.m_214167_(level, level.f_46441_, pos, blockstate)) {
                    bonemealableblock.m_214148_((ServerLevel)level, level.f_46441_, pos, blockstate);
                }
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }
    }

    protected class CustomBreedGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private Animal animal;

        public CustomBreedGoal(AbstractSpellCastingPet pet) {
            this.pet = pet;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.animal != null) {
                return false;
            }
            this.animal = this.pet.m_9236_().m_6443_(Animal.class, this.pet.m_20191_().m_82400_(10.0), a -> a.m_5957_() && !a.m_6162_() && a.m_146764_() == 0).stream().min(Comparator.comparingDouble(arg_0 -> ((AbstractSpellCastingPet)this.pet).m_20270_(arg_0))).orElse(null);
            return this.animal != null;
        }

        public boolean m_8045_() {
            return this.animal != null && this.animal.m_6084_() && this.animal.m_5957_();
        }

        public void m_8056_() {
            this.pet.m_21573_().m_5624_((Entity)this.animal, 1.0);
        }

        public void m_8037_() {
            if (this.animal == null) {
                return;
            }
            if ((double)this.pet.m_20270_((Entity)this.animal) < 2.0) {
                this.pet.m_21563_().m_24960_((Entity)this.animal, 10.0f, 10.0f);
                if (this.animal.m_5957_() && this.animal.m_146764_() == 0) {
                    this.animal.m_27595_(null);
                }
            } else {
                this.pet.m_21573_().m_5624_((Entity)this.animal, 1.0);
            }
        }

        public void m_8041_() {
            this.animal = null;
        }
    }
}

