/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.AFSchoolRegistry;
import net.alshanex.alshanex_familiars.registry.AFSoundRegistry;
import net.alshanex.alshanex_familiars.registry.ParticleRegistry;
import net.alshanex.alshanex_familiars.registry.PetSpellRegistry;
import net.alshanex.alshanex_familiars.util.CylinderParticleManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BardPetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/bard_pet.png");
    SoundEvent playingSound = null;
    private boolean musicPlaying = false;
    private int musicTimer = 0;
    private static int MUSIC_DURATION = 4800;

    public BardPetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.25, 40, 50).setSpells(List.of((AbstractSpell)PetSpellRegistry.EXPLOSION_MELODY.get(), (AbstractSpell)PetSpellRegistry.DEFAULT_NOTE_SPELL.get(), (AbstractSpell)PetSpellRegistry.VIBRATION_SPELL.get(), (AbstractSpell)PetSpellRegistry.MUSIC_BOLT.get()), List.of(), List.of(), List.of((AbstractSpell)PetSpellRegistry.BIRDS_SPELL.get())).setSingleUseSpell((AbstractSpell)PetSpellRegistry.ANGEL_SPELL.get(), 1400, 1800, 2, 4));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.m_204117_(ItemTags.f_13159_);
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(AFSchoolRegistry.SOUND.get().getTargetingColor(), 2.0f), (double)this.m_20185_(), (double)(this.m_20186_() + (double)0.165f), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getSummoner() != null) {
            if (this.musicPlaying) {
                if (this.m_5448_() != null) {
                    this.stopMusic();
                    this.musicPlaying = false;
                    MUSIC_DURATION = 0;
                    this.musicTimer = 0;
                }
                if (this.musicTimer % 20 == 0 && this.m_5448_() == null) {
                    CylinderParticleManager.spawnParticlesAtBlockPos(this.m_9236_(), this.m_20182_(), 1, (ParticleOptions)ParticleRegistry.MUSICAL_NOTE_PARTICLE.get(), CylinderParticleManager.ParticleDirection.UPWARD, 0.1, 0.0, 0.8);
                }
                this.stopMinecraftAmbientMusic();
                if (this.musicTimer > 0) {
                    --this.musicTimer;
                } else {
                    this.playMusic();
                }
            }
            if (!this.musicPlaying && this.m_5448_() == null) {
                this.playMusic();
            }
        }
    }

    public void onRemovedFromWorld() {
        if (this.musicPlaying) {
            this.stopMusic();
            this.musicPlaying = false;
            MUSIC_DURATION = 0;
            this.musicTimer = 0;
        }
        super.onRemovedFromWorld();
    }

    private void playMusic() {
        if (!(this.m_9236_().f_46443_ || this.musicPlaying || this.m_21224_())) {
            Random random = new Random();
            int randomNumber = random.nextInt(10) + 1;
            if (randomNumber == 1) {
                this.playingSound = (SoundEvent)AFSoundRegistry.BARD_SONG_1.get();
                this.musicPlaying = true;
                this.musicTimer = MUSIC_DURATION = 2700;
            }
            if (randomNumber == 2) {
                this.playingSound = (SoundEvent)AFSoundRegistry.BARD_SONG_2.get();
                this.musicPlaying = true;
                this.musicTimer = MUSIC_DURATION = 5000;
            }
            if (randomNumber == 3) {
                this.playingSound = (SoundEvent)AFSoundRegistry.BARD_SONG_3.get();
                this.musicPlaying = true;
                this.musicTimer = MUSIC_DURATION = 3400;
            }
            if (randomNumber == 4) {
                this.playingSound = (SoundEvent)AFSoundRegistry.BARD_SONG_4.get();
                this.musicPlaying = true;
                this.musicTimer = MUSIC_DURATION = 2800;
            }
            if (randomNumber == 5) {
                this.playingSound = (SoundEvent)AFSoundRegistry.BARD_SONG_5.get();
                this.musicPlaying = true;
                this.musicTimer = MUSIC_DURATION = 4300;
            }
            if (randomNumber == 6) {
                this.playingSound = (SoundEvent)AFSoundRegistry.BARD_SONG_6.get();
                this.musicPlaying = true;
                this.musicTimer = MUSIC_DURATION = 3600;
            }
            if (randomNumber == 7) {
                this.playingSound = (SoundEvent)AFSoundRegistry.BARD_SONG_7.get();
                this.musicPlaying = true;
                this.musicTimer = MUSIC_DURATION = 1700;
            }
            if (randomNumber == 8) {
                this.playingSound = (SoundEvent)AFSoundRegistry.BARD_SONG_8.get();
                this.musicPlaying = true;
                this.musicTimer = MUSIC_DURATION = 1300;
            }
            if (randomNumber == 9) {
                this.playingSound = (SoundEvent)AFSoundRegistry.BARD_SONG_9.get();
                this.musicPlaying = true;
                this.musicTimer = MUSIC_DURATION = 4000;
            }
            if (randomNumber == 10) {
                this.playingSound = (SoundEvent)AFSoundRegistry.BARD_SONG_10.get();
                this.musicPlaying = true;
                this.musicTimer = MUSIC_DURATION = 2900;
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.playingSound, SoundSource.MUSIC, 1.0f, 1.0f);
        }
    }

    private void stopMusic() {
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_7654_() != null && this.playingSound != null) {
            Objects.requireNonNull(this.m_9236_().m_7654_()).m_6846_().m_11314_().forEach(player -> player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(this.playingSound.m_11660_(), SoundSource.MUSIC)));
            this.playingSound = null;
        }
    }

    private void stopMinecraftAmbientMusic() {
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_7654_() != null) {
            for (ServerPlayer player : Objects.requireNonNull(this.m_9236_().m_7654_()).m_6846_().m_11314_()) {
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.game"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.creative"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.menu"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.overworld.day"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.overworld.night"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.overworld.hills"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.overworld.water"), SoundSource.MUSIC));
            }
        }
    }
}

