/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.util;

import com.bawnorton.allthetrims.json.TrimMaterialJson;
import com.bawnorton.allthetrims.json.TrimModelOverrideEntryJson;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;

public abstract class TrimMaterialHelper {
    public static final Set<TrimMaterialJson> BUILTIN_TRIM_MATERIALS = new HashSet<TrimMaterialJson>();
    public static final Set<TrimModelOverrideEntryJson> BUILTIN_TRIM_MODEL_OVERRIDES = new HashSet<TrimModelOverrideEntryJson>();

    public static void forEachTrimMaterial(BiConsumer<Item, Boolean> consumer) {
        for (Item item : BuiltInRegistries.f_257033_) {
            consumer.accept(item, TrimMaterialHelper.isBuiltinMaterial(item));
        }
    }

    public static void forEachBuiltinTrimMaterial(Consumer<TrimMaterialJson> consumer) {
        for (TrimMaterialJson trimMaterial : BUILTIN_TRIM_MATERIALS) {
            consumer.accept(trimMaterial);
        }
    }

    public static void forEachBuiltinTrimModelOverride(Consumer<TrimModelOverrideEntryJson> consumer) {
        for (TrimModelOverrideEntryJson trimModelOverride : BUILTIN_TRIM_MODEL_OVERRIDES) {
            consumer.accept(trimModelOverride);
        }
    }

    public static boolean isBuiltinMaterial(Item item) {
        return BUILTIN_TRIM_MATERIALS.stream().anyMatch(material -> material.ingredient().equals(BuiltInRegistries.f_257033_.m_7981_((Object)item).toString()));
    }
}

