/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.mixin.client;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.Compat;
import com.bawnorton.allthetrims.json.JsonHelper;
import com.bawnorton.allthetrims.json.TrimModelOverrideEntryJson;
import com.bawnorton.allthetrims.json.TrimModelOverrideResourceJson;
import com.bawnorton.allthetrims.util.DebugHelper;
import com.bawnorton.allthetrims.util.TrimMaterialHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ModelManager.class})
public abstract class BakedModelManagerMixin {
    @ModifyExpressionValue(method={"method_45895(Lnet/minecraft/resource/ResourceManager;)Ljava/util/Map;"}, at={@At(value="INVOKE", target="Lnet/minecraft/resource/ResourceFinder;findResources(Lnet/minecraft/resource/ResourceManager;)Ljava/util/Map;")})
    private static Map<ResourceLocation, Resource> addTrimModels(Map<ResourceLocation, Resource> original) {
        HashSet equipmentSet = new HashSet();
        BuiltInRegistries.f_257033_.forEach(item -> {
            if (item instanceof Equipable) {
                Equipable equipment = (Equipable)item;
                equipmentSet.add(equipment);
            }
        });
        if (!BakedModelManagerMixin.allTheTrims$findBuiltinTrims(original)) {
            AllTheTrims.LOGGER.error("No builtin trims found, cannot continue, trim models will not be added", new Object[0]);
            return original;
        }
        for (Equipable equipment : equipmentSet) {
            String armourType;
            ResourceLocation equipmentId = BuiltInRegistries.f_257033_.m_7981_((Object)((Item)equipment));
            if (equipmentId.m_135827_().equals("betterend")) continue;
            ResourceLocation resourceId = new ResourceLocation(equipmentId.m_135827_(), "models/item/" + equipmentId.m_135815_() + ".json");
            switch (equipment.m_40402_()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case HEAD: {
                    String string = "helmet";
                    break;
                }
                case CHEST: {
                    String string = "chestplate";
                    break;
                }
                case LEGS: {
                    String string = "leggings";
                    break;
                }
                case FEET: {
                    String string = "boots";
                    break;
                }
                case MAINHAND: 
                case OFFHAND: {
                    String string = armourType = null;
                }
            }
            if (armourType == null) {
                if (equipment instanceof ArmorItem) {
                    AllTheTrims.LOGGER.warn("Armour Item " + equipmentId + "'s slot type is not an armour slot type, skipping", new Object[0]);
                    continue;
                }
                AllTheTrims.LOGGER.debug("Item " + equipmentId + " is not an armour item, likely expected, skipping", new Object[0]);
                continue;
            }
            Resource resource = original.get(resourceId);
            if (resource == null) {
                AllTheTrims.LOGGER.warn("Could not find resource " + resourceId + " for item " + equipmentId + ", skipping", new Object[0]);
                continue;
            }
            try {
                BufferedReader reader = resource.m_215508_();
                try {
                    JsonObject model = JsonHelper.fromJsonReader(reader, JsonObject.class);
                    BakedModelManagerMixin.allTheTrims$correctNamespace(model, "parent", "minecraft");
                    if (!model.has("textures")) {
                        AllTheTrims.LOGGER.warn("Item " + equipmentId + "'s model does not have a textures parameter, skipping", new Object[0]);
                        continue;
                    }
                    JsonObject textures = model.get("textures").getAsJsonObject();
                    if (!textures.has("layer0")) {
                        AllTheTrims.LOGGER.warn("Item " + equipmentId + "'s model does not have a layer0 texture, skipping", new Object[0]);
                        continue;
                    }
                    ArrayList<String> layers = new ArrayList<String>();
                    int layer = 0;
                    while (true) {
                        BakedModelManagerMixin.allTheTrims$correctNamespace(textures, "layer" + layer, equipmentId.m_135827_());
                        JsonElement layerElement = textures.get("layer" + layer);
                        if (layerElement == null) break;
                        layers.add(layerElement.getAsString());
                        ++layer;
                    }
                    if (layers.isEmpty()) {
                        AllTheTrims.LOGGER.warn("Item " + equipmentId + "'s model does not have any layer textures, skipping", new Object[0]);
                        continue;
                    }
                    String baseLayer = (String)layers.get(0);
                    List<TrimModelOverrideEntryJson> overrides = model.has("overrides") ? TrimModelOverrideEntryJson.fromJsonArray(model.get("overrides").getAsJsonArray()) : new ArrayList<TrimModelOverrideEntryJson>();
                    Set<Float> seenIndices = BakedModelManagerMixin.allTheTrims$findExistingTrimOverrides(overrides);
                    TrimMaterialHelper.forEachBuiltinTrimModelOverride(trimModelOverrideEntryJson -> {
                        TrimModelOverrideEntryJson.ModelPredicate<?> modelPredicate = trimModelOverrideEntryJson.predicate();
                        if (!modelPredicate.isFloatPredicate()) {
                            return;
                        }
                        float index = modelPredicate.asFloatPredicate().trimType().floatValue();
                        if (seenIndices.contains(Float.valueOf(index))) {
                            return;
                        }
                        String assetName = trimModelOverrideEntryJson.assetName();
                        if (assetName == null) {
                            return;
                        }
                        overrides.add(BakedModelManagerMixin.allTheTrims$createModelOverrideElement(baseLayer, index, assetName));
                    });
                    overrides.add(BakedModelManagerMixin.allTheTrims$createModelOverrideElement(baseLayer, Float.MAX_VALUE, "dynamic"));
                    overrides.sort(Comparator.comparingDouble(trimModelEntryJson -> {
                        TrimModelOverrideEntryJson.ModelPredicate<?> modelPredicate = trimModelEntryJson.predicate();
                        if (modelPredicate.isStringPredicate()) {
                            return Double.MAX_VALUE;
                        }
                        return modelPredicate.asFloatPredicate().trimType().floatValue();
                    }));
                    ArrayList<TrimModelOverrideResourceJson> overrideModels = new ArrayList<TrimModelOverrideResourceJson>();
                    TrimMaterialHelper.forEachBuiltinTrimModelOverride(trimModelOverrideEntryJson -> {
                        if (equipment instanceof ElytraItem && Compat.isElytraTrimsLoaded()) {
                            return;
                        }
                        TrimModelOverrideEntryJson.ModelPredicate<?> modelPredicate = trimModelOverrideEntryJson.predicate();
                        if (!modelPredicate.isFloatPredicate()) {
                            return;
                        }
                        float index = modelPredicate.asFloatPredicate().trimType().floatValue();
                        String assetName = trimModelOverrideEntryJson.assetName();
                        if (assetName == null) {
                            return;
                        }
                        overrideModels.add(BakedModelManagerMixin.allTheTrims$createModelOverrideResource(model, layers, armourType, assetName));
                    });
                    overrideModels.add(BakedModelManagerMixin.allTheTrims$createModelOverrideResource(model, layers, armourType, "dynamic"));
                    ResourceLocation baseId = new ResourceLocation(baseLayer);
                    for (TrimModelOverrideResourceJson overrideModel : overrideModels) {
                        ResourceLocation overrideModelId = baseId.m_247449_("models/" + baseId.m_135815_() + "_" + overrideModel.assetName() + "_trim.json");
                        Resource overrideResource = new Resource(resource.m_247173_(), () -> IOUtils.toInputStream((String)JsonHelper.toJsonString(overrideModel), (String)"UTF-8"));
                        DebugHelper.createDebugFile("models", equipmentId + "_" + overrideModel.assetName() + "_trim.json", JsonHelper.toJsonString(overrideModel));
                        original.put(overrideModelId, overrideResource);
                    }
                    model.add("overrides", TrimModelOverrideEntryJson.toJsonArray(overrides));
                    resource = new Resource(resource.m_247173_(), () -> IOUtils.toInputStream((String)JsonHelper.toJsonString((JsonElement)model), (String)"UTF-8"));
                    DebugHelper.createDebugFile("models", equipmentId + ".json", JsonHelper.toJsonString((JsonElement)model));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                    continue;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            original.put(resourceId, resource);
        }
        return original;
    }

    @Unique
    private static void allTheTrims$correctNamespace(JsonObject json, String key, String namespace) {
        JsonElement element = json.get(key);
        if (element == null) {
            return;
        }
        String value = element.getAsString();
        if (value.contains(":")) {
            return;
        }
        json.addProperty(key, new ResourceLocation(namespace, value).toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Unique
    private static boolean allTheTrims$findBuiltinTrims(Map<ResourceLocation, Resource> resourceMap) {
        ResourceLocation equipmentId = BuiltInRegistries.f_257033_.m_7981_((Object)Items.f_42465_);
        ResourceLocation resourceId = new ResourceLocation(equipmentId.m_135827_(), "models/item/" + equipmentId.m_135815_() + ".json");
        Resource resource = resourceMap.get(resourceId);
        try (BufferedReader reader = resource.m_215508_();){
            JsonObject model = JsonHelper.fromJsonReader(reader, JsonObject.class);
            if (!model.has("overrides")) {
                boolean bl = false;
                return bl;
            }
            JsonArray overrides = model.get("overrides").getAsJsonArray();
            Iterator iterator = overrides.iterator();
            while (iterator.hasNext()) {
                JsonElement override = (JsonElement)iterator.next();
                try {
                    TrimModelOverrideEntryJson overrideJson = TrimModelOverrideEntryJson.fromJson(override.getAsJsonObject());
                    TrimMaterialHelper.BUILTIN_TRIM_MODEL_OVERRIDES.add(overrideJson);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Unique
    @NotNull
    private static Set<Float> allTheTrims$findExistingTrimOverrides(List<TrimModelOverrideEntryJson> overrides) {
        HashSet<Float> seenIndices = new HashSet<Float>();
        for (TrimModelOverrideEntryJson overrideEntry : overrides) {
            TrimModelOverrideEntryJson.ModelPredicate<?> overridePredicate = overrideEntry.predicate();
            if (overridePredicate.isStringPredicate()) continue;
            Float index = overridePredicate.asFloatPredicate().trimType();
            seenIndices.add(index);
        }
        return seenIndices;
    }

    @Unique
    private static TrimModelOverrideResourceJson allTheTrims$createModelOverrideResource(JsonObject model, List<String> layers, String armourType, String assetName) {
        int i;
        JsonObject overrideResourceJson = new JsonObject();
        overrideResourceJson.addProperty("parent", model.get("parent").getAsString());
        JsonObject overrideTextures = new JsonObject();
        for (i = 0; i < layers.size(); ++i) {
            overrideTextures.addProperty("layer" + i, layers.get(i));
        }
        if (assetName.equals("dynamic")) {
            int trimCount = 0;
            while (trimCount < 8) {
                overrideTextures.addProperty("layer" + i, "minecraft:trims/items/" + armourType + "_trim_" + trimCount + "_" + assetName);
                ++trimCount;
                ++i;
            }
        } else {
            overrideTextures.addProperty("layer" + i, "minecraft:trims/items/" + armourType + "_trim_" + assetName);
        }
        overrideResourceJson.add("textures", (JsonElement)overrideTextures);
        return TrimModelOverrideResourceJson.fromJson(overrideResourceJson, assetName);
    }

    @Unique
    private static TrimModelOverrideEntryJson allTheTrims$createModelOverrideElement(String baseLayer, float index, String assetName) {
        JsonObject override = new JsonObject();
        JsonObject overridePredicate = new JsonObject();
        if (assetName.equals("dynamic")) {
            overridePredicate.addProperty("trim_type", assetName);
        } else {
            overridePredicate.addProperty("trim_type", (Number)Float.valueOf(index));
        }
        override.addProperty("model", baseLayer + "_" + assetName + "_trim");
        override.add("predicate", (JsonElement)overridePredicate);
        return TrimModelOverrideEntryJson.fromJson(override);
    }
}

