/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.mixin;

import com.bawnorton.allthetrims.json.JsonHelper;
import com.bawnorton.allthetrims.json.TrimMaterialJson;
import com.bawnorton.allthetrims.util.DebugHelper;
import com.bawnorton.allthetrims.util.TrimMaterialHelper;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={RegistryDataLoader.class})
public abstract class RegistryLoaderMixin {
    @ModifyExpressionValue(method={"load(Lnet/minecraft/registry/RegistryOps$RegistryInfoGetter;Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/registry/MutableRegistry;Lcom/mojang/serialization/Decoder;Ljava/util/Map;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/resource/ResourceFinder;findResources(Lnet/minecraft/resource/ResourceManager;)Ljava/util/Map;")})
    private static Map<ResourceLocation, Resource> addAllTrimMaterialJsonFiles(Map<ResourceLocation, Resource> original) {
        Iterator<Map.Entry<ResourceLocation, Resource>> iterator = original.entrySet().iterator();
        if (!iterator.hasNext()) {
            return original;
        }
        Map.Entry<ResourceLocation, Resource> first = original.entrySet().iterator().next();
        if (!first.getKey().m_135815_().contains("trim_material")) {
            return original;
        }
        for (Map.Entry<ResourceLocation, Resource> resourceEntry : original.entrySet()) {
            try {
                BufferedReader reader = resourceEntry.getValue().m_215508_();
                try {
                    JsonObject trimJson = JsonHelper.fromJsonReader(reader, JsonObject.class);
                    TrimMaterialHelper.BUILTIN_TRIM_MATERIALS.add(TrimMaterialJson.fromJson(trimJson));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        TrimMaterialHelper.forEachTrimMaterial((item, builtin) -> {
            if (builtin.booleanValue()) {
                return;
            }
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_(item);
            TrimMaterialJson trimMaterialJson = new TrimMaterialJson("dynamic", "#FFFFFF", Component.m_237110_((String)"text.allthetrims.material", (Object[])new Object[]{item.m_41466_().getString()}).getString(), itemId.toString(), Float.valueOf(Float.MAX_VALUE));
            JsonObject resourceJson = trimMaterialJson.asJson();
            Resource resource = new Resource(((Resource)first.getValue()).m_247173_(), () -> IOUtils.toInputStream((String)resourceJson.toString(), (String)"UTF-8"));
            ResourceLocation resourceId = new ResourceLocation(itemId.m_135827_(), "trim_material/" + itemId.m_135815_() + ".json");
            original.put(resourceId, resource);
            DebugHelper.createDebugFile("trim_materials", itemId + ".json", resourceJson.toString());
        });
        return original;
    }

    @Unique
    private static String allTheTrims$escape(String string) {
        return string.replace("\"", "\\\"");
    }
}

