/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.json;

import com.bawnorton.allthetrims.json.JsonHelper;
import com.bawnorton.allthetrims.json.JsonRepresentable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public record TrimModelOverrideEntryJson(String model, ModelPredicate<?> predicate) implements JsonRepresentable
{
    public static TrimModelOverrideEntryJson fromJson(JsonObject json) {
        return new TrimModelOverrideEntryJson(JsonHelper.getString(json, "model"), ModelPredicate.fromJson(JsonHelper.getObject(json, "predicate")));
    }

    public static List<TrimModelOverrideEntryJson> fromJsonArray(JsonArray overrides) {
        return JsonHelper.parseArray(overrides, TrimModelOverrideEntryJson::fromJson);
    }

    public static JsonElement toJsonArray(List<TrimModelOverrideEntryJson> overrides) {
        return JsonHelper.serializeArray(overrides, TrimModelOverrideEntryJson::asJson);
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.addProperty("model", this.model);
        json.add("predicate", (JsonElement)this.predicate.asJson());
        return json;
    }

    @Nullable
    public String assetName() {
        ResourceLocation modelId = new ResourceLocation(this.model);
        String path = modelId.m_135815_();
        int armourTypeIndex = path.indexOf("chestplate");
        if (armourTypeIndex == -1) {
            return null;
        }
        String afterArmourType = path.substring(armourTypeIndex + "chestplate".length());
        int trimIndex = afterArmourType.indexOf("_trim");
        if (trimIndex == -1) {
            return null;
        }
        return afterArmourType.substring(1, trimIndex);
    }

    public static interface ModelPredicate<T>
    extends JsonRepresentable {
        public static ModelPredicate<?> fromJson(JsonObject json) {
            if (!json.has("trim_type")) {
                throw new IllegalArgumentException("Predicate does not contain \"trim_type\": " + json);
            }
            JsonElement element = json.get("trim_type");
            if (!(element instanceof JsonPrimitive)) {
                throw new IllegalArgumentException("\"trim_type\" is not primitive: " + json);
            }
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isNumber()) {
                return new FloatModelPredicate(Float.valueOf(primitive.getAsFloat()));
            }
            return new StringModelPredicate(primitive.getAsString());
        }

        public T trimType();

        default public StringModelPredicate asStringPredicate() {
            return new StringModelPredicate(String.valueOf(this.trimType()));
        }

        default public FloatModelPredicate asFloatPredicate() {
            return new FloatModelPredicate(Float.valueOf(Float.parseFloat(this.asStringPredicate().trimType())));
        }

        default public boolean isStringPredicate() {
            return this instanceof StringModelPredicate;
        }

        default public boolean isFloatPredicate() {
            return this instanceof FloatModelPredicate;
        }
    }

    public static final class FloatModelPredicate
    extends Record
    implements ModelPredicate<Float> {
        private final Float trimType;

        public FloatModelPredicate(Float trimType) {
            this.trimType = trimType;
        }

        @Override
        public JsonObject asJson() {
            JsonObject json = new JsonObject();
            json.addProperty("trim_type", (Number)this.trimType);
            return json;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FloatModelPredicate.class, "trimType", "trimType"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FloatModelPredicate.class, "trimType", "trimType"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FloatModelPredicate.class, "trimType", "trimType"}, this, o);
        }

        @Override
        public Float trimType() {
            return this.trimType;
        }
    }

    public static final class StringModelPredicate
    extends Record
    implements ModelPredicate<String> {
        private final String trimType;

        public StringModelPredicate(String trimType) {
            this.trimType = trimType;
        }

        @Override
        public JsonObject asJson() {
            JsonObject json = new JsonObject();
            json.addProperty("trim_type", this.trimType);
            return json;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StringModelPredicate.class, "trimType", "trimType"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StringModelPredicate.class, "trimType", "trimType"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StringModelPredicate.class, "trimType", "trimType"}, this, o);
        }

        @Override
        public String trimType() {
            return this.trimType;
        }
    }
}

