/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.json;

import com.bawnorton.allthetrims.json.JsonRepresentable;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class JsonHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingStrategy((FieldNamingStrategy)FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public static <T> T fromJsonReader(BufferedReader reader, Class<T> clazz) {
        return (T)GSON.fromJson((Reader)reader, clazz);
    }

    public static <T> T fromJsonString(String string, Class<T> jsonObjectClass) {
        return (T)GSON.fromJson(string, jsonObjectClass);
    }

    public static String toJsonString(JsonElement jsonElement) {
        return GSON.toJson(jsonElement);
    }

    public static String toJsonString(JsonRepresentable jsonRepresentable) {
        return JsonHelper.toJsonString((JsonElement)jsonRepresentable.asJson());
    }

    public static String getString(JsonObject json, String key) {
        return json.get(key).getAsString();
    }

    public static String getStringOrElse(JsonObject json, String key, String defaultValue) {
        JsonElement element = json.get(key);
        if (element == null) {
            return defaultValue;
        }
        return element.getAsString();
    }

    public static JsonObject getObject(JsonObject json, String key) {
        return json.get(key).getAsJsonObject();
    }

    public static Float getFloat(JsonObject json, String key) {
        return Float.valueOf(json.get(key).getAsFloat());
    }

    public static Map<String, String> asStringMap(JsonObject json) {
        return (Map)GSON.fromJson((JsonElement)json, Map.class);
    }

    public static <T> List<T> parseArray(JsonArray array, Function<JsonObject, T> parser) {
        ArrayList<T> list = new ArrayList<T>();
        for (JsonElement element : array) {
            if (!element.isJsonObject()) continue;
            try {
                list.add(parser.apply(element.getAsJsonObject()));
            }
            catch (RuntimeException runtimeException) {}
        }
        return list;
    }

    public static <T> JsonArray serializeArray(List<T> list, Function<T, JsonObject> serializer) {
        JsonArray array = new JsonArray();
        for (T element : list) {
            array.add((JsonElement)serializer.apply(element));
        }
        return array;
    }
}

