/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.config;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.config.Config;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public abstract class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static final Path configPath = Platform.getConfigFolder().resolve("allthetrims.json");

    public static void loadConfig() {
        Config config = ConfigManager.load();
        if (config.debug == null) {
            config.debug = false;
        }
        if (config.trimRegistryMismatchMessage == null) {
            config.trimRegistryMismatchMessage = "\u00a7b[All The Trims] \u00a7cTrim Registry Mismatch. \u00a7rPlease ensure that the client and server have the same mods with the same versions.";
        }
        Config.update(config);
        ConfigManager.save();
        AllTheTrims.LOGGER.info("Config loaded", new Object[0]);
    }

    private static Config load() {
        Config config = Config.getInstance();
        try {
            if (!Files.exists(configPath, new LinkOption[0])) {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                Files.createFile(configPath, new FileAttribute[0]);
                return config;
            }
            try {
                config = (Config)GSON.fromJson((Reader)Files.newBufferedReader(configPath), Config.class);
            }
            catch (JsonSyntaxException e) {
                AllTheTrims.LOGGER.error("Failed to parse config file, using default config", new Object[0]);
                config = new Config();
            }
        }
        catch (IOException e) {
            AllTheTrims.LOGGER.error("Failed to load config", e);
        }
        return config;
    }

    private static void save() {
        try {
            Files.write(configPath, GSON.toJson((Object)Config.getInstance()).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            AllTheTrims.LOGGER.error("Failed to save config", e);
        }
    }

    public static void saveConfig() {
        ConfigManager.save();
        AllTheTrims.LOGGER.info("Saved client config", new Object[0]);
    }
}

