/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.client.implementation.jei;

import com.bawnorton.allthetrims.client.implementation.jei.AllTheTrimsSmithingRecipeCategory;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.plugins.vanilla.crafting.VanillaRecipes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class JeiPluginImpl
implements IModPlugin {
    static final RecipeType<SmithingRecipe> smithingRecipeType = RecipeType.create((String)"allthetrims", (String)"smithing", SmithingRecipe.class);
    static IRecipeCategory<SmithingRecipe> smithingCategory;

    public static boolean isTrimmingRecipe(SmithingRecipe smithingRecipe) {
        return smithingRecipe instanceof SmithingTrimRecipe;
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("allthetrims", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        smithingCategory = new AllTheTrimsSmithingRecipeCategory(guiHelper);
        iRecipeCategoryArray[0] = smithingCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IIngredientManager ingredientManager = registration.getIngredientManager();
        VanillaRecipes vanillaRecipes = new VanillaRecipes(ingredientManager);
        registration.addRecipes(smithingRecipeType, vanillaRecipes.getSmithingRecipes(smithingCategory));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50625_), new RecipeType[]{smithingRecipeType});
    }
}

