/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.client.api;

import com.bawnorton.allthetrims.Compat;
import com.bawnorton.allthetrims.client.util.PaletteHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;

public abstract class DynamicTrimRenderer {
    private static TextureAtlas armorTrimsAtlas;

    public static TextureAtlas getAtlas() {
        return armorTrimsAtlas;
    }

    public static void setAtlas(TextureAtlas atlas) {
        armorTrimsAtlas = atlas;
    }

    public static void renderTrim(ArmorMaterial material, PoseStack matrices, MultiBufferSource vertexConsumers, int light, ArmorTrim trim, HumanoidModel<?> model, boolean leggings) {
        DynamicTrimRenderer.renderTrim(material, matrices, vertexConsumers, light, trim, model, leggings, Compat.getTrimRenderLayer());
    }

    public static void renderTrim(ArmorMaterial material, PoseStack matrices, MultiBufferSource vertexConsumers, int light, ArmorTrim trim, HumanoidModel<?> model, boolean leggings, RenderType layer) {
        DynamicTrimRenderer.renderTrim(material, matrices, vertexConsumers, light, trim, model, leggings, armorTrimsAtlas, layer);
    }

    public static void renderTrim(ArmorMaterial material, PoseStack matrices, MultiBufferSource vertexConsumers, int light, ArmorTrim trim, HumanoidModel<?> model, boolean leggings, TextureAtlas atlas, RenderType layer) {
        TrimMaterial trimMaterial = (TrimMaterial)trim.m_266210_().m_203334_();
        String assetName = trimMaterial.f_265854_();
        List<Color> palette = PaletteHelper.getPalette((Item)trimMaterial.f_265970_().m_203334_());
        ResourceLocation modelId = leggings ? trim.m_267774_(material) : trim.m_267606_(material);
        for (int i = 0; i < 8; ++i) {
            String layerPath = modelId.m_135815_().replace(assetName, i + "_" + assetName);
            TextureAtlasSprite sprite = atlas.m_118316_(modelId.m_247449_(layerPath));
            VertexConsumer vertexConsumer = sprite.m_118381_(vertexConsumers.m_6299_(layer));
            Color colour = palette.get(i);
            model.m_7695_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, (float)colour.getRed() / 255.0f, (float)colour.getGreen() / 255.0f, (float)colour.getBlue() / 255.0f, Compat.getTrimTransparency());
        }
    }
}

