/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.client;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.Compat;
import com.bawnorton.allthetrims.client.implementation.YACLImpl;
import com.bawnorton.allthetrims.client.util.ImageUtil;
import com.bawnorton.allthetrims.client.util.PaletteHelper;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import java.awt.Color;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.level.ItemLike;

public class AllTheTrimsClient {
    public static final ThreadLocal<String> MATERIAL = new ThreadLocal();

    public static void init() {
        AllTheTrims.LOGGER.debug("Initializing AllTheTrims Client", new Object[0]);
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> {
            ClientPacketListener networkHandler = Minecraft.m_91087_().m_91403_();
            if (networkHandler == null) {
                return -1;
            }
            RegistryAccess registryManager = networkHandler.m_105152_();
            Optional optionalTrim = ArmorTrim.m_266285_((RegistryAccess)registryManager, (ItemStack)stack);
            if (optionalTrim.isEmpty()) {
                Item patt1973$temp = stack.m_41720_();
                if (patt1973$temp instanceof DyeableArmorItem) {
                    DyeableArmorItem dyeableArmorItem = (DyeableArmorItem)patt1973$temp;
                    return tintIndex == 0 ? dyeableArmorItem.m_41121_(stack) : -1;
                }
                return -1;
            }
            TrimMaterial trimMaterial = (TrimMaterial)((ArmorTrim)optionalTrim.get()).m_266210_().m_203334_();
            Item trimItem = (Item)trimMaterial.f_265970_().m_203334_();
            String assetName = trimMaterial.f_265854_();
            List<Color> palette = PaletteHelper.getPalette(trimItem);
            Item patt2454$temp = stack.m_41720_();
            if (patt2454$temp instanceof DyeableArmorItem) {
                DyeableArmorItem dyeableArmorItem = (DyeableArmorItem)patt2454$temp;
                if (tintIndex == 0) {
                    return dyeableArmorItem.m_41121_(stack);
                }
                if (tintIndex >= 2 && assetName.equals("dynamic")) {
                    return palette.get(Mth.m_14045_((int)(6 - tintIndex), (int)0, (int)(palette.size() - 1))).getRGB();
                }
                return -1;
            }
            if (!assetName.equals("dynamic")) {
                return -1;
            }
            if (tintIndex < 1) {
                return -1;
            }
            Color color = palette.get(Mth.m_14045_((int)(6 - tintIndex), (int)0, (int)(palette.size() - 1)));
            if (tintIndex == 1) {
                return ImageUtil.changeBrightness(color, 0.5f).getRGB();
            }
            if (tintIndex == 2) {
                return ImageUtil.changeBrightness(color, 0.75f).getRGB();
            }
            if (tintIndex == 3) {
                return ImageUtil.changeBrightness(color, 0.9f).getRGB();
            }
            return color.getRGB();
        }, (ItemLike[])((ItemLike[])BuiltInRegistries.f_257033_.m_123024_().filter(item -> item instanceof Equipable).toArray(Item[]::new)));
    }

    public static Screen getConfigScreen(Screen parent) {
        if (Compat.isYaclLoaded()) {
            return YACLImpl.getScreen(parent);
        }
        return new ConfirmScreen(result -> {
            if (result) {
                Util.m_137581_().m_137648_(URI.create("https://modrinth.com/mod/yacl/versions"));
            }
            Minecraft.m_91087_().m_91152_(parent);
        }, Component.m_130674_((String)"Yet Another Config Lib not installed!"), Component.m_130674_((String)"YACL 3 is required to edit the config in game, would you like to install YACL 3?"), CommonComponents.f_130657_, CommonComponents.f_130658_);
    }
}

