/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.config.IDrawerConfig;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.FaceSlotBlock;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.DetachedDrawerData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModSecurity;
import com.jaquadro.minecraft.storagedrawers.inventory.DrawerInventoryHelper;
import com.jaquadro.minecraft.storagedrawers.item.ItemDetachedDrawer;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemKeyring;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import com.texelsaurus.minecraft.chameleon.inventory.ContentMenuProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockDrawers
extends FaceSlotBlock
implements INetworked,
EntityBlock {
    private static final VoxelShape AABB_NORTH_FULL = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape AABB_SOUTH_FULL = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape AABB_WEST_FULL = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape AABB_EAST_FULL = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape AABB_NORTH_HALF = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_SOUTH_HALF = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape AABB_WEST_HALF = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_EAST_HALF = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape HOPPER_INSIDE = Block.m_49796_((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape AABB_NORTH_HOPPER = Shapes.m_83113_((VoxelShape)AABB_NORTH_FULL, (VoxelShape)HOPPER_INSIDE, (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape AABB_SOUTH_HOPPER = Shapes.m_83113_((VoxelShape)AABB_SOUTH_FULL, (VoxelShape)HOPPER_INSIDE, (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape AABB_WEST_HOPPER = Shapes.m_83113_((VoxelShape)AABB_WEST_FULL, (VoxelShape)HOPPER_INSIDE, (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape AABB_EAST_HOPPER = Shapes.m_83113_((VoxelShape)AABB_EAST_FULL, (VoxelShape)HOPPER_INSIDE, (BooleanOp)BooleanOp.f_82685_);
    private final int drawerCount;
    private final boolean halfDepth;
    private final Supplier<IDrawerConfig> drawerConfig;
    private int storageUnits;
    public final AABB[] slotGeometry;
    public final AABB[] countGeometry;
    public final AABB[] labelGeometry;
    public final AABB[] indGeometry;
    public final AABB[] indBaseGeometry;
    private long ignoreEventTime;

    public BlockDrawers(int drawerCount, boolean halfDepth, Supplier<IDrawerConfig> drawerConfig, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
        this.drawerCount = drawerCount;
        this.halfDepth = halfDepth;
        this.drawerConfig = drawerConfig;
        this.storageUnits = 0;
        this.slotGeometry = new AABB[drawerCount];
        this.countGeometry = new AABB[drawerCount];
        this.labelGeometry = new AABB[drawerCount];
        this.indGeometry = new AABB[drawerCount];
        this.indBaseGeometry = new AABB[drawerCount];
        for (int i = 0; i < drawerCount; ++i) {
            this.slotGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.countGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.labelGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.indGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.indBaseGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Deprecated
    public BlockDrawers(int drawerCount, boolean halfDepth, int storageUnits, BlockBehaviour.Properties properties) {
        this(drawerCount, halfDepth, null, properties);
        this.storageUnits = storageUnits;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public boolean retrimBlock(Level world, BlockPos pos, ItemStack prototype) {
        return false;
    }

    public BlockType retrimType() {
        return BlockType.Drawers;
    }

    public boolean repartitionBlock(Level world, BlockPos pos, ItemStack prototype) {
        return false;
    }

    public int getDrawerCount() {
        return this.drawerCount;
    }

    public boolean isHalfDepth() {
        return this.halfDepth;
    }

    public int getStorageUnits() {
        return this.drawerConfig != null ? this.drawerConfig.get().getUnitsPerSlot() : this.storageUnits;
    }

    public String getNameTypeKey() {
        String type = this.halfDepth ? "half" : "full";
        return "block.storagedrawers.type." + type + "_drawers_" + this.getDrawerCount();
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockEntityDrawers blockEntity = com.texelsaurus.minecraft.chameleon.util.WorldUtils.getBlockEntity(worldIn, pos, BlockEntityDrawers.class);
        if (blockEntity != null && blockEntity.getDrawerAttributes().isHopper()) {
            return switch (direction) {
                case Direction.EAST -> AABB_EAST_HOPPER;
                case Direction.WEST -> AABB_WEST_HOPPER;
                case Direction.SOUTH -> AABB_SOUTH_HOPPER;
                default -> AABB_NORTH_HOPPER;
            };
        }
        switch (direction) {
            case EAST: {
                return this.halfDepth ? AABB_EAST_HALF : AABB_EAST_FULL;
            }
            case WEST: {
                return this.halfDepth ? AABB_WEST_HALF : AABB_WEST_FULL;
            }
            case SOUTH: {
                return this.halfDepth ? AABB_SOUTH_HALF : AABB_SOUTH_FULL;
            }
        }
        return this.halfDepth ? AABB_NORTH_HALF : AABB_NORTH_FULL;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        IDrawerAttributes _attrs;
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityDrawers.class);
        if (blockEntity == null) {
            return;
        }
        CompoundTag tag = stack.m_41737_("tile");
        if (tag != null) {
            blockEntity.readPortable(tag);
        }
        if (stack.m_41788_()) {
            blockEntity.customName().setName(stack.m_41786_());
        }
        ItemKey key = null;
        if (entity != null) {
            Item item = entity.m_21206_().m_41720_();
            if (item instanceof ItemKey) {
                ItemKey itemKey;
                key = itemKey = (ItemKey)item;
            } else {
                item = entity.m_21206_().m_41720_();
                if (item instanceof ItemKeyring) {
                    ItemKeyring itemKeyring = (ItemKeyring)item;
                    key = itemKeyring.getKey().m_41720_();
                }
            }
        }
        boolean keyEnabled = true;
        if (key instanceof ItemKey) {
            ItemKey itemKey = key;
            keyEnabled = itemKey.isEnabled();
        }
        if ((_attrs = blockEntity.getCapability(Capabilities.DRAWER_ATTRIBUTES)) instanceof IDrawerAttributesModifiable) {
            IDrawerAttributesModifiable attrs = (IDrawerAttributesModifiable)_attrs;
            if (key != null && keyEnabled) {
                if (key == ModItems.DRAWER_KEY.get()) {
                    attrs.setItemLocked(LockAttribute.LOCK_EMPTY, true);
                    attrs.setItemLocked(LockAttribute.LOCK_POPULATED, true);
                } else if (key == ModItems.QUANTIFY_KEY.get()) {
                    attrs.setIsShowingQuantity(true);
                } else if (key == ModItems.SHROUD_KEY.get()) {
                    attrs.setIsConcealed(true);
                } else if (key == ModItems.SUSPEND_KEY.get()) {
                    attrs.setIsSuspended(true);
                }
            }
            if (((Boolean)ModCommonConfig.INSTANCE.TOOLS.quantifyKey.showDefault.get()).booleanValue()) {
                attrs.setIsShowingQuantity(true);
            }
        }
    }

    @Deprecated
    protected int getDrawerSlot(Direction correctSide, @NotNull Vec3 normalizedHit) {
        return this.getFaceSlot(correctSide, normalizedHit);
    }

    @Deprecated
    protected boolean hitAny(Direction side, Vec3 normalizedHit) {
        return this.hitWithinArea(side, normalizedHit, 0.0625f, 0.9375f);
    }

    @Deprecated
    protected boolean hitTop(@NotNull Vec3 normalizedHit) {
        return this.hitWithinY(normalizedHit, 0.5f, 1.0f);
    }

    @Deprecated
    protected boolean hitLeft(Direction side, @NotNull Vec3 normalizedHit) {
        return this.hitWithinX(side, normalizedHit, 0.0f, 0.5f);
    }

    @Override
    public Optional<InteractionResult> useSlotInvertible(FaceSlotBlock.InteractContext context) {
        ItemStack item = context.player.m_21120_(InteractionHand.MAIN_HAND);
        if (item.m_41619_() && !context.level.f_46443_ && context.player.m_6144_()) {
            this.openUI(context);
            return Optional.of(InteractionResult.SUCCESS);
        }
        return Optional.empty();
    }

    @Override
    public Optional<InteractionResult> useSlot(FaceSlotBlock.InteractContext context) {
        BlockEntityDrawers blockEntity;
        ItemStack item = context.player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack keyItem = null;
        Item item2 = item.m_41720_();
        if (item2 instanceof ItemKeyring) {
            ItemKeyring keyring = (ItemKeyring)item2;
            keyItem = keyring.getKey();
        }
        if (!SecurityManager.hasAccess(context.player, blockEntity = context.getCheckedEntity(BlockEntityDrawers.class))) {
            if (item.m_41720_() instanceof ItemPersonalKey || keyItem != null && keyItem.m_41720_() instanceof ItemPersonalKey) {
                ItemPersonalKey pk;
                if (keyItem != null) {
                    item = keyItem;
                }
                if (Objects.equals((pk = (ItemPersonalKey)item.m_41720_()).getSecurityProviderKey(), "unlock")) {
                    blockEntity.setOwner(null);
                    blockEntity.setSecurityProvider(null);
                }
            }
            return Optional.of(InteractionResult.SUCCESS);
        }
        if (context.level.m_5776_()) {
            return Optional.of(InteractionResult.SUCCESS);
        }
        if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.enable.get()).booleanValue() && context.slot >= 0) {
            if (item.m_41720_() == ModItems.DRAWER_PULLER.get() || keyItem != null && keyItem.m_41720_() == ModItems.DRAWER_PULLER.get()) {
                this.interactPullDrawer(context);
                return Optional.of(InteractionResult.SUCCESS);
            }
            if (item.m_41720_() instanceof ItemDetachedDrawer) {
                this.interactReturnDrawer(context, item);
                return Optional.of(InteractionResult.SUCCESS);
            }
        }
        if (Block.m_49814_((Item)item.m_41720_()) instanceof BlockTrim && context.slot >= 0 && context.player.m_6144_()) {
            if (!this.retrimBlock(context.level, context.pos, item)) {
                return Optional.of(InteractionResult.PASS);
            }
            if (!context.player.m_7500_()) {
                item.m_41774_(1);
                if (item.m_41613_() <= 0) {
                    context.player.m_150109_().m_6836_(context.player.m_150109_().f_35977_, ItemStack.f_41583_);
                }
                context.level.m_5594_(null, context.pos, SoundEvents.f_12635_, SoundSource.PLAYERS, 0.2f, ((context.level.f_46441_.m_188501_() - context.level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            }
            return Optional.of(InteractionResult.SUCCESS);
        }
        if (Block.m_49814_((Item)item.m_41720_()) instanceof BlockDrawers && context.slot >= 0 && context.player.m_6144_()) {
            if (!this.repartitionBlock(context.level, context.pos, item)) {
                return Optional.of(InteractionResult.PASS);
            }
            if (!context.player.m_7500_()) {
                item.m_41774_(1);
                if (item.m_41613_() <= 0) {
                    context.player.m_150109_().m_6836_(context.player.m_150109_().f_35977_, ItemStack.f_41583_);
                }
                context.level.m_5594_(null, context.pos, SoundEvents.f_12635_, SoundSource.PLAYERS, 0.2f, ((context.level.f_46441_.m_188501_() - context.level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            }
            return Optional.of(InteractionResult.SUCCESS);
        }
        if (item.m_41720_() instanceof ItemPersonalKey || keyItem != null && keyItem.m_41720_() instanceof ItemPersonalKey) {
            if (!((Boolean)ModCommonConfig.INSTANCE.TOOLS.personalKey.enable.get()).booleanValue()) {
                return Optional.of(InteractionResult.PASS);
            }
            if (keyItem != null) {
                item = keyItem;
            }
            String securityKey = ((ItemPersonalKey)item.m_41720_()).getSecurityProviderKey();
            ISecurityProvider provider = ModSecurity.registry.getProvider(securityKey);
            if (Objects.equals(securityKey, "unlock")) {
                blockEntity.setOwner(null);
                blockEntity.setSecurityProvider(null);
            } else if (blockEntity.getOwner() == null) {
                blockEntity.setOwner(context.player.m_20148_());
                blockEntity.setSecurityProvider(provider);
            } else if (SecurityManager.hasOwnership(context.player.m_36316_(), blockEntity)) {
                blockEntity.setOwner(null);
                blockEntity.setSecurityProvider(null);
            } else {
                return Optional.of(InteractionResult.PASS);
            }
            return Optional.of(InteractionResult.SUCCESS);
        }
        if (item.m_41720_() instanceof ItemKey || item.m_41720_() instanceof ItemKeyring) {
            return Optional.of(InteractionResult.PASS);
        }
        BlockEntityDrawers entity = context.getCheckedEntity(BlockEntityDrawers.class);
        if (item.m_41720_() instanceof ItemUpgrade && !context.player.m_6144_()) {
            if (entity.getGroup().hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
                if (!context.level.f_46443_) {
                    context.player.m_5661_((Component)Component.m_237115_((String)"message.storagedrawers.missing_slots_upgrade"), true);
                }
                return Optional.of(InteractionResult.PASS);
            }
            Item item3 = item.m_41720_();
            if (item3 instanceof ItemUpgradeRemote) {
                ItemUpgradeRemote remote = (ItemUpgradeRemote)item3;
                if (entity.upgrades().hasRemoteUpgrade() && remote.isBound()) {
                    entity.upgrades().updateRemoteUpgradeBinding(item);
                    BlockPos pos = ItemUpgradeRemote.getBoundPosition(item);
                    if (pos != null) {
                        context.player.m_5661_((Component)Component.m_237110_((String)"message.storagedrawers.updated_remote_binding", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
                    }
                    return Optional.of(InteractionResult.SUCCESS);
                }
            }
            if (!entity.upgrades().canAddUpgrade(item)) {
                if (!context.level.f_46443_) {
                    context.player.m_5661_((Component)Component.m_237115_((String)"message.storagedrawers.cannot_add_upgrade"), true);
                }
                return Optional.of(InteractionResult.PASS);
            }
            if (!entity.upgrades().addUpgrade(item)) {
                if (!context.level.f_46443_) {
                    context.player.m_5661_((Component)Component.m_237115_((String)"message.storagedrawers.max_upgrades"), true);
                }
                return Optional.of(InteractionResult.PASS);
            }
            context.level.m_7260_(context.pos, context.state, context.state, 3);
            if (!context.player.m_7500_()) {
                item.m_41774_(1);
                if (item.m_41613_() <= 0) {
                    context.player.m_150109_().m_6836_(context.player.m_150109_().f_35977_, ItemStack.f_41583_);
                }
            }
            return Optional.of(InteractionResult.SUCCESS);
        }
        return Optional.empty();
    }

    private void openUI(FaceSlotBlock.InteractContext context) {
        if (!((Boolean)ModCommonConfig.INSTANCE.GENERAL.enableUI.get()).booleanValue()) {
            return;
        }
        MenuProvider provider = context.state.m_60750_(context.level, context.pos);
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("Open BlockDrawers UI " + context.pos);
        }
        if (provider instanceof ContentMenuProvider) {
            ContentMenuProvider menu = (ContentMenuProvider)provider;
            menu.openMenu((ServerPlayer)context.player);
        }
    }

    @Nullable
    public MenuProvider m_7246_(BlockState blockState, Level level, BlockPos blockPos) {
        BlockEntityDrawers blockEntityDrawers = com.texelsaurus.minecraft.chameleon.util.WorldUtils.getBlockEntity((BlockGetter)level, blockPos, BlockEntityDrawers.class);
        if (blockEntityDrawers == null) {
            return null;
        }
        return new BlockEntityDrawers.ContentProvider(blockEntityDrawers);
    }

    @Override
    public InteractionResult putSlot(FaceSlotBlock.InteractContext context, boolean altAction) {
        ItemStack item = context.player.m_21120_(InteractionHand.MAIN_HAND);
        BlockEntityDrawers blockEntityDrawers = context.getCheckedEntity(BlockEntityDrawers.class);
        if (blockEntityDrawers == null) {
            return InteractionResult.FAIL;
        }
        if (!SecurityManager.hasAccess(context.player, blockEntityDrawers)) {
            return InteractionResult.PASS;
        }
        if (context.level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        blockEntityDrawers.interactPutItemsIntoSlot(context.slot, context.player);
        if (item.m_41619_()) {
            context.player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult takeSlot(FaceSlotBlock.InteractContext context, boolean altAction) {
        BlockEntityDrawers blockEntityDrawers = context.getCheckedEntity(BlockEntityDrawers.class, BlockDrawers.class);
        if (blockEntityDrawers == null) {
            return InteractionResult.FAIL;
        }
        if (!SecurityManager.hasAccess(context.player, blockEntityDrawers)) {
            return InteractionResult.PASS;
        }
        if (context.level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        IDrawer drawer = blockEntityDrawers.getGroup().getDrawer(context.slot);
        ItemStack item = altAction ? blockEntityDrawers.takeItemsFromSlot(context.slot, drawer.getStoredItemStackSize(), context.player) : blockEntityDrawers.takeItemsFromSlot(context.slot, 1, context.player);
        if (!item.m_41619_()) {
            if (!context.player.m_150109_().m_36054_(item)) {
                this.dropItemStack(context.level, context.pos.m_121945_(context.hit.m_82434_()), context.player, item);
                context.level.m_7260_(context.pos, context.state, context.state, 3);
            } else {
                context.level.m_5594_(null, context.pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((context.level.f_46441_.m_188501_() - context.level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean interactPullDrawer(FaceSlotBlock.InteractContext context) {
        BlockEntityDrawers entity = context.getCheckedEntity(BlockEntityDrawers.class, BlockDrawers.class);
        if (entity == null) {
            return false;
        }
        IDrawer drawer = entity.getGroup().getDrawer(context.slot);
        if (!drawer.isEnabled() || drawer.isMissing() || !drawer.canDetach()) {
            return false;
        }
        ItemStack detachedDrawer = this.pullDrawer(entity, context.slot);
        if (!detachedDrawer.m_41619_()) {
            drawer.setDetached(true);
        }
        this.giveOrDropItemStack(context, detachedDrawer);
        return true;
    }

    public boolean interactReturnDrawer(FaceSlotBlock.InteractContext context, ItemStack detachedDrawer) {
        if (detachedDrawer.m_41619_()) {
            return false;
        }
        BlockEntityDrawers entity = context.getCheckedEntity(BlockEntityDrawers.class, BlockDrawers.class);
        if (entity == null) {
            return false;
        }
        if (!entity.interactReplaceDrawer(context.slot, detachedDrawer, context.player)) {
            return false;
        }
        if (detachedDrawer.m_41720_() == ModItems.DETACHED_DRAWER.get()) {
            detachedDrawer.m_41764_(detachedDrawer.m_41613_() - 1);
            if (detachedDrawer.m_41613_() > 0) {
                return true;
            }
        }
        context.player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        return true;
    }

    private ItemStack pullDrawer(BlockEntityDrawers group, int slot) {
        int cap = group.getEffectiveDrawerCapacity() * group.upgrades().getStorageMultiplier();
        Item baseItem = (Item)ModItems.DETACHED_DRAWER_FULL.get();
        IDrawer drawer = group.getDrawer(slot);
        DetachedDrawerData data = new DetachedDrawerData(drawer, cap);
        if (drawer.isEmpty()) {
            baseItem = (Item)ModItems.DETACHED_DRAWER.get();
        }
        if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.heavyDrawers.get()).booleanValue() && !group.upgrades().hasPortabilityUpgrade()) {
            data.setIsHeavy(true);
        }
        ItemStack stack = new ItemStack((ItemLike)baseItem, 1);
        CompoundTag tag = data.serializeNBT();
        if (!drawer.isEmpty()) {
            tag.m_128405_("drawer_content_rand", (int)Math.floor(Math.random() * 1000000.0));
        }
        stack.m_41751_(tag);
        return stack;
    }

    private void giveOrDropItemStack(FaceSlotBlock.InteractContext context, @NotNull ItemStack item) {
        if (!item.m_41619_()) {
            if (!context.player.m_150109_().m_36054_(item)) {
                this.dropItemStack(context.level, context.pos.m_121945_(context.hit.m_82434_()), context.player, item);
                context.level.m_7260_(context.pos, context.state, context.state, 3);
            } else {
                context.level.m_5594_(null, context.pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((context.level.f_46441_.m_188501_() - context.level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    private void dropItemStack(@NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull ItemStack stack) {
        ItemEntity entity = new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.3f), (double)((float)pos.m_123343_() + 0.5f), stack);
        Vec3 motion = entity.m_20184_();
        entity.m_5997_(-motion.f_82479_, -motion.f_82480_, -motion.f_82481_);
        world.m_7967_((Entity)entity);
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getMainDrop(state, (BlockEntityDrawers)builder.m_287159_(LootContextParams.f_81462_)));
        return items;
    }

    protected ItemStack getMainDrop(BlockState state, BlockEntityDrawers tile) {
        ItemStack drop = new ItemStack((ItemLike)this);
        if (tile == null) {
            return drop;
        }
        if (ModCommonConfig.INSTANCE.DRAWERS.storage.dropMode.get() == ModCommonConfig.DropMode.KEEP) {
            int i;
            CompoundTag data = drop.m_41783_();
            if (data == null) {
                data = new CompoundTag();
            }
            boolean hasUpgradeContents = false;
            boolean hasItemContents = false;
            for (i = 0; i < tile.getGroup().getDrawerCount(); ++i) {
                IDrawer drawer = tile.getGroup().getDrawer(i);
                if (drawer.isEmpty() && !drawer.isMissing()) continue;
                hasItemContents = true;
            }
            for (i = 0; i < tile.upgrades().getSlotCount(); ++i) {
                if (tile.upgrades().getUpgrade(i).m_41619_()) continue;
                hasUpgradeContents = true;
            }
            if (hasItemContents || hasUpgradeContents) {
                CompoundTag tiledata = tile.m_187482_();
                data.m_128365_("tile", (Tag)tiledata);
                if (hasItemContents) {
                    data.m_128405_("drawer_content_rand", (int)Math.floor(Math.random() * 1000000.0));
                }
                drop.m_41751_(data);
            }
        }
        if (tile.customName().hasCustomName()) {
            drop.m_41714_(tile.customName().getDisplayName());
        }
        return drop;
    }

    public boolean m_7899_(@NotNull BlockState state) {
        return (Boolean)ModCommonConfig.INSTANCE.UPGRADES.redstoneUpgrade.analogOutput.get() == false;
    }

    public int m_6378_(@NotNull BlockState state, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        if (!this.m_7899_(state)) {
            return 0;
        }
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity(blockAccess, pos, BlockEntityDrawers.class);
        if (blockEntity == null || !blockEntity.isRedstone()) {
            return 0;
        }
        return blockEntity.getRedstoneLevel();
    }

    public int m_6376_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull Direction side) {
        return side == Direction.UP ? this.m_6378_(state, worldIn, pos, side) : 0;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean flag) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntityDrawers entity;
            level.m_46717_(pos, (Block)this);
            if (ModCommonConfig.INSTANCE.DRAWERS.storage.dropMode.get() == ModCommonConfig.DropMode.DROP && (entity = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityDrawers.class)) != null) {
                DrawerInventoryHelper.dropUpgradeItems(level, pos, entity.upgrades());
                if (!entity.getDrawerAttributes().isUnlimitedVending()) {
                    DrawerInventoryHelper.dropInventoryItems(level, pos, entity.getGroup());
                }
            }
            super.m_6810_(state, level, pos, newState, flag);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level blockAccess, BlockPos pos) {
        if (!this.m_7278_(state)) {
            return 0;
        }
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((BlockGetter)blockAccess, pos, BlockEntityDrawers.class);
        if (blockEntity == null || !blockEntity.isRedstone()) {
            return 0;
        }
        return blockEntity.getRedstoneLevel();
    }

    public boolean m_7923_(@NotNull BlockState state) {
        return true;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        IDrawerAttributes attr;
        BlockEntityDrawers blockEntity = com.texelsaurus.minecraft.chameleon.util.WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityDrawers.class);
        if (blockEntity != null && (attr = blockEntity.getDrawerAttributes()).isHopper() && !attr.isSuspended()) {
            blockEntity.entityInside(level, pos, state, entity);
        }
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        BlockEntityDrawers blockEntity = com.texelsaurus.minecraft.chameleon.util.WorldUtils.getBlockEntity(blockGetter, pos, BlockEntityDrawers.class);
        if (blockEntity != null && blockEntity.getDrawerAttributes().isHopper()) {
            return HOPPER_INSIDE;
        }
        return super.m_6079_(state, blockGetter, pos);
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("BlockDrawers [{}] tick", (Object)pos);
        }
        if (world.f_46443_) {
            return;
        }
        BlockEntityDrawers blockEntity = com.texelsaurus.minecraft.chameleon.util.WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityDrawers.class);
        if (blockEntity == null) {
            return;
        }
        IDrawerAttributes attribs = blockEntity.getDrawerAttributes();
        if (attribs.isHopper() || attribs.isMagnet()) {
            UpgradeData upgrades = blockEntity.upgrades();
            int tickTime = 20;
            if (attribs.isMagnet()) {
                int idleRate = upgrades.getMagnetIdleRate();
                tickTime = blockEntity.pushItemsTick((Level)world, pos, state) ? upgrades.getMagnetActiveRate() : rand.m_216339_(idleRate, idleRate + 5);
            }
            world.m_186460_(pos, state.m_60734_(), tickTime);
        }
        blockEntity.validateBoundController();
    }
}

