/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.event.forge;

import dev.architectury.event.Event;
import dev.architectury.event.EventActor;
import dev.architectury.event.EventResult;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.ApiStatus;

public class EventFactoryImpl {
    public static <T> Event<Consumer<T>> attachToForge(Event<Consumer<T>> event) {
        event.register(eventObj -> {
            if (!(eventObj instanceof net.minecraftforge.eventbus.api.Event)) {
                throw new ClassCastException(eventObj.getClass() + " is not an instance of forge Event!");
            }
            MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)eventObj);
        });
        return event;
    }

    @ApiStatus.Internal
    public static <T> Event<EventActor<T>> attachToForgeEventActor(Event<EventActor<T>> event) {
        event.register(eventObj -> {
            if (!(eventObj instanceof net.minecraftforge.eventbus.api.Event)) {
                throw new ClassCastException(eventObj.getClass() + " is not an instance of forge Event!");
            }
            if (!((net.minecraftforge.eventbus.api.Event)eventObj).isCancelable()) {
                throw new ClassCastException(eventObj.getClass() + " is not cancellable Event!");
            }
            MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)eventObj);
            return EventResult.pass();
        });
        return event;
    }

    @ApiStatus.Internal
    public static <T> Event<EventActor<T>> attachToForgeEventActorCancellable(Event<EventActor<T>> event) {
        event.register(eventObj -> {
            if (!(eventObj instanceof net.minecraftforge.eventbus.api.Event)) {
                throw new ClassCastException(eventObj.getClass() + " is not an instance of forge Event!");
            }
            if (!((net.minecraftforge.eventbus.api.Event)eventObj).isCancelable()) {
                throw new ClassCastException(eventObj.getClass() + " is not cancellable Event!");
            }
            if (MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)eventObj)) {
                return EventResult.interrupt(false);
            }
            return EventResult.pass();
        });
        return event;
    }
}

