/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.layout.components.ComponentWithBounds;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.input.RelativeContainerEventHandler;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class Panel
implements ComponentWithBounds,
RelativeContainerEventHandler,
NarratableEntry,
Renderable {
    protected LayoutComponent<?, ?> child;
    List<? extends GuiEventListener> listeners = List.of();
    public final Rectangle bounds;
    boolean dragging = false;
    GuiEventListener focused;

    public Panel(int width, int height) {
        this(0, 0, width, height);
    }

    public Panel(int left, int top, int width, int height) {
        this(new Rectangle(left, top, width, height));
    }

    public Panel(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void setChild(LayoutComponent<?, ?> c) {
        this.child = c;
        this.listeners = List.of(c);
    }

    public void calculateLayout() {
        if (this.child != null) {
            this.child.updateContainerWidth(this.bounds.width);
            this.child.updateContainerHeight(this.bounds.height);
            this.child.setRelativeBounds(0, 0);
            this.child.updateScreenBounds(this.bounds.left, this.bounds.top);
        }
    }

    @Override
    public Rectangle getRelativeBounds() {
        return this.bounds;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.listeners;
    }

    @Override
    public Rectangle getInputBounds() {
        return this.bounds;
    }

    public boolean m_7282_() {
        return this.dragging;
    }

    public void m_7897_(boolean bl) {
        this.dragging = bl;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.focused;
    }

    public void m_7522_(@Nullable GuiEventListener guiEventListener) {
        this.focused = guiEventListener;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTicks) {
        if (this.child != null) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)this.bounds.left, (float)this.bounds.top, 0.0f);
            this.child.render(guiGraphics, mouseX - this.bounds.left, mouseY - this.bounds.top, deltaTicks, this.bounds, this.bounds);
            guiGraphics.m_280168_().m_85849_();
        }
    }
}

