/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Quaternion;
import de.ambertation.wunderlib.math.sdf.shapes.Box;
import de.ambertation.wunderlib.math.sdf.shapes.Ellipsoid;
import de.ambertation.wunderlib.math.sdf.shapes.Sphere;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public class Bounds {
    public static final Codec<Bounds> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Float3.CODEC.fieldOf("min").forGetter(o -> o.min), (App)Float3.CODEC.fieldOf("max").forGetter(o -> o.max)).apply((Applicative)instance, Bounds::of));
    public static final Bounds EMPTY = new Bounds(-2.147483648E9, -2.147483648E9, -2.147483648E9, -2.147483648E9, -2.147483648E9, -2.147483648E9);
    public final Float3 min;
    public final Float3 max;

    private Bounds(double lx, double ly, double lz, double hx, double hy, double hz) {
        this.min = Float3.of(Math.min(lx, hx), Math.min(ly, hy), Math.min(lz, hz));
        this.max = Float3.of(Math.max(lx, hx), Math.max(ly, hy), Math.max(lz, hz));
    }

    public boolean empty() {
        return this.min.x == -2.147483648E9 && this.min.y == -2.147483648E9 && this.min.z == -2.147483648E9 && this.max.x == -2.147483648E9 && this.max.y == -2.147483648E9 && this.max.z == -2.147483648E9;
    }

    public static Bounds of(BoundingBox box) {
        return new Bounds(box.m_162395_(), box.m_162396_(), box.m_162398_(), box.m_162399_(), box.m_162400_(), box.m_162401_());
    }

    public static Bounds of(BlockPos pos) {
        return new Bounds(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static Bounds of(BlockPos pos, Vec3i size) {
        return new Bounds(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_() + size.m_123341_(), pos.m_123342_() + size.m_123342_(), pos.m_123343_() + size.m_123343_());
    }

    public static Bounds of(Float3 pos) {
        return new Bounds(pos.x, pos.y, pos.z, pos.x, pos.y, pos.z);
    }

    public static Bounds of(Float3 min, Float3 max) {
        return new Bounds(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public static Bounds of(double lx, double ly, double lz, double hx, double hy, double hz) {
        return new Bounds(lx, ly, lz, hx, hy, hz);
    }

    public static Bounds ofSphere(Float3 center, double radius) {
        return Bounds.ofBox(center, Float3.of(radius));
    }

    public static Bounds ofCylinder(Float3 center, double height, double radius) {
        Float3 size = Float3.of(radius, height, radius);
        return Bounds.of(center.sub(size), center.add(size));
    }

    public static Bounds ofBox(Float3 center, Float3 size) {
        Float3 min = center.sub(size.div(2.0));
        return Bounds.of(min, min.add(size));
    }

    public Float3 getSize() {
        return Float3.of(this.max.x - this.min.x, this.max.y - this.min.y, this.max.z - this.min.z);
    }

    public Float3 getHalfSize() {
        return Float3.of((this.max.x - this.min.x) / 2.0, (this.max.y - this.min.y) / 2.0, (this.max.z - this.min.z) / 2.0);
    }

    public double volume() {
        Float3 sz = this.getSize();
        return sz.x * sz.y * sz.z;
    }

    public boolean isInside(Float3 p) {
        return p.x >= this.min.x && p.x <= this.max.x && p.z >= this.min.z && p.z <= this.max.z && p.y >= this.min.y && p.y <= this.max.y;
    }

    public boolean isInside(BlockPos p) {
        return (double)p.m_123341_() >= this.min.x && (double)p.m_123341_() <= this.max.x && (double)p.m_123343_() >= this.min.z && (double)p.m_123343_() <= this.max.z && (double)p.m_123342_() >= this.min.y && (double)p.m_123342_() <= this.max.y;
    }

    public Bounds encapsulate(Bounds bounds) {
        if (this.empty()) {
            return bounds;
        }
        if (bounds.empty()) {
            return this;
        }
        return new Bounds(Math.min(this.min.x, bounds.min.x), Math.min(this.min.y, bounds.min.y), Math.min(this.min.z, bounds.min.z), Math.max(this.max.x, bounds.max.x), Math.max(this.max.y, bounds.max.y), Math.max(this.max.z, bounds.max.z));
    }

    public Bounds encapsulate(BlockPos blockPos) {
        if (this.empty()) {
            return Bounds.of(blockPos);
        }
        return new Bounds(Math.min(this.min.x, (double)blockPos.m_123341_()), Math.min(this.min.y, (double)blockPos.m_123342_()), Math.min(this.min.z, (double)blockPos.m_123343_()), Math.max(this.max.x, (double)blockPos.m_123341_()), Math.max(this.max.y, (double)blockPos.m_123342_()), Math.max(this.max.z, (double)blockPos.m_123343_()));
    }

    public Bounds encapsulate(Float3 p) {
        if (this.empty()) {
            return Bounds.of(p);
        }
        return new Bounds(Math.min(this.min.x, p.x), Math.min(this.min.y, p.y), Math.min(this.min.z, p.z), Math.max(this.max.x, p.x), Math.max(this.max.y, p.y), Math.max(this.max.z, p.z));
    }

    public Float3 get(Interpolate p) {
        return p.lerp(this.min, this.max);
    }

    public Float3 getBlockAligned(Interpolate p) {
        return p.blockAlignedLerp(this.min, this.max);
    }

    public Bounds blockAligned() {
        Float3 m = this.min.add(0.5).blockAligned();
        return Bounds.of(m, m.add(this.getSize().sub(1.0)).blockAligned());
    }

    public Float3 getCenter() {
        return this.get(Interpolate.CENTER);
    }

    public Bounds moveToCenter(Float3 newCenter) {
        newCenter = newCenter.sub(this.getCenter());
        return Bounds.of(this.min.add(newCenter), this.max.add(newCenter));
    }

    public Bounds move(Float3 offset) {
        if (offset == null) {
            return this;
        }
        return Bounds.of(this.min.add(offset), this.max.add(offset));
    }

    public Interpolate isCorner(Float3 p) {
        for (Interpolate i : Interpolate.CORNERS) {
            if (!this.getBlockAligned(i).equals(p)) continue;
            return i;
        }
        return null;
    }

    public Interpolate isCornerOrCenter(Float3 p) {
        for (Interpolate i : Interpolate.CORNERS_AND_CENTER) {
            if (!this.getBlockAligned(i).equals(p)) continue;
            return i;
        }
        return null;
    }

    public double minExtension() {
        return Math.min(Math.min(this.max.x - this.min.x, this.max.y - this.min.y), this.max.z - this.min.z);
    }

    public double maxExtension() {
        return Math.max(Math.max(this.max.x - this.min.x, this.max.y - this.min.y), this.max.z - this.min.z);
    }

    public Sphere innerSphere() {
        return new Sphere(this.getCenter(), this.minExtension() / 2.0 + 0.5);
    }

    public Sphere outerSphere() {
        return new Sphere(this.getCenter(), this.getSize().length() / 2.0);
    }

    public Box innerBox() {
        return new Box(this.getCenter(), this.getSize().div(2.0));
    }

    public Ellipsoid innerEllipsoid() {
        return new Ellipsoid(this.getCenter(), this.getSize().div(2.0));
    }

    public BoundingBox toBoundingBox() {
        return new BoundingBox((int)this.min.x, (int)this.min.y, (int)this.min.z, (int)this.max.x, (int)this.max.y, (int)this.max.z);
    }

    public AABB toAABB() {
        return new AABB(this.min.x, this.min.y, this.min.z, this.max.x + 1.0, this.max.y + 1.0, this.max.z + 1.0);
    }

    public Bounds shrink(BlockPos pos) {
        if (!this.isInside(pos)) {
            return null;
        }
        double minX = this.min.x;
        double maxX = this.max.x;
        double minY = this.min.y;
        double maxY = this.max.z;
        double minZ = this.min.z;
        double maxZ = this.max.z;
        if (Math.abs((double)pos.m_123341_() - minX) < Math.abs(maxX - (double)pos.m_123341_())) {
            minX = pos.m_123341_();
        } else {
            maxX = pos.m_123341_();
        }
        if (Math.abs((double)pos.m_123342_() - minY) < Math.abs(maxY - (double)pos.m_123342_())) {
            minY = pos.m_123342_();
        } else {
            maxY = pos.m_123342_();
        }
        if (Math.abs((double)pos.m_123343_() - minZ) < Math.abs(maxZ - (double)pos.m_123343_())) {
            minZ = pos.m_123343_();
        } else {
            maxZ = pos.m_123343_();
        }
        return new Bounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Bounds rotate(Quaternion rot) {
        Bounds local = this.moveToCenter(Float3.ZERO);
        Bounds fresh = Bounds.of(Float3.ZERO, Float3.ZERO);
        for (Interpolate i : Interpolate.CORNERS) {
            fresh = fresh.encapsulate(local.get(i).rotate(rot));
        }
        return fresh.moveToCenter(this.getCenter());
    }

    public String toString() {
        return this.empty() ? "EMPTY" : this.min + " -> " + this.max + " (c: " + this.getCenter() + ", s:" + this.getSize() + ")";
    }

    public void serializeToNetwork(FriendlyByteBuf buf) {
        this.min.serializeToNetwork(buf);
        this.max.serializeToNetwork(buf);
    }

    public static Bounds deserializeFromNetwork(FriendlyByteBuf buf) {
        Float3 min = Float3.deserializeFromNetwork(buf);
        Float3 max = Float3.deserializeFromNetwork(buf);
        return Bounds.of(min, max);
    }

    public static class Interpolate {
        public static final Interpolate MIN_MIN_MIN = new Interpolate(0, 0.0f, 0.0f, 0.0f);
        public static final Interpolate MIN_MIN_MAX = new Interpolate(1, 0.0f, 0.0f, 1.0f);
        public static final Interpolate MIN_MAX_MIN = new Interpolate(2, 0.0f, 1.0f, 0.0f);
        public static final Interpolate MIN_MAX_MAX = new Interpolate(3, 0.0f, 1.0f, 1.0f);
        public static final Interpolate MAX_MAX_MAX = new Interpolate(4, 1.0f, 1.0f, 1.0f);
        public static final Interpolate MAX_MAX_MIN = new Interpolate(5, 1.0f, 1.0f, 0.0f);
        public static final Interpolate MAX_MIN_MAX = new Interpolate(6, 1.0f, 0.0f, 1.0f);
        public static final Interpolate MAX_MIN_MIN = new Interpolate(7, 1.0f, 0.0f, 0.0f);
        public static final Interpolate[] CORNERS = new Interpolate[]{MIN_MIN_MIN, MIN_MIN_MAX, MIN_MAX_MIN, MIN_MAX_MAX, MAX_MAX_MAX, MAX_MAX_MIN, MAX_MIN_MAX, MAX_MIN_MIN};
        public static final Interpolate CENTER = new Interpolate(8, 0.5f, 0.5f, 0.5f);
        public static final Interpolate[] CORNERS_AND_CENTER = new Interpolate[]{MIN_MIN_MIN, MIN_MIN_MAX, MIN_MAX_MIN, MIN_MAX_MAX, MAX_MAX_MAX, MAX_MAX_MIN, MAX_MIN_MAX, MAX_MIN_MIN, CENTER};
        public final Float3 t;
        public final Byte idx;

        private Interpolate(byte idx, float tx, float ty, float tz, byte ox, byte oy, byte oz) {
            this.t = Float3.of(tx, ty, tz);
            this.idx = idx;
        }

        private Interpolate(byte idx, float tx, float ty, float tz) {
            this(idx, tx, ty, tz, idx, idx, idx);
        }

        public Interpolate(float tx, float ty, float tz) {
            this(-1, tx, ty, tz);
        }

        public Interpolate opposite() {
            if (this.idx >= 0 && this.idx < CORNERS.length) {
                return CORNERS[(this.idx + 4) % CORNERS.length];
            }
            if (this.idx == Interpolate.CENTER.idx) {
                return CENTER;
            }
            return new Interpolate(-1, (float)(1.0 - this.t.x), (float)(1.0 - this.t.y), (float)(1.0 - this.t.z));
        }

        public Interpolate oppositeX() {
            if (this.idx == Interpolate.CENTER.idx) {
                return CENTER;
            }
            int cx = CORNERS.length - this.idx - 1;
            return CORNERS_AND_CENTER[cx];
        }

        public Interpolate oppositeY() {
            if (this.idx == Interpolate.CENTER.idx) {
                return CENTER;
            }
            int cy = (1 - this.idx % 4 / 2) * 2 + this.idx % 2 + 4 * (this.idx / 4);
            return CORNERS_AND_CENTER[cy];
        }

        public Interpolate oppositeZ() {
            if (this.idx == Interpolate.CENTER.idx) {
                return CENTER;
            }
            int cz = this.idx - 2 * Math.abs(this.idx % 2) + 1;
            return CORNERS_AND_CENTER[cz];
        }

        public Float3 lerp(Float3 min, Float3 max) {
            return Interpolate.lerp(this.t, min, max);
        }

        public Float3 blockAlignedLerp(Float3 min, Float3 max) {
            return Interpolate.blockAlignedLerp(this.t, min, max);
        }

        public static Float3 lerp(Float3 t, Float3 min, Float3 max) {
            return Float3.of(Interpolate.lerp(t.x, min.x, max.x), Interpolate.lerp(t.y, min.y, max.y), Interpolate.lerp(t.z, min.z, max.z));
        }

        public static Float3 blockAlignedLerp(Float3 t, Float3 min, Float3 max) {
            return Float3.blockAligned(Interpolate.lerp(t.x, min.x, max.x), Interpolate.lerp(t.y, min.y, max.y), Interpolate.lerp(t.z, min.z, max.z));
        }

        public static Float3 lerp(double t, Float3 min, Float3 max) {
            return Float3.of(Interpolate.lerp(t, min.x, max.x), Interpolate.lerp(t, min.y, max.y), Interpolate.lerp(t, min.z, max.z));
        }

        public static double lerp(double t, double min, double max) {
            return t * max + (1.0 - t) * min;
        }
    }
}

