/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.registry;

import java.util.function.Supplier;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.veroxuniverse.samurai_dynasty.block.DragonBlock;
import net.veroxuniverse.samurai_dynasty.block.RoofBlock;
import net.veroxuniverse.samurai_dynasty.block.StatueBlock;
import net.veroxuniverse.samurai_dynasty.registry.ItemsRegistry;

public class BlocksRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"samurai_dynasty");
    public static final RegistryObject<Block> RUBY_ORE = BlocksRegistry.registerBlock("ruby_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> DEEPSLATE_RUBY_ORE = BlocksRegistry.registerBlock("deepslate_ruby_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> JADE_ORE = BlocksRegistry.registerBlock("jade_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> DEEPSLATE_JADE_ORE = BlocksRegistry.registerBlock("deepslate_jade_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> AQUAMARINE_ORE = BlocksRegistry.registerBlock("aquamarine_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> DEEPSLATE_AQUAMARINE_ORE = BlocksRegistry.registerBlock("deepslate_aquamarine_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> ONYX_ORE = BlocksRegistry.registerBlock("onyx_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> DEEPSLATE_ONYX_ORE = BlocksRegistry.registerBlock("deepslate_onyx_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> SILVER_ORE = BlocksRegistry.registerBlock("silver_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> DEEPSLATE_SILVER_ORE = BlocksRegistry.registerBlock("deepslate_silver_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> RUBY_BLOCK = BlocksRegistry.registerBlock("ruby_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> JADE_BLOCK = BlocksRegistry.registerBlock("jade_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> AQUAMARINE_BLOCK = BlocksRegistry.registerBlock("aquamarine_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> ONYX_BLOCK = BlocksRegistry.registerBlock("onyx_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> SILVER_BLOCK = BlocksRegistry.registerBlock("silver_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> STEEL_BLOCK = BlocksRegistry.registerBlock("steel_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> SPIRIT_STONE_BASE = BlocksRegistry.registerBlock("spirit_stone_base", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> SPIRIT_STONE = BlocksRegistry.registerBlock("spirit_stone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> SPIRIT_STONE_STAIRS = BlocksRegistry.registerBlock("spirit_stone_stairs", () -> new StairBlock(() -> ((Block)SPIRIT_STONE.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50635_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> SPIRIT_STONE_SLAB = BlocksRegistry.registerBlock("spirit_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> SPIRIT_STONE_WALL = BlocksRegistry.registerBlock("spirit_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50274_)));
    public static final RegistryObject<Block> MOSSY_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("mossy_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> MOSSY_SPIRIT_STONE_BRICK_STAIRS = BlocksRegistry.registerBlock("mossy_spirit_stone_brick_stairs", () -> new StairBlock(() -> ((Block)MOSSY_SPIRIT_STONE_BRICKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50635_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> MOSSY_SPIRIT_STONE_BRICK_SLAB = BlocksRegistry.registerBlock("mossy_spirit_stone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> MOSSY_SPIRIT_STONE_BRICK_WALL = BlocksRegistry.registerBlock("mossy_spirit_stone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50274_)));
    public static final RegistryObject<Block> DRAGON_SPIRIT_STONE = BlocksRegistry.registerBlock("dragon_spirit_stone", () -> new DragonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> POLISHED_SPIRIT_STONE = BlocksRegistry.registerBlock("polished_spirit_stone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> POLISHED_SPIRIT_STONE_STAIRS = BlocksRegistry.registerBlock("polished_spirit_stone_stairs", () -> new StairBlock(() -> ((Block)POLISHED_SPIRIT_STONE.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50635_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> POLISHED_SPIRIT_STONE_SLAB = BlocksRegistry.registerBlock("polished_spirit_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> POLISHED_SPIRIT_STONE_WALL = BlocksRegistry.registerBlock("polished_spirit_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50274_)));
    public static final RegistryObject<Block> CHISELED_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("chiseled_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> CHISELED_PATTERN_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("chiseled_pattern_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> MOSAIC_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("mosaic_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> PATTERN_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("pattern_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> PATTERN_MOSSY_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("pattern_mossy_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> PATH_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("path_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> TANUKI_STATUE = BlocksRegistry.registerBlock("tanuki_statue", () -> new StatueBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_().m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> KOMAINU_STATUE = BlocksRegistry.registerBlock("komainu_statue", () -> new StatueBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_().m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> KAWAUSO_STATUE = BlocksRegistry.registerBlock("kawauso_statue", () -> new StatueBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_().m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> STONE_ROOF = BlocksRegistry.registerBlock("stone_roof", () -> new RoofBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_().m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> STONE_ROOF_CORNER = BlocksRegistry.registerBlock("stone_roof_corner", () -> new RoofBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_().m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> STONE_ROOF_TOP = BlocksRegistry.registerBlock("stone_roof_top", () -> new RoofBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_().m_60978_(4.0f).m_60999_()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlocksRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithoutBlockItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ItemsRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

