/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.animatable.client.RenderProvider;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.veroxuniverse.samurai_dynasty.client.armors.samurai_armor.compat_armors.deeperdarker.SculkSamuraiArmorRenderer;
import net.veroxuniverse.samurai_dynasty.compat.DeeperDarkerCompat;
import net.veroxuniverse.samurai_dynasty.item.armor.lib.SamuraiArmorItem;
import net.veroxuniverse.samurai_dynasty.registry.ArmorMaterialsRegistry;
import org.jetbrains.annotations.NotNull;

public class SculkSamuraiArmorItem
extends SamuraiArmorItem {
    private final Multimap<Attribute, AttributeModifier> LEGGINGS_MODIFIERS;
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public SculkSamuraiArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier("Armor modifier", (double)material.m_7366_(type), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier("Armor toughness", (double)material.m_6651_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier("Armor knockback resistance", (double)this.f_40378_, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier("Leggings speed boost", 0.05, AttributeModifier.Operation.ADDITION));
        this.LEGGINGS_MODIFIERS = builder.build();
    }

    @Override
    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private SculkSamuraiArmorRenderer renderer;

            @NotNull
            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<LivingEntity> original) {
                if (this.renderer == null) {
                    this.renderer = new SculkSamuraiArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    @Override
    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return stack.m_150930_((Item)DeeperDarkerCompat.SCULK_SAMURAI_LEGGINGS.get()) && slot == EquipmentSlot.LEGS ? this.LEGGINGS_MODIFIERS : super.getAttributeModifiers(slot, stack);
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!level.m_5776_() && player.m_150109_().m_36052_(EquipmentSlot.HEAD.m_20749_()).m_150930_((Item)DeeperDarkerCompat.SCULK_SAMURAI_HELMET.get())) {
            if (player.m_21023_(MobEffects.f_19610_)) {
                player.m_21195_(MobEffects.f_19610_);
            }
            if (player.m_21023_(MobEffects.f_216964_)) {
                player.m_21195_(MobEffects.f_216964_);
            }
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return this.f_40379_ == ArmorMaterialsRegistry.SAMURAI_SCULK;
    }
}

