/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.item.armor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.animatable.client.RenderProvider;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.veroxuniverse.samurai_dynasty.client.armors.samurai_armor.compat_armors.bloodmagic.LivingSamuraiArmorRenderer;
import net.veroxuniverse.samurai_dynasty.compat.BloodMagicCompat;
import net.veroxuniverse.samurai_dynasty.item.armor.lib.SamuraiArmorItem;
import org.jetbrains.annotations.NotNull;
import wayoftime.bloodmagic.common.item.ArmorMaterialLiving;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.ExpandedArmor;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;

public class LivingSamuraiArmorItem
extends SamuraiArmorItem
implements ILivingContainer,
ExpandedArmor {
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public LivingSamuraiArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    @Override
    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private LivingSamuraiArmorRenderer renderer;

            @NotNull
            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<LivingEntity> original) {
                if (this.renderer == null) {
                    this.renderer = new LivingSamuraiArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    @Override
    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == BloodMagicItems.REAGENT_BINDING.get() || super.m_6832_(toRepair, repair);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        if (this != BloodMagicCompat.LIVING_SAMURAI_CHESTPLATE.get()) {
            return super.damageItem(stack, amount, entity, onBroken);
        }
        int durRemaining = stack.m_41776_() - 1 - stack.m_41773_();
        return Math.max(Math.min(durRemaining, amount), 0);
    }

    public void damageArmor(LivingEntity livingEntity, ItemStack stack, DamageSource source, float damage, EquipmentSlot slot) {
        if (slot == EquipmentSlot.CHEST && damage > (float)(this.m_41462_() - stack.m_41773_())) {
            livingEntity.m_6469_(livingEntity.m_269291_().m_269425_(), 2.0f);
            return;
        }
    }

    public boolean m_245993_(FeatureFlagSet pEnabledFeatures) {
        return super.m_245993_(pEnabledFeatures);
    }

    public InteractionResultHolder<ItemStack> m_269277_(Item pItem, Level pLevel, Player pPlayer, InteractionHand pHand) {
        return super.m_269277_(pItem, pLevel, pPlayer, pHand);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.putAll(super.getAttributeModifiers(slot, stack));
        if (slot != EquipmentSlot.CHEST) {
            return modifiers;
        }
        if (this.getMaxDamage(stack) - this.getDamage(stack) <= 1) {
            return modifiers;
        }
        LivingStats stats = this.getLivingStats(stack);
        if (stats == null) {
            return modifiers;
        }
        stats.getUpgrades().forEach((arg_0, arg_1) -> LivingSamuraiArmorItem.lambda$getAttributeModifiers$0(stats, (Multimap)modifiers, arg_0, arg_1));
        return modifiers;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        ILivingContainer.appendLivingTooltip((ItemStack)stack, (LivingStats)this.getLivingStats(stack), tooltip, (boolean)true);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return this.hasElytraUpgrade(stack, entity) && stack.m_41773_() < stack.m_41776_() - 1;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (!entity.m_9236_().f_46443_ && (flightTicks + 1) % 40 == 0) {
            stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
        }
        return true;
    }

    public boolean hasElytraUpgrade(ItemStack stack, LivingEntity entity) {
        if (stack.m_41720_() instanceof LivingSamuraiArmorItem && entity instanceof Player && LivingUtil.hasFullSet((Player)((Player)entity))) {
            return LivingStats.fromPlayer((Player)((Player)entity), (boolean)true).getLevel(((LivingUpgrade)LivingArmorRegistrar.UPGRADE_ELYTRA.get()).getKey()) > 0;
        }
        return false;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return this.f_40379_ == ArmorMaterialLiving.INSTANCE;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(LivingStats stats, Multimap modifiers, LivingUpgrade k, Double v) {
        if (k.getAttributeProvider() != null) {
            k.getAttributeProvider().handleAttributes(stats, modifiers, UUID.nameUUIDFromBytes(k.getKey().toString().getBytes()), k, k.getLevel(v.intValue()));
        }
    }
}

