/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.entity.custom;

import javax.annotation.Nullable;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.veroxuniverse.samurai_dynasty.entity.ModEntityTypes;
import net.veroxuniverse.samurai_dynasty.registry.ItemsRegistry;
import org.jetbrains.annotations.NotNull;

public class ThrownShurikenEntity
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownShurikenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @NotNull
    private ItemStack shurikenItem = new ItemStack((ItemLike)ItemsRegistry.SHURIKEN.get());
    private boolean dealtDamage;
    private float playerYaw;
    private float playerPitch;
    private float SHURIKEN_DAMAGE = 6.0f;

    public ThrownShurikenEntity(EntityType<? extends ThrownShurikenEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ThrownShurikenEntity(Level pLevel, LivingEntity pShooter, ItemStack pStack) {
        super((EntityType)ModEntityTypes.SHURIKEN.get(), pShooter, pLevel);
        this.shurikenItem = pStack.m_41777_();
        this.f_19804_.m_135381_(ID_FOIL, (Object)pStack.m_41790_());
        this.m_5602_((Entity)pShooter);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        super.m_8119_();
        double dx = this.m_20184_().m_7096_();
        double dy = this.m_20184_().m_7098_();
        double dz = this.m_20184_().m_7094_();
        float horizontalDistance = Mth.m_14116_((float)((float)(dx * dx + dz * dz)));
        this.m_146922_((float)(Mth.m_14136_((double)dx, (double)dz) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)dy, (double)horizontalDistance) * 57.29577951308232));
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)((Item)ItemsRegistry.SHURIKEN.get()).m_5456_());
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.dealtDamage ? null : super.m_6351_(pStartVec, pEndVec);
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        entity.m_6469_(entity.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.SHURIKEN_DAMAGE);
    }

    protected boolean m_142470_(Player pPlayer) {
        return super.m_142470_(pPlayer) || this.m_36797_() && this.m_150171_((Entity)pPlayer) && pPlayer.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player pEntity) {
        if (this.m_150171_((Entity)pEntity) || this.m_19749_() == null) {
            super.m_6123_(pEntity);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("Shuriken", 10)) {
            this.shurikenItem = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Shuriken"));
        }
        this.dealtDamage = pCompound.m_128471_("DealtDamage");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("Shuriken", (Tag)this.shurikenItem.m_41739_(new CompoundTag()));
        pCompound.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        }
    }

    public void m_37251_(Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        super.m_37251_(pShooter, pX, pY, pZ, pVelocity, pInaccuracy);
        this.playerYaw = pShooter.m_6080_();
        this.playerPitch = pShooter.m_146909_();
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<ThrownShurikenEntity> animationState) {
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

