/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.plants;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.NetherBiomeBuilder;
import org.betterx.betternether.world.features.AnchorTreeFeature;
import org.betterx.betternether.world.structures.IStructure;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class LegacyStructureAnchorTree
implements IStructure {
    protected static final OpenSimplexNoise NOISE = new OpenSimplexNoise(2145L);

    @Override
    public void generate(ServerLevelAccessor world, BlockPos pos, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if (this.canGenerate(pos)) {
            this.grow(world, pos, pos.m_6625_(BlocksHelper.downRay((LevelAccessor)world, pos, MAX_HEIGHT)), random, MAX_HEIGHT, context);
        }
    }

    private boolean canGenerate(BlockPos pos) {
        return (pos.m_123341_() & 0xF) == 7 && (pos.m_123343_() & 0xF) == 7;
    }

    private void grow(ServerLevelAccessor level, BlockPos up, BlockPos down, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int HEIGHT_90;
        int HEIGHT_45;
        int HEIGHT_64;
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        if (NetherBiomeBuilder.useLegacyGeneration) {
            HEIGHT_64 = MAX_HEIGHT / 2;
            HEIGHT_45 = (int)((double)MAX_HEIGHT * 0.36);
            HEIGHT_90 = (int)((double)MAX_HEIGHT * 0.7);
        } else {
            HEIGHT_64 = (int)((double)MAX_HEIGHT / 2.0 + (double)MHelper.nextFloat(random, 10.0f * scale_factor));
            HEIGHT_45 = (int)(40.0f + MHelper.nextFloat(random, 7.0f * scale_factor));
            HEIGHT_90 = (int)((double)MAX_HEIGHT / 2.0 + (double)MHelper.nextFloat(random, 15.0f * scale_factor));
        }
        if (up.m_123342_() - down.m_123342_() < 30) {
            return;
        }
        int pd = BlocksHelper.downRay((LevelAccessor)level, down, MAX_HEIGHT) + 1;
        for (int i = 0; i < 5; ++i) {
            Block block = level.m_8055_(down.m_6625_(pd + i)).m_60734_();
            if (block != Blocks.f_50197_ && block != NetherBlocks.NETHER_BRICK_TILE_LARGE && block != NetherBlocks.NETHER_BRICK_TILE_SMALL) continue;
            return;
        }
        BlockPos trunkTop = this.lerp(down, up, 0.6);
        BlockPos trunkBottom = this.lerp(down, up, 0.3);
        int count = (trunkTop.m_123342_() - trunkBottom.m_123342_()) / 7;
        if (count < 2) {
            count = 2;
        }
        List<BlockPos> blocks = this.line(trunkBottom, trunkTop, count, random, 2.5);
        context.BLOCKS.clear();
        this.buildLine(blocks, 4.0, context);
        count = (up.m_123342_() - down.m_123342_()) / 10 - 1;
        if (count < 3) {
            count = 3;
        }
        this.buildBigCircle(trunkTop, 15, count, 2, random.m_188500_() * Math.PI * 2.0, 3.5, random, context);
        this.buildBigCircle(trunkBottom, -15, count, 2, random.m_188500_() * Math.PI * 2.0, 3.5, random, context);
        int offset = random.m_188503_(4);
        int minBuildHeight = level.m_141937_() + 1;
        BoundingBox blockBox = BlocksHelper.decorationBounds((LevelAccessor)level, up, minBuildHeight, MAX_HEIGHT - 2);
        for (BlockPos bpos : context.BLOCKS) {
            BlockState state;
            if (!blockBox.m_71051_((Vec3i)bpos) || !BlocksHelper.isNetherGround(state = level.m_8055_(bpos)) && !state.m_247087_()) continue;
            boolean blockUp = context.BLOCKS.contains(bpos.m_7494_());
            if (blockUp && context.BLOCKS.contains(bpos.m_7495_())) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, bpos, NetherBlocks.MAT_ANCHOR_TREE.getLog().m_49966_());
            } else {
                BlocksHelper.setWithUpdate((LevelAccessor)level, bpos, NetherBlocks.MAT_ANCHOR_TREE.getBark().m_49966_());
            }
            if (bpos.m_123342_() > HEIGHT_45 && bpos.m_123342_() < HEIGHT_90 && (bpos.m_123342_() & 3) == offset && NOISE.eval((double)bpos.m_123341_() * 0.1, (double)bpos.m_123342_() * 0.1, (double)bpos.m_123343_() * 0.1) > 0.0) {
                if (random.m_188503_((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.m_122012_())) {
                    LegacyStructureAnchorTree.makeMushroom(level, bpos.m_122012_(), random.m_188500_() * 3.0 + 1.5, blockBox);
                }
                if (random.m_188503_((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.m_122019_())) {
                    LegacyStructureAnchorTree.makeMushroom(level, bpos.m_122019_(), random.m_188500_() * 3.0 + 1.5, blockBox);
                }
                if (random.m_188503_((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.m_122029_())) {
                    LegacyStructureAnchorTree.makeMushroom(level, bpos.m_122029_(), random.m_188500_() * 3.0 + 1.5, blockBox);
                }
                if (random.m_188503_((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.m_122024_())) {
                    LegacyStructureAnchorTree.makeMushroom(level, bpos.m_122024_(), random.m_188500_() * 3.0 + 1.5, blockBox);
                }
            }
            if (bpos.m_123342_() <= HEIGHT_64) continue;
            if (!blockUp && level.m_8055_(bpos.m_7494_()).m_247087_()) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, bpos.m_7494_(), NetherBlocks.MOSS_COVER.m_49966_());
            }
            if (!(NOISE.eval((double)bpos.m_123341_() * 0.05, (double)bpos.m_123342_() * 0.05, (double)bpos.m_123343_() * 0.05) > 0.0)) continue;
            state = AnchorTreeFeature.wallPlants[random.m_188503_(AnchorTreeFeature.wallPlants.length)].m_49966_();
            BlockPos _pos = bpos.m_122012_();
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(_pos) && level.m_46859_(_pos) && _pos.m_123343_() >= blockBox.m_162398_()) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, _pos, (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.NORTH));
            }
            _pos = bpos.m_122019_();
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(_pos) && level.m_46859_(_pos) && _pos.m_123343_() <= blockBox.m_162401_()) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, _pos, (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.SOUTH));
            }
            _pos = bpos.m_122029_();
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(_pos) && level.m_46859_(_pos) && _pos.m_123341_() <= blockBox.m_162399_()) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, _pos, (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.EAST));
            }
            _pos = bpos.m_122024_();
            if (random.m_188503_(8) != 0 || context.BLOCKS.contains(_pos) || !level.m_46859_(_pos) || _pos.m_123341_() < blockBox.m_162395_()) continue;
            BlocksHelper.setWithUpdate((LevelAccessor)level, _pos, (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.WEST));
        }
    }

    private void buildBigCircle(BlockPos pos, int length, int count, int iteration, double angle, double size, RandomSource random, StructureGeneratorThreadContext context) {
        if (iteration < 0) {
            return;
        }
        List<List<BlockPos>> lines = this.circleLinesEnds(pos, angle, count, length, (double)Math.abs(length) * 0.7, random);
        double sizeSmall = size * 0.8;
        length = (int)((double)length * 0.8);
        angle += Math.PI * 4 / (double)count;
        angle += random.m_188500_() * angle * 0.75;
        for (List<BlockPos> line : lines) {
            this.buildLine(line, size, context);
            this.buildBigCircle(line.get(1), length, count, iteration - 1, angle, sizeSmall, random, context);
        }
    }

    private void buildLine(List<BlockPos> blocks, double radius, StructureGeneratorThreadContext context) {
        for (int i = 0; i < blocks.size() - 1; ++i) {
            double max;
            BlockPos a = blocks.get(i);
            BlockPos b = blocks.get(i + 1);
            if (b.m_123342_() < a.m_123342_()) {
                BlockPos c = b;
                b = a;
                a = c;
            }
            if ((max = (double)(b.m_123342_() - a.m_123342_())) < 1.0) {
                max = 1.0;
            }
            for (int y = a.m_123342_(); y <= b.m_123342_(); ++y) {
                this.cylinder(this.lerpCos(a, b, y, (double)(y - a.m_123342_()) / max), radius, context);
            }
        }
    }

    private BlockPos lerp(BlockPos start, BlockPos end, double mix) {
        double x = Mth.m_14139_((double)mix, (double)start.m_123341_(), (double)end.m_123341_());
        double y = Mth.m_14139_((double)mix, (double)start.m_123342_(), (double)end.m_123342_());
        double z = Mth.m_14139_((double)mix, (double)start.m_123343_(), (double)end.m_123343_());
        return new BlockPos((int)x, (int)y, (int)z);
    }

    private BlockPos lerpCos(BlockPos start, BlockPos end, int y, double mix) {
        double v = this.lcos(mix);
        double x = Mth.m_14139_((double)v, (double)start.m_123341_(), (double)end.m_123341_());
        double z = Mth.m_14139_((double)v, (double)start.m_123343_(), (double)end.m_123343_());
        return new BlockPos((int)x, y, (int)z);
    }

    private double lcos(double mix) {
        return Mth.m_14008_((double)(0.5 - Math.cos(mix * Math.PI) * 0.5), (double)0.0, (double)1.0);
    }

    private List<BlockPos> line(BlockPos start, BlockPos end, int count, RandomSource random, double range) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(count);
        int max = count - 1;
        result.add(start);
        for (int i = 1; i < max; ++i) {
            double delta = (double)i / (double)max;
            double x = Mth.m_14139_((double)delta, (double)start.m_123341_(), (double)end.m_123341_()) + random.m_188583_() * range;
            double y = Mth.m_14139_((double)delta, (double)start.m_123342_(), (double)end.m_123342_());
            double z = Mth.m_14139_((double)delta, (double)start.m_123343_(), (double)end.m_123343_()) + random.m_188583_() * range;
            result.add(new BlockPos((int)x, (int)y, (int)z));
        }
        result.add(end);
        return result;
    }

    private void cylinder(BlockPos pos, double radius, StructureGeneratorThreadContext context) {
        int x1 = MHelper.floor((double)pos.m_123341_() - radius);
        int z1 = MHelper.floor((double)pos.m_123343_() - radius);
        int x2 = MHelper.floor((double)pos.m_123341_() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.m_123343_() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.m_123341_();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.m_123343_();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius * (NOISE.eval((double)x * 0.5, (double)pos.m_123342_() * 0.5, (double)z * 0.5) * 0.25 + 0.75))) continue;
                context.BLOCKS.add(new BlockPos(x, pos.m_123342_(), z));
            }
        }
    }

    private List<List<BlockPos>> circleLinesEnds(BlockPos pos, double startAngle, int count, int height, double radius, RandomSource random) {
        ArrayList<List<BlockPos>> result = new ArrayList<List<BlockPos>>(count);
        double angle = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.m_123341_() + Math.sin(startAngle) * radius;
            double z = (double)pos.m_123343_() + Math.cos(startAngle) * radius;
            BlockPos end = new BlockPos((int)x, (int)((double)(pos.m_123342_() + height) + (double)height * random.m_188500_() * 0.5), (int)z);
            ArrayList<BlockPos> elem = new ArrayList<BlockPos>(2);
            elem.add(pos);
            elem.add(end);
            result.add(elem);
            startAngle += angle;
        }
        return result;
    }

    protected static void makeMushroom(ServerLevelAccessor world, BlockPos pos, double radius, BoundingBox bounds) {
        if (!world.m_8055_(pos).m_247087_()) {
            return;
        }
        int x1 = MHelper.floor((double)pos.m_123341_() - radius);
        int z1 = MHelper.floor((double)pos.m_123343_() - radius);
        int x2 = MHelper.floor((double)pos.m_123341_() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.m_123343_() + radius + 1.0);
        radius *= radius;
        ArrayList<BlockPos> placed = new ArrayList<BlockPos>((int)(radius * 4.0));
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.m_123341_();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                BlockPos p;
                int pz2 = z - pos.m_123343_();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius) || !world.m_8055_(p = new BlockPos(x, pos.m_123342_(), z)).m_247087_() || !bounds.m_71051_((Vec3i)p)) continue;
                placed.add(p);
            }
        }
        for (BlockPos p : placed) {
            boolean north = world.m_8055_(p.m_122012_()).m_60734_() != NetherBlocks.GIANT_LUCIS;
            boolean south = world.m_8055_(p.m_122019_()).m_60734_() != NetherBlocks.GIANT_LUCIS;
            boolean east = world.m_8055_(p.m_122029_()).m_60734_() != NetherBlocks.GIANT_LUCIS;
            boolean west = world.m_8055_(p.m_122024_()).m_60734_() != NetherBlocks.GIANT_LUCIS;
            BlockState state = NetherBlocks.GIANT_LUCIS.m_49966_();
            BlocksHelper.setWithUpdate((LevelAccessor)world, p, (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(north))).m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(south))).m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(east))).m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(west)));
        }
    }
}

